/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml.xpath;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import net.sf.practicalxml.xpath.AbstractFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionResolver
implements XPathFunctionResolver {
    private Map<QName, FunctionHolder> _table = new HashMap<QName, FunctionHolder>();

    public FunctionResolver addFunction(AbstractFunction<?> func) {
        FunctionHolder holder = this._table.get(func.getQName());
        if (holder == null) {
            holder = new FunctionHolder(func);
            this._table.put(func.getQName(), holder);
        } else {
            holder.put(func);
        }
        return this;
    }

    public FunctionResolver addFunction(XPathFunction func, QName name) {
        return this.addFunction(func, name, 0, Integer.MAX_VALUE);
    }

    public FunctionResolver addFunction(XPathFunction func, QName name, int argCount) {
        return this.addFunction(func, name, argCount, argCount);
    }

    public FunctionResolver addFunction(XPathFunction func, QName name, int minArgCount, int maxArgCount) {
        return this.addFunction(new StandardFunctionAdapter(func, name, minArgCount, maxArgCount));
    }

    @Override
    public XPathFunction resolveFunction(QName functionName, int arity) {
        FunctionHolder holder = this._table.get(functionName);
        return holder != null ? holder.get(arity) : null;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FunctionResolver) {
            return ((Object)this._table).equals(((FunctionResolver)obj)._table);
        }
        return false;
    }

    public final int hashCode() {
        return ((Object)this._table.keySet()).hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StandardFunctionAdapter
    extends AbstractFunction<Object> {
        final XPathFunction _func;

        public StandardFunctionAdapter(XPathFunction func, QName name, int minArgCount, int maxArgCount) {
            super(name, minArgCount, maxArgCount);
            this._func = func;
        }

        @Override
        public Object evaluate(List args) throws XPathFunctionException {
            return this._func.evaluate(args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionHolder {
        private AbstractFunction<?> _onlyOne;
        private TreeSet<AbstractFunction<?>> _hasMany;

        public FunctionHolder(AbstractFunction<?> initial) {
            this._onlyOne = initial;
        }

        public void put(AbstractFunction<?> func) {
            if (this._hasMany != null) {
                this._hasMany.remove(func);
                this._hasMany.add(func);
            } else if (this._onlyOne.equals(func)) {
                this._onlyOne = func;
            } else {
                this._hasMany = new TreeSet();
                this._hasMany.add(func);
                this._hasMany.add(this._onlyOne);
                this._onlyOne = null;
            }
        }

        public AbstractFunction<?> get(int arity) {
            if (this._onlyOne != null) {
                return this._onlyOne.isArityMatch(arity) ? this._onlyOne : null;
            }
            for (AbstractFunction<?> func : this._hasMany) {
                if (!func.isArityMatch(arity)) continue;
                return func;
            }
            return null;
        }

        public boolean equals(Object obj) {
            FunctionHolder that = (FunctionHolder)obj;
            return this._onlyOne != null ? this._onlyOne.equals(that._onlyOne) : this._hasMany.equals(that._hasMany);
        }

        public int hashCode() {
            return 0;
        }
    }
}

