/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import net.sf.practicalxml.XmlException;
import net.sf.practicalxml.util.ExceptionErrorHandler;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ParseUtil {
    public static Document parse(InputSource source, ErrorHandler errHandler) {
        DocumentBuilder db = ParseUtil.newNVDocumentBuilder();
        if (errHandler != null) {
            db.setErrorHandler(errHandler);
        }
        try {
            return db.parse(source);
        }
        catch (IOException e) {
            throw new XmlException("unable to parse", e);
        }
        catch (SAXException e) {
            throw new XmlException("unable to parse", e);
        }
    }

    public static Document parse(InputSource source) {
        return ParseUtil.parse(source, new ExceptionErrorHandler());
    }

    public static Document parse(String xml) {
        return ParseUtil.parse(new InputSource(new StringReader(xml)));
    }

    public static Document parse(File file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            Document document = ParseUtil.parse(new InputSource(in));
            return document;
        }
        catch (IOException ex) {
            throw new XmlException("unable to parse: " + file, ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    public static Document validatingParse(InputSource source, EntityResolver resolver, ErrorHandler errHandler) {
        DocumentBuilder db = ParseUtil.newDTDDocumentBuilder();
        if (resolver != null) {
            db.setEntityResolver(resolver);
        }
        if (errHandler != null) {
            db.setErrorHandler(errHandler);
        }
        try {
            return db.parse(source);
        }
        catch (IOException e) {
            throw new XmlException("unable to parse", e);
        }
        catch (SAXException e) {
            throw new XmlException("unable to parse", e);
        }
    }

    public static Document validatingParse(InputSource source, ErrorHandler errHandler) {
        return ParseUtil.validatingParse(source, (EntityResolver)null, errHandler);
    }

    public static Document validatingParse(InputSource source, Schema schema, ErrorHandler errHandler) {
        DocumentBuilder db = ParseUtil.newXSDDocumentBuilder(schema);
        if (errHandler != null) {
            db.setErrorHandler(errHandler);
        }
        try {
            return db.parse(source);
        }
        catch (IOException e) {
            throw new XmlException("unable to parse", e);
        }
        catch (SAXException e) {
            throw new XmlException("unable to parse", e);
        }
    }

    private static synchronized DocumentBuilder newNVDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setValidating(false);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XmlException("unable to confiure parser", e);
        }
    }

    private static synchronized DocumentBuilder newDTDDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        dbf.setCoalescing(true);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XmlException("unable to confiure parser", e);
        }
    }

    private static synchronized DocumentBuilder newXSDDocumentBuilder(Schema schema) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setValidating(false);
        dbf.setSchema(schema);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XmlException("unable to configure parser", e);
        }
    }
}

