/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml.xpath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.practicalxml.DomUtil;
import net.sf.practicalxml.XmlException;
import net.sf.practicalxml.xpath.AbstractFunction;
import net.sf.practicalxml.xpath.FunctionResolver;
import net.sf.practicalxml.xpath.NamespaceResolver;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathWrapper
implements Cloneable {
    private final String _expr;
    private final NamespaceResolver _nsResolver = new NamespaceResolver();
    private Map<QName, Object> _variables = new HashMap<QName, Object>();
    private FunctionResolver _functions = new FunctionResolver();
    private XPathExpression _compiled;

    public XPathWrapper(String expr) {
        this._expr = expr;
    }

    public XPathWrapper bindNamespace(String prefix, String nsURI) {
        this._nsResolver.addNamespace(prefix, nsURI);
        return this;
    }

    public XPathWrapper bindDefaultNamespace(String nsURI) {
        this._nsResolver.setDefaultNamespace(nsURI);
        return this;
    }

    public XPathWrapper bindVariable(String name, Object value) {
        return this.bindVariable(new QName(name), value);
    }

    public XPathWrapper bindVariable(QName name, Object value) {
        this._variables.put(name, value);
        return this;
    }

    public XPathWrapper bindFunction(AbstractFunction<?> func) {
        this._functions.addFunction(func);
        return this;
    }

    public XPathWrapper bindFunction(AbstractFunction<?> func, String prefix) {
        this._functions.addFunction(func);
        return this.bindNamespace(prefix, func.getNamespaceUri());
    }

    public XPathWrapper bindFunction(QName name, XPathFunction func) {
        return this.bindFunction(name, func, 0, Integer.MAX_VALUE);
    }

    public XPathWrapper bindFunction(QName name, XPathFunction func, int arity) {
        return this.bindFunction(name, func, arity, arity);
    }

    public XPathWrapper bindFunction(QName name, XPathFunction func, int minArity, int maxArity) {
        this._functions.addFunction(func, name, minArity, maxArity);
        if (!"".equals(name.getPrefix())) {
            this.bindNamespace(name.getPrefix(), name.getNamespaceURI());
        }
        return this;
    }

    public List<Node> evaluate(Node context) {
        return DomUtil.asList(this.evaluate(context, XPathConstants.NODESET, NodeList.class), Node.class);
    }

    public <T> List<T> evaluate(Node context, Class<T> klass) {
        return DomUtil.filter(this.evaluate(context, XPathConstants.NODESET, NodeList.class), klass);
    }

    public Element evaluateAsElement(Node context) {
        NodeList nodelist = this.evaluate(context, XPathConstants.NODESET, NodeList.class);
        int size = nodelist.getLength();
        for (int ii = 0; ii < size; ++ii) {
            Node node = nodelist.item(ii);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    public String evaluateAsString(Node context) {
        return this.evaluate(context, XPathConstants.STRING, String.class);
    }

    public List<String> evaluateAsStringList(Node context) {
        List<Node> nodes = this.evaluate(context);
        ArrayList<String> result = new ArrayList<String>(nodes.size());
        for (Node node : nodes) {
            result.add(node.getTextContent());
        }
        return result;
    }

    public Number evaluateAsNumber(Node context) {
        return this.evaluate(context, XPathConstants.NUMBER, Number.class);
    }

    public Boolean evaluateAsBoolean(Node context) {
        return this.evaluate(context, XPathConstants.BOOLEAN, Boolean.class);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof XPathWrapper) {
            XPathWrapper that = (XPathWrapper)obj;
            return this._expr.equals(that._expr) && this._nsResolver.equals(that._nsResolver) && ((Object)this._variables).equals(that._variables) && this._functions.equals(that._functions);
        }
        return false;
    }

    public int hashCode() {
        return this._expr.hashCode();
    }

    public String toString() {
        return this._expr;
    }

    protected XPathWrapper clone() throws CloneNotSupportedException {
        XPathWrapper newInstance = (XPathWrapper)super.clone();
        newInstance._compiled = null;
        return newInstance;
    }

    private void compileIfNeeded() {
        if (this._compiled != null) {
            return;
        }
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(this._nsResolver);
            xpath.setXPathVariableResolver(new MyVariableResolver());
            xpath.setXPathFunctionResolver(this._functions);
            this._compiled = xpath.compile(this._expr);
        }
        catch (XPathExpressionException ee) {
            throw new XmlException("unable to compile: " + this._expr, ee);
        }
    }

    private <T> T evaluate(Node context, QName returnType, Class<T> castTo) {
        this.compileIfNeeded();
        try {
            return castTo.cast(this._compiled.evaluate(context, returnType));
        }
        catch (Exception ee) {
            throw new XmlException("unable to evaluate: " + this._expr, ee);
        }
    }

    private class MyVariableResolver
    implements XPathVariableResolver {
        private MyVariableResolver() {
        }

        public Object resolveVariable(QName name) {
            return XPathWrapper.this._variables.get(name);
        }
    }
}

