/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.event;

import io.sentry.event.Breadcrumb;
import io.sentry.event.Event;
import io.sentry.event.Sdk;
import io.sentry.event.interfaces.SentryInterface;
import io.sentry.event.interfaces.SentryStackTraceElement;
import io.sentry.time.Clock;
import io.sentry.time.SystemClock;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBuilder {
    public static final String DEFAULT_PLATFORM = "java";
    public static final String DEFAULT_HOSTNAME = "unavailable";
    public static final long HOSTNAME_CACHE_DURATION = TimeUnit.HOURS.toMillis(5L);
    static final HostnameCache HOSTNAME_CACHE = new HostnameCache(HOSTNAME_CACHE_DURATION);
    private final Event event;
    private boolean alreadyBuilt = false;
    private Set<String> sdkIntegrations = new HashSet<String>();

    public EventBuilder() {
        this(UUID.randomUUID());
    }

    public EventBuilder(UUID eventId) {
        this.event = new Event(eventId);
    }

    private static String calculateChecksum(String string) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        CRC32 checksum = new CRC32();
        checksum.update(bytes, 0, bytes.length);
        return Long.toHexString(checksum.getValue()).toUpperCase();
    }

    private void autoSetMissingValues() {
        if (this.event.getTimestamp() == null) {
            this.event.setTimestamp(new Date());
        }
        if (this.event.getPlatform() == null) {
            this.event.setPlatform(DEFAULT_PLATFORM);
        }
        if (this.event.getSdk() == null) {
            this.event.setSdk(new Sdk("sentry-java", "1.7.30-7a445", this.sdkIntegrations));
        }
        if (this.event.getServerName() == null) {
            this.event.setServerName(HOSTNAME_CACHE.getHostname());
        }
    }

    private void makeImmutable() {
        this.event.setTags(Collections.unmodifiableMap(this.event.getTags()));
        this.event.setBreadcrumbs(Collections.unmodifiableList(this.event.getBreadcrumbs()));
        HashMap<String, Map<String, Object>> tempContexts = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> contextEntry : this.event.getContexts().entrySet()) {
            tempContexts.put(contextEntry.getKey(), Collections.unmodifiableMap(contextEntry.getValue()));
        }
        this.event.setContexts(Collections.unmodifiableMap(tempContexts));
        this.event.setExtra(Collections.unmodifiableMap(this.event.getExtra()));
        this.event.setSentryInterfaces(Collections.unmodifiableMap(this.event.getSentryInterfaces()));
    }

    public EventBuilder withMessage(String message) {
        this.event.setMessage(message);
        return this;
    }

    public EventBuilder withTimestamp(Date timestamp) {
        this.event.setTimestamp(timestamp);
        return this;
    }

    public EventBuilder withLevel(Event.Level level) {
        this.event.setLevel(level);
        return this;
    }

    public EventBuilder withRelease(String release) {
        this.event.setRelease(release);
        return this;
    }

    public EventBuilder withDist(String dist) {
        this.event.setDist(dist);
        return this;
    }

    public EventBuilder withEnvironment(String environment) {
        this.event.setEnvironment(environment);
        return this;
    }

    public EventBuilder withLogger(String logger) {
        this.event.setLogger(logger);
        return this;
    }

    public EventBuilder withPlatform(String platform) {
        this.event.setPlatform(platform);
        return this;
    }

    public EventBuilder withSdkIntegration(String integration) {
        this.sdkIntegrations.add(integration);
        return this;
    }

    @Deprecated
    public EventBuilder withCulprit(SentryStackTraceElement frame) {
        return this.withCulprit(this.buildCulpritString(frame.getModule(), frame.getFunction(), frame.getFileName(), frame.getLineno()));
    }

    @Deprecated
    public EventBuilder withCulprit(StackTraceElement frame) {
        return this.withCulprit(this.buildCulpritString(frame.getClassName(), frame.getMethodName(), frame.getFileName(), frame.getLineNumber()));
    }

    private String buildCulpritString(String className, String methodName, String fileName, int lineNumber) {
        StringBuilder sb = new StringBuilder();
        sb.append(className).append(".").append(methodName);
        if (fileName != null && !fileName.isEmpty()) {
            sb.append("(").append(fileName);
            if (lineNumber >= 0) {
                sb.append(":").append(lineNumber);
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Deprecated
    public EventBuilder withCulprit(String culprit) {
        this.event.setCulprit(culprit);
        return this;
    }

    public EventBuilder withTransaction(String transaction) {
        this.event.setTransaction(transaction);
        return this;
    }

    public EventBuilder withTag(String tagKey, String tagValue) {
        this.event.getTags().put(tagKey, tagValue);
        return this;
    }

    public EventBuilder withBreadcrumbs(List<Breadcrumb> breadcrumbs) {
        this.event.setBreadcrumbs(breadcrumbs);
        return this;
    }

    public EventBuilder withContexts(Map<String, Map<String, Object>> contexts) {
        this.event.setContexts(contexts);
        return this;
    }

    public EventBuilder withServerName(String serverName) {
        this.event.setServerName(serverName);
        return this;
    }

    public EventBuilder withExtra(String extraName, Object extraValue) {
        this.event.getExtra().put(extraName, extraValue);
        return this;
    }

    public EventBuilder withFingerprint(String ... fingerprint) {
        ArrayList<String> list = new ArrayList<String>(fingerprint.length);
        Collections.addAll(list, fingerprint);
        this.event.setFingerprint(list);
        return this;
    }

    public EventBuilder withFingerprint(List<String> fingerprint) {
        this.event.setFingerprint(fingerprint);
        return this;
    }

    public EventBuilder withChecksumFor(String contentToChecksum) {
        return this.withChecksum(EventBuilder.calculateChecksum(contentToChecksum));
    }

    public EventBuilder withChecksum(String checksum) {
        this.event.setChecksum(checksum);
        return this;
    }

    public EventBuilder withSentryInterface(SentryInterface sentryInterface) {
        return this.withSentryInterface(sentryInterface, true);
    }

    public EventBuilder withSentryInterface(SentryInterface sentryInterface, boolean replace) {
        if (replace || !this.event.getSentryInterfaces().containsKey(sentryInterface.getInterfaceName())) {
            this.event.getSentryInterfaces().put(sentryInterface.getInterfaceName(), sentryInterface);
        }
        return this;
    }

    public synchronized Event build() {
        if (this.alreadyBuilt) {
            throw new IllegalStateException("A message can't be built twice");
        }
        this.autoSetMissingValues();
        this.makeImmutable();
        this.alreadyBuilt = true;
        return this.event;
    }

    public Event getEvent() {
        return this.event;
    }

    public String toString() {
        return "EventBuilder{event=" + this.event + ", alreadyBuilt=" + this.alreadyBuilt + '}';
    }

    static final class HostnameCache {
        static final long GET_HOSTNAME_TIMEOUT = TimeUnit.SECONDS.toMillis(1L);
        private static final Logger logger = LoggerFactory.getLogger(HostnameCache.class);
        final long cacheDuration;
        volatile String hostname = "unavailable";
        volatile long expirationTimestamp;
        private AtomicBoolean updateRunning = new AtomicBoolean(false);
        private final Clock clock;
        private final Callable<InetAddress> getLocalhost;

        private HostnameCache(long cacheDuration) {
            this(cacheDuration, new SystemClock(), new Callable<InetAddress>(){

                @Override
                public InetAddress call() throws Exception {
                    return InetAddress.getLocalHost();
                }
            });
        }

        HostnameCache(long cacheDuration, Clock clock, Callable<InetAddress> getLocalhost) {
            this.cacheDuration = cacheDuration;
            this.clock = clock;
            this.getLocalhost = getLocalhost;
        }

        String getHostname() {
            if (this.expirationTimestamp < this.clock.millis() && this.updateRunning.compareAndSet(false, true)) {
                this.updateCache();
            }
            return this.hostname;
        }

        void updateCache() {
            Callable<Void> hostRetriever = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        HostnameCache.this.hostname = ((InetAddress)HostnameCache.this.getLocalhost.call()).getCanonicalHostName();
                        HostnameCache.this.expirationTimestamp = HostnameCache.this.clock.millis() + HostnameCache.this.cacheDuration;
                    }
                    finally {
                        HostnameCache.this.updateRunning.set(false);
                    }
                    return null;
                }
            };
            try {
                logger.debug("Updating the hostname cache");
                FutureTask<Void> futureTask = new FutureTask<Void>(hostRetriever);
                new Thread(futureTask).start();
                futureTask.get(GET_HOSTNAME_TIMEOUT, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.handleCacheUpdateFailure(e);
            }
            catch (RuntimeException | ExecutionException | TimeoutException e) {
                this.handleCacheUpdateFailure(e);
            }
        }

        private void handleCacheUpdateFailure(Exception failure) {
            this.expirationTimestamp = this.clock.millis() + TimeUnit.SECONDS.toMillis(1L);
            logger.debug("Localhost hostname lookup failed, keeping the value '{}'. If this persists it may mean your DNS is incorrectly configured and you may want to hardcode your server name: https://docs.sentry.io/clients/java/config/", (Object)this.hostname, (Object)failure);
        }

        void reset(long newExpirationTimestamp) {
            this.hostname = EventBuilder.DEFAULT_HOSTNAME;
            this.expirationTimestamp = newExpirationTimestamp;
        }
    }
}

