/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.sf.practicalxml.XmlException;
import net.sf.practicalxml.internal.StringUtils;

public class XmlUtil {
    private static final boolean[] LEGAL_CONTROL_CHARS = new boolean[]{false, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static ThreadLocal<DateFormat> _xsdDatetimeFormatter = new ThreadLocal();
    private static ThreadLocal<DecimalFormat> _xsdDecimalFormatter = new ThreadLocal();

    public static boolean isLegal(String s) {
        for (int ii = 0; ii < s.length(); ++ii) {
            if (XmlUtil.isLegal(s.charAt(ii))) continue;
            return false;
        }
        return true;
    }

    public static String stripIllegals(String s) {
        StringBuilder buf = null;
        for (int ii = 0; ii < s.length(); ++ii) {
            char c = s.charAt(ii);
            if (!XmlUtil.isLegal(c)) {
                if (buf != null) continue;
                buf = new StringBuilder(s.length());
                buf.append(s.substring(0, ii));
                continue;
            }
            if (buf == null) continue;
            buf.append(c);
        }
        return buf != null ? buf.toString() : s;
    }

    public static String formatXsdDatetime(Date date) {
        return XmlUtil.getXsdDatetimeFormatter().format(date);
    }

    public static Date parseXsdDatetime(String value) throws XmlException {
        try {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTimeInMillis(0L);
            int idx = XmlUtil.parserHelper(value, cal, 1, 0);
            idx = XmlUtil.parserHelper(value, cal, 2, idx + 1);
            idx = XmlUtil.parserHelper(value, cal, 5, idx + 1);
            idx = XmlUtil.parserHelper(value, cal, 11, idx + 1);
            idx = XmlUtil.parserHelper(value, cal, 12, idx + 1);
            idx = XmlUtil.parserHelper(value, cal, 13, idx + 1);
            if (idx < value.length() && value.charAt(idx) == '.') {
                idx = XmlUtil.parserHelper(value, cal, 14, idx + 1);
            }
            XmlUtil.parseTimezone(value, cal, idx);
            return cal.getTime();
        }
        catch (Exception ex) {
            throw new XmlException("unable to parse: " + value, ex);
        }
    }

    public static String formatXsdDecimal(double value) {
        return XmlUtil.formatXsdDecimal((Number)value);
    }

    public static String formatXsdDecimal(Number value) {
        if (value == null) {
            return "";
        }
        return XmlUtil.getXsdDecimalFormatter().format(value);
    }

    public static String formatXsdBoolean(boolean value) {
        return value ? "true" : "false";
    }

    public static boolean parseXsdBoolean(String value) {
        try {
            value = value.trim();
            if (value.equals("true") || value.equals("1")) {
                return true;
            }
            if (value.equals("false") || value.equals("0")) {
                return false;
            }
            throw new XmlException("not an XSD boolean value: " + value);
        }
        catch (NullPointerException e) {
            throw new XmlException("null values not allowed");
        }
    }

    public static String escape(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(s.length());
        boolean wasEscaped = false;
        block7: for (int ii = 0; ii < s.length(); ++ii) {
            char c = s.charAt(ii);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    wasEscaped = true;
                    continue block7;
                }
                case '<': {
                    buf.append("&lt;");
                    wasEscaped = true;
                    continue block7;
                }
                case '>': {
                    buf.append("&gt;");
                    wasEscaped = true;
                    continue block7;
                }
                case '\'': {
                    buf.append("&apos;");
                    wasEscaped = true;
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    wasEscaped = true;
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return wasEscaped ? buf.toString() : s;
    }

    public static String unescape(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(s.length() + 20);
        boolean wasEscaped = false;
        block3: for (int ii = 0; ii < s.length(); ++ii) {
            char c = s.charAt(ii);
            switch (c) {
                case '&': {
                    ii = XmlUtil.unescapeHelper(s, ii, buf);
                    wasEscaped = true;
                    continue block3;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return wasEscaped ? buf.toString() : s;
    }

    private static boolean isLegal(char c) {
        if (c < '\ud800') {
            return c < ' ' ? LEGAL_CONTROL_CHARS[c] : true;
        }
        return c >= '\ue000';
    }

    private static DateFormat getXsdDatetimeFormatter() {
        DateFormat format = _xsdDatetimeFormatter.get();
        if (format == null) {
            format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            _xsdDatetimeFormatter.set(format);
        }
        return format;
    }

    private static DecimalFormat getXsdDecimalFormatter() {
        DecimalFormat format = _xsdDecimalFormatter.get();
        if (format == null) {
            format = new DecimalFormat("#0.0################;-#");
            _xsdDecimalFormatter.set(format);
        }
        return format;
    }

    private static int parserHelper(String value, Calendar result, int fieldId, int index) {
        int endIndex = index;
        switch (fieldId) {
            case 1: {
                endIndex = value.indexOf(45, index + 1);
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                endIndex += 2;
                break;
            }
            case 14: {
                endIndex = value.indexOf(43, index);
                if (endIndex < 0) {
                    endIndex = value.indexOf(45, index);
                }
                if (endIndex < 0) {
                    endIndex = value.indexOf(90, index);
                }
                if (endIndex >= 0) break;
                endIndex = value.length();
            }
        }
        int fieldValue = Integer.parseInt(value.substring(index, endIndex));
        switch (fieldId) {
            case 2: {
                --fieldValue;
            }
        }
        result.set(fieldId, fieldValue);
        return endIndex;
    }

    private static void parseTimezone(String value, Calendar cal, int index) {
        String tz = "GMT";
        if (index < value.length()) {
            char tz0 = value.charAt(index);
            if (tz0 == '+' || tz0 == '-') {
                tz = "GMT" + value.substring(index);
            } else if (tz0 != 'Z' && tz0 != 'z') {
                throw new XmlException("invalid timezone designator: " + value.substring(index));
            }
        }
        cal.setTimeZone(TimeZone.getTimeZone(tz));
    }

    private static int unescapeHelper(String s, int curPos, StringBuilder buf) {
        try {
            char c;
            if (s.startsWith("&amp;", curPos)) {
                buf.append("&");
                return curPos + 4;
            }
            if (s.startsWith("&apos;", curPos)) {
                buf.append("'");
                return curPos + 5;
            }
            if (s.startsWith("&quot;", curPos)) {
                buf.append('\"');
                return curPos + 5;
            }
            if (s.startsWith("&lt;", curPos)) {
                buf.append("<");
                return curPos + 3;
            }
            if (s.startsWith("&gt;", curPos)) {
                buf.append(">");
                return curPos + 3;
            }
            if (s.startsWith("&#", curPos) && (c = XmlUtil.numericEntityHelper(s, curPos)) != '\u0000') {
                buf.append(c);
                return s.indexOf(59, curPos);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        buf.append('&');
        return curPos;
    }

    private static char numericEntityHelper(String s, int curPos) {
        char c;
        int value = 0;
        int multiplier = 10;
        if (s.charAt(curPos += 2) == 'x') {
            multiplier = 16;
            ++curPos;
        }
        for (int ii = 0; ii < 6 && (c = s.charAt(curPos + ii)) != ';'; ++ii) {
            int cVal = StringUtils.parseDigit(c, multiplier);
            if (cVal < 0) {
                return '\u0000';
            }
            value = value * multiplier + cVal;
        }
        if (value > 65535) {
            return '\u0000';
        }
        return (char)value;
    }
}

