/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.usertaskdata;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.RouterLink;
import io.flowset.control.entity.UserTaskData;
import io.flowset.control.service.usertask.UserTaskService;
import io.flowset.control.view.alltasks.AllTasksView;
import io.flowset.control.view.main.MainView;
import io.flowset.control.view.processdefinition.ProcessDefinitionDetailView;
import io.flowset.control.view.processinstance.ProcessInstanceDetailView;
import io.jmix.core.LoadContext;
import io.jmix.flowui.component.datetimepicker.TypedDateTimePicker;
import io.jmix.flowui.component.formlayout.JmixFormLayout;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.EditedEntityContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.StandardDetailView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpm/user-task/:id", layout=MainView.class)
@ViewController(value="bpm_UserTaskData.detail")
@ViewDescriptor(value="user-task-data-detail-view.xml")
@EditedEntityContainer(value="userTaskDataDc")
@DialogMode(maxWidth="80em", minWidth="40em", width="auto")
public class UserTaskDataDetailView
extends StandardDetailView<UserTaskData> {
    @Autowired
    protected UserTaskService userTaskService;
    @ViewComponent
    protected JmixFormLayout form;
    @ViewComponent
    protected TypedTextField<String> delegationStateField;
    @ViewComponent
    protected TypedDateTimePicker<Date> createTimeField;
    @ViewComponent
    protected TypedDateTimePicker<Date> lastUpdatedField;
    @ViewComponent
    protected TypedDateTimePicker<Date> startTimeField;
    @ViewComponent
    protected TypedDateTimePicker<Date> endTimeField;
    @ViewComponent
    protected TypedTextField<String> formKeyField;
    @ViewComponent
    protected TypedTextField<String> processDefinitionIdField;
    @ViewComponent
    protected TypedTextField<String> processInstanceIdField;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-xs"});
        this.form.getOwnComponents().forEach(component -> component.addClassNames(new String[]{"pt-s"}));
        if (event.getSource() instanceof AllTasksView) {
            this.processDefinitionIdField.setVisible(true);
            this.processInstanceIdField.setVisible(true);
        }
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        Date endTime = ((UserTaskData)this.getEditedEntity()).getEndTime();
        if (endTime != null) {
            this.delegationStateField.setVisible(false);
            this.createTimeField.setVisible(false);
            this.lastUpdatedField.setVisible(false);
            this.formKeyField.setVisible(false);
        } else {
            this.startTimeField.setVisible(false);
            this.endTimeField.setVisible(false);
        }
    }

    @Install(to="userTaskDataDl", target=Target.DATA_LOADER)
    protected UserTaskData customerDlLoadDelegate(LoadContext<UserTaskData> loadContext) {
        String taskId = (String)loadContext.getId();
        return this.userTaskService.findTaskById(taskId);
    }

    @Subscribe(id="viewProcessInstance", subject="clickListener")
    public void onViewProcessInstanceClick(ClickEvent<JmixButton> event) {
        RouterLink routerLink = new RouterLink(ProcessInstanceDetailView.class, new RouteParameters("id", ((UserTaskData)this.getEditedEntity()).getProcessInstanceId()));
        this.getUI().ifPresent(ui -> ui.getPage().open(routerLink.getHref()));
    }

    @Subscribe(id="viewProcessDefinition", subject="clickListener")
    public void onViewProcessDefinitionClick(ClickEvent<JmixButton> event) {
        RouterLink routerLink = new RouterLink(ProcessDefinitionDetailView.class, new RouteParameters("id", ((UserTaskData)this.getEditedEntity()).getProcessDefinitionId()));
        this.getUI().ifPresent(ui -> ui.getPage().open(routerLink.getHref()));
    }
}

