/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processinstance.runtime;

import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.event.SortEvent;
import io.flowset.control.entity.filter.JobFilter;
import io.flowset.control.entity.job.JobData;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.service.job.JobLoadContext;
import io.flowset.control.service.job.JobService;
import io.flowset.control.view.incidentdata.RetryJobView;
import io.flowset.control.view.processinstance.event.JobCountUpdateEvent;
import io.flowset.control.view.processinstance.event.JobRetriesUpdateEvent;
import io.jmix.core.DataLoadContext;
import io.jmix.core.LoadContext;
import io.jmix.core.Messages;
import io.jmix.core.Metadata;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.Dialogs;
import io.jmix.flowui.UiEventPublisher;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.model.CollectionContainer;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.DialogWindow;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.ViewComponent;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;

@FragmentDescriptor(value="jobs-tab-fragment.xml")
public class JobsTabFragment
extends Fragment<VerticalLayout> {
    @Autowired
    protected JobService jobService;
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected UiEventPublisher uiEventPublisher;
    @Autowired
    protected DialogWindows dialogWindows;
    @Autowired
    protected ViewNavigators viewNavigators;
    @Autowired
    protected Dialogs dialogs;
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected Messages messages;
    @ViewComponent
    protected CollectionLoader<JobData> runtimeJobsDl;
    @ViewComponent
    protected CollectionContainer<JobData> runtimeJobsDc;
    @ViewComponent
    protected DataGrid<JobData> runtimeJobsGrid;
    @ViewComponent
    protected InstanceContainer<ProcessInstanceData> processInstanceDataDc;
    protected JobFilter filter;
    protected boolean initialized = false;

    public void refreshIfRequired() {
        if (!this.initialized) {
            this.filter = (JobFilter)this.metadata.create(JobFilter.class);
            this.filter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getId());
            this.runtimeJobsDl.load();
            this.initialized = true;
        }
    }

    @Install(to="runtimeJobsDl", target=Target.DATA_LOADER)
    protected List<JobData> runtimeJobsDlLoadDelegate(LoadContext<JobData> loadContext) {
        LoadContext.Query query = loadContext.getQuery();
        JobLoadContext context = new JobLoadContext().setFilter(this.filter);
        if (query != null) {
            context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        return this.jobService.findAll(context);
    }

    @Install(to="jobsPagination", subject="totalCountDelegate")
    protected Integer jobsPaginationTotalCountDelegate(DataLoadContext dataLoadContext) {
        long count = this.jobService.getCount(this.filter);
        this.uiEventPublisher.publishEventForCurrentUI((ApplicationEvent)new JobCountUpdateEvent((Object)this, count));
        return (int)count;
    }

    @Subscribe(value="runtimeJobsGrid.edit")
    public void onRuntimeJobsEdit(ActionPerformedEvent event) {
        JobData selectedJob = (JobData)this.runtimeJobsGrid.getSingleSelectedItem();
        if (selectedJob == null) {
            return;
        }
        this.dialogWindows.detail(UiComponentUtils.getCurrentView(), JobData.class).editEntity((Object)selectedJob).withAfterCloseListener(afterCloseEvent -> {
            if (afterCloseEvent.closedWith(StandardOutcome.SAVE)) {
                this.reloadJobs();
            }
        }).build().open();
    }

    @Subscribe(value="runtimeJobsGrid")
    public void onRuntimeJobsGridSort(SortEvent<DataGrid<JobData>, GridSortOrder<DataGrid<JobData>>> event) {
        this.runtimeJobsDl.load();
    }

    @Install(to="runtimeJobsGrid.retries", subject="partNameGenerator")
    protected String runtimeJobsGridRetriesPartNameGenerator(JobData jobData) {
        return jobData.getRetries() != null && jobData.getRetries() == 0 ? "error-cell" : null;
    }

    @Install(to="runtimeJobsGrid.retry", subject="enabledRule")
    protected boolean runtimeJobsGridRetryEnabledRule() {
        JobData selectedJob = (JobData)this.runtimeJobsGrid.getSingleSelectedItem();
        return selectedJob != null && selectedJob.getRetries() != null && selectedJob.getRetries() == 0;
    }

    @Subscribe(value="runtimeJobsGrid.retry")
    public void onRuntimeJobsGridRetry(ActionPerformedEvent event) {
        JobData selectedJob = (JobData)this.runtimeJobsGrid.getSingleSelectedItem();
        if (selectedJob == null) {
            return;
        }
        DialogWindow dialogWindow = this.dialogWindows.view(UiComponentUtils.getCurrentView(), RetryJobView.class).withAfterCloseListener(afterClose -> {
            if (afterClose.closedWith(StandardOutcome.SAVE)) {
                this.reloadJobs();
            }
        }).build();
        RetryJobView retryJobView = (RetryJobView)dialogWindow.getView();
        retryJobView.setJobId(selectedJob.getJobId());
        dialogWindow.open();
    }

    protected void reloadJobs() {
        this.runtimeJobsDl.load();
        this.uiEventPublisher.publishEventForCurrentUI((ApplicationEvent)new JobRetriesUpdateEvent((Object)this));
    }
}

