/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processinstance.history;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.function.SerializableSupplier;
import io.flowset.control.entity.filter.ActivityFilter;
import io.flowset.control.entity.filter.IncidentFilter;
import io.flowset.control.entity.filter.UserTaskFilter;
import io.flowset.control.entity.filter.VariableFilter;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.service.activity.ActivityService;
import io.flowset.control.service.incident.IncidentService;
import io.flowset.control.service.usertask.UserTaskService;
import io.flowset.control.service.variable.VariableService;
import io.flowset.control.view.processinstance.LazyTabContent;
import io.flowset.control.view.processinstance.event.HistoryActivityCountUpdateEvent;
import io.flowset.control.view.processinstance.event.HistoryIncidentCountUpdateEvent;
import io.flowset.control.view.processinstance.event.HistoryUserTaskCountUpdateEvent;
import io.flowset.control.view.processinstance.event.HistoryVariableCountUpdateEvent;
import io.flowset.control.view.processinstance.event.IncidentUpdateEvent;
import io.flowset.control.view.processinstance.event.JobRetriesUpdateEvent;
import io.flowset.control.view.processinstance.history.ActivitiesTabFragment;
import io.flowset.control.view.processinstance.history.HasRefresh;
import io.flowset.control.view.processinstance.history.HistoryIncidentsTabFragment;
import io.flowset.control.view.processinstance.history.HistoryUserTasksTabFragment;
import io.flowset.control.view.processinstance.history.HistoryVariablesTabFragment;
import io.jmix.core.Metadata;
import io.jmix.flowui.Fragments;
import io.jmix.flowui.component.tabsheet.JmixTabSheet;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.ViewComponent;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.lang.Nullable;

@FragmentDescriptor(value="history-tab-fragment.xml")
public class HistoryTabFragment
extends Fragment<JmixTabSheet> {
    public static final String USER_TASKS_TAB_ID = "historyTasksTab";
    public static final String VARIABLES_TAB_ID = "historyVariablesTab";
    public static final String INCIDENTS_TAB_ID = "historyIncidentsTab";
    public static final int ACTIVITIES_TAB_IDX = 0;
    public static final int USER_TASKS_TAB_IDX = 1;
    public static final int VARIABLES_TAB_IDX = 2;
    public static final int INCIDENTS_TAB_IDX = 3;
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected Fragments fragments;
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected ActivityService activityService;
    @Autowired
    protected VariableService variableService;
    @Autowired
    protected UserTaskService userTaskService;
    @Autowired
    protected IncidentService incidentService;
    @ViewComponent
    protected InstanceContainer<ProcessInstanceData> processInstanceDataDc;
    @ViewComponent
    protected JmixTabSheet historyTabsheet;
    @ViewComponent
    protected ActivitiesTabFragment activitiesFragment;
    protected boolean initialized = false;

    @Subscribe
    public void onReady(Fragment.ReadyEvent event) {
        this.initUserTasksTab();
        this.initVariablesTab();
        this.initIncidentsTab();
    }

    public void refresh() {
        if (!this.initialized) {
            this.loadAndUpdateActivitiesCount();
            this.loadAndUpdateUserTasksCount();
            this.loadAndUpdateVariablesCount();
            this.loadAndUpdateIncidentsCount();
            this.initialized = true;
        }
        this.historyTabsheet.setSelectedIndex(0);
        this.activitiesFragment.refreshIfRequired();
    }

    @Subscribe(value="historyTabsheet")
    public void onHistoryTabsheetSelectedChange(JmixTabSheet.SelectedChangeEvent event) {
        Tab selectedTab = event.getSelectedTab();
        Component tabContent = this.getTabContent(selectedTab);
        if (tabContent instanceof HasRefresh) {
            HasRefresh tabContentFragment = (HasRefresh)tabContent;
            tabContentFragment.refreshIfRequired();
        }
    }

    @EventListener
    public void handleActivityCountUpdate(HistoryActivityCountUpdateEvent event) {
        this.updateActivityTabCaption(event.getCount());
    }

    @EventListener
    public void handleUserTaskCountUpdate(HistoryUserTaskCountUpdateEvent event) {
        this.updateUserTasksTabCaption(event.getCount());
    }

    @EventListener
    public void handleVariableCountUpdate(HistoryVariableCountUpdateEvent event) {
        this.updateVariablesTabCaption(event.getCount());
    }

    @EventListener
    public void handleIncidentUpdate(IncidentUpdateEvent event) {
        this.loadAndUpdateIncidentsCount();
    }

    @EventListener
    public void handleJobRetriesUpdate(JobRetriesUpdateEvent event) {
        this.loadAndUpdateIncidentsCount();
    }

    @EventListener
    public void handleIncidentCountUpdate(HistoryIncidentCountUpdateEvent event) {
        this.updateIncidentTabCaption(event.getCount());
    }

    protected void loadAndUpdateActivitiesCount() {
        ActivityFilter activityFilter = (ActivityFilter)this.metadata.create(ActivityFilter.class);
        activityFilter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getId());
        long activitiesCount = this.activityService.getHistoryActivitiesCount(activityFilter);
        this.updateActivityTabCaption(activitiesCount);
    }

    protected void loadAndUpdateVariablesCount() {
        VariableFilter variableFilter = (VariableFilter)this.metadata.create(VariableFilter.class);
        variableFilter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getId());
        long variablesCount = this.variableService.getHistoricVariablesCount(variableFilter);
        this.updateVariablesTabCaption(variablesCount);
    }

    protected void loadAndUpdateIncidentsCount() {
        IncidentFilter incidentFilter = (IncidentFilter)this.metadata.create(IncidentFilter.class);
        incidentFilter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getId());
        long incidentCount = this.incidentService.getHistoricIncidentCount(incidentFilter);
        this.updateIncidentTabCaption(incidentCount);
    }

    protected void loadAndUpdateUserTasksCount() {
        UserTaskFilter userTaskFilter = (UserTaskFilter)this.metadata.create(UserTaskFilter.class);
        userTaskFilter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getId());
        long historyTasksCount = this.userTaskService.getHistoryTasksCount(userTaskFilter);
        this.updateUserTasksTabCaption(historyTasksCount);
    }

    protected void initUserTasksTab() {
        Tab userTasksTab = this.createTab(USER_TASKS_TAB_ID, "ProcessInstanceEditHistoryFragment.tasksTabCaption", VaadinIcon.USER_CARD);
        this.historyTabsheet.add(userTasksTab, (Component)new LazyTabContent((SerializableSupplier & Serializable)() -> this.fragments.create(this.getParentController(), HistoryUserTasksTabFragment.class)), 1);
    }

    protected void initVariablesTab() {
        Tab variablesTab = this.createTab(VARIABLES_TAB_ID, "ProcessInstanceEditHistoryFragment.historicVariableInstancesTabCaption", VaadinIcon.COGS);
        this.historyTabsheet.add(variablesTab, (Component)new LazyTabContent((SerializableSupplier & Serializable)() -> this.fragments.create(this.getParentController(), HistoryVariablesTabFragment.class)), 2);
    }

    protected void initIncidentsTab() {
        Tab incidentsTab = this.createTab(INCIDENTS_TAB_ID, "ProcessInstanceEditHistoryFragment.incidentsTabCaption", VaadinIcon.WARNING);
        this.historyTabsheet.add(incidentsTab, (Component)new LazyTabContent((SerializableSupplier & Serializable)() -> this.fragments.create(this.getParentController(), HistoryIncidentsTabFragment.class)), 3);
    }

    protected void updateUserTasksTabCaption(long userTasksCount) {
        this.updateTabCaption(1, "ProcessInstanceEditHistoryFragment.tasksTabCaption", userTasksCount, VaadinIcon.USER_CARD);
    }

    protected void updateVariablesTabCaption(long variablesCount) {
        this.updateTabCaption(2, "ProcessInstanceEditHistoryFragment.historicVariableInstancesTabCaption", variablesCount, VaadinIcon.CURLY_BRACKETS);
    }

    protected void updateIncidentTabCaption(long incidentCount) {
        this.updateTabCaption(3, "ProcessInstanceEditHistoryFragment.incidentsTabCaption", incidentCount, VaadinIcon.WARNING);
    }

    protected void updateActivityTabCaption(long activitiesCount) {
        this.updateTabCaption(0, "ProcessInstanceEditHistoryFragment.historicActivityInstancesTabCaption", activitiesCount, VaadinIcon.CUBES);
    }

    protected void updateTabCaption(int tabIndex, String messageKey, long count, VaadinIcon icon) {
        this.historyTabsheet.getTabAt(tabIndex).setLabel(this.messageBundle.formatMessage(messageKey, new Object[]{count}));
        this.historyTabsheet.getTabAt(tabIndex).addComponentAsFirst((Component)icon.create());
    }

    protected Tab createTab(String id, String messageKey, VaadinIcon icon) {
        Tab tab = (Tab)this.uiComponents.create(Tab.class);
        tab.setId(id);
        tab.setLabel(this.messageBundle.formatMessage(messageKey, new Object[]{0}));
        tab.addComponentAsFirst((Component)icon.create());
        return tab;
    }

    @Nullable
    protected Component getTabContent(Tab tab) {
        Component contentByTab = this.historyTabsheet.getContentByTab(tab);
        return contentByTab != null ? (Component)contentByTab.getChildren().findFirst().orElse(null) : null;
    }
}

