/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processinstance.history;

import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.event.SortEvent;
import io.flowset.control.entity.activity.HistoricActivityInstanceData;
import io.flowset.control.entity.filter.ActivityFilter;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.service.activity.ActivityLoadContext;
import io.flowset.control.service.activity.ActivityService;
import io.flowset.control.view.processinstance.event.HistoryActivityCountUpdateEvent;
import io.flowset.control.view.processinstance.history.HasRefresh;
import io.jmix.core.DataLoadContext;
import io.jmix.core.LoadContext;
import io.jmix.core.Metadata;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.UiEventPublisher;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.ViewComponent;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;

@FragmentDescriptor(value="activities-tab-fragment.xml")
public class ActivitiesTabFragment
extends Fragment<VerticalLayout>
implements HasRefresh {
    @Autowired
    protected ActivityService activityService;
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected UiEventPublisher uiEventPublisher;
    @Autowired
    protected DialogWindows dialogWindows;
    @ViewComponent
    protected CollectionLoader<HistoricActivityInstanceData> historicActivityInstancesDl;
    @ViewComponent
    protected DataGrid<HistoricActivityInstanceData> historicActivityInstancesGrid;
    @ViewComponent
    protected InstanceContainer<ProcessInstanceData> processInstanceDataDc;
    protected ActivityFilter filter;
    protected boolean initialized = false;

    public void refreshIfRequired() {
        if (!this.initialized) {
            this.filter = (ActivityFilter)this.metadata.create(ActivityFilter.class);
            this.filter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getId());
            this.historicActivityInstancesDl.load();
            this.initialized = true;
        }
    }

    @Subscribe(value="historicActivityInstancesGrid.view")
    public void onViewAction(ActionPerformedEvent event) {
        HistoricActivityInstanceData activityInstanceData = (HistoricActivityInstanceData)this.historicActivityInstancesGrid.getSingleSelectedItem();
        if (activityInstanceData == null) {
            return;
        }
        this.dialogWindows.detail(UiComponentUtils.getCurrentView(), HistoricActivityInstanceData.class).withAfterCloseListener(closeEvent -> this.historicActivityInstancesDl.load()).editEntity((Object)activityInstanceData).build().open();
    }

    @Install(to="historicActivityInstancesDl", target=Target.DATA_LOADER)
    protected List<HistoricActivityInstanceData> historicActivityInstancesDlLoadDelegate(LoadContext<HistoricActivityInstanceData> loadContext) {
        LoadContext.Query query = loadContext.getQuery();
        ActivityLoadContext context = new ActivityLoadContext().setFilter(this.filter);
        if (query != null) {
            context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        return this.activityService.findAllHistoryActivities(context);
    }

    @Install(to="historicActivityInstancesPagination", subject="totalCountDelegate")
    protected Integer historicActivityInstancesPaginationTotalCountDelegate(DataLoadContext dataLoadContext) {
        long historyActivitiesCount = this.activityService.getHistoryActivitiesCount(this.filter);
        this.uiEventPublisher.publishEventForCurrentUI((ApplicationEvent)new HistoryActivityCountUpdateEvent((Object)this, historyActivitiesCount));
        return (int)historyActivitiesCount;
    }

    @Subscribe(value="historicActivityInstancesGrid")
    public void onHistoricActivityInstancesGridGridSort(SortEvent<DataGrid<HistoricActivityInstanceData>, GridSortOrder<DataGrid<HistoricActivityInstanceData>>> event) {
        this.historicActivityInstancesDl.load();
    }
}

