/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processinstance.filter;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import io.flowset.control.entity.filter.ProcessDefinitionFilter;
import io.flowset.control.entity.filter.ProcessInstanceFilter;
import io.flowset.control.entity.processdefinition.ProcessDefinitionData;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.service.processdefinition.ProcessDefinitionLoadContext;
import io.flowset.control.service.processdefinition.ProcessDefinitionService;
import io.flowset.control.view.processinstance.filter.ProcessInstanceDataGridHeaderFilter;
import io.jmix.core.Metadata;
import io.jmix.flowui.component.SupportsItemsFetchCallback;
import io.jmix.flowui.component.combobox.JmixComboBox;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.component.grid.DataGridColumn;
import io.jmix.flowui.model.InstanceContainer;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ProcessHeaderFilter
extends ProcessInstanceDataGridHeaderFilter {
    protected ProcessDefinitionService processDefinitionService;
    protected Metadata metadata;
    protected JmixComboBox<ProcessDefinitionData> processVersionComboBox;
    protected JmixComboBox<ProcessDefinitionData> processComboBox;
    protected Checkbox useSpecificVersionChkBox;

    public ProcessHeaderFilter(DataGrid<ProcessInstanceData> dataGrid, DataGridColumn<ProcessInstanceData> column, InstanceContainer<ProcessInstanceFilter> filterDc) {
        super(dataGrid, column, filterDc);
    }

    @Autowired
    public void setProcessDefinitionService(ProcessDefinitionService processDefinitionService) {
        this.processDefinitionService = processDefinitionService;
    }

    @Autowired
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    protected Component createFilterComponent() {
        VerticalLayout layout = (VerticalLayout)this.uiComponents.create(VerticalLayout.class);
        layout.addClassNames(new String[]{"gap-s", "p-s"});
        layout.setSizeFull();
        this.processComboBox = this.createProcessComboBox();
        this.processVersionComboBox = this.createProcessVersionComboBox();
        this.useSpecificVersionChkBox = (Checkbox)this.uiComponents.create(Checkbox.class);
        this.useSpecificVersionChkBox.setLabel(this.messages.getMessage(this.getClass(), "useSpecificVersion"));
        this.useSpecificVersionChkBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            boolean useVersion = BooleanUtils.isTrue((Boolean)((Boolean)event.getValue()));
            this.processVersionComboBox.setVisible(useVersion);
            this.processVersionComboBox.setRequired(useVersion);
        });
        VerticalLayout versionLayout = (VerticalLayout)this.uiComponents.create(VerticalLayout.class);
        versionLayout.setPadding(false);
        versionLayout.add(new Component[]{this.useSpecificVersionChkBox});
        versionLayout.addAndExpand(new Component[]{this.processVersionComboBox});
        this.updateComboBoxVisibility((Boolean)this.useSpecificVersionChkBox.getValue());
        layout.add(new Component[]{this.processComboBox, versionLayout});
        return layout;
    }

    public void apply() {
        ProcessDefinitionData value = null;
        boolean useVersion = BooleanUtils.isTrue((Boolean)((Boolean)this.useSpecificVersionChkBox.getValue()));
        if (useVersion) {
            value = (ProcessDefinitionData)this.processVersionComboBox.getValue();
            ((ProcessInstanceFilter)this.filterDc.getItem()).setProcessDefinitionId(value != null ? value.getProcessDefinitionId() : null);
        } else {
            value = (ProcessDefinitionData)this.processComboBox.getValue();
            ((ProcessInstanceFilter)this.filterDc.getItem()).setProcessDefinitionKey(value != null ? value.getKey() : null);
        }
        this.filterButton.getElement().setAttribute("activated", value != null);
    }

    protected void updateComboBoxVisibility(Boolean useVersion) {
        this.processVersionComboBox.setVisible(BooleanUtils.isTrue((Boolean)useVersion));
    }

    protected void resetFilterValues() {
        this.processComboBox.setValue(null);
        this.useSpecificVersionChkBox.setValue((Object)false);
        this.processVersionComboBox.setValue(null);
    }

    protected JmixComboBox<ProcessDefinitionData> createProcessComboBox() {
        JmixComboBox processComboBox = (JmixComboBox)this.uiComponents.create(JmixComboBox.class);
        processComboBox.addClassNames(new String[]{"pt-0"});
        processComboBox.setClearButtonVisible(true);
        processComboBox.setLabel(this.messages.getMessage(this.getClass(), "processFilterLabel"));
        processComboBox.setMinWidth("30em");
        processComboBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.processVersionComboBox.setValue(null);
            this.updateVersions(this.processVersionComboBox);
        });
        processComboBox.setItemsFetchCallback((SupportsItemsFetchCallback.FetchCallback & Serializable)query -> {
            ProcessDefinitionFilter filter = (ProcessDefinitionFilter)this.metadata.create(ProcessDefinitionFilter.class);
            filter.setKeyLike((String)query.getFilter().orElse(null));
            filter.setLatestVersionOnly(Boolean.valueOf(true));
            ProcessDefinitionLoadContext context = new ProcessDefinitionLoadContext().setFilter(filter);
            context.setMaxResults(Integer.valueOf(query.getLimit()));
            context.setFirstResult(Integer.valueOf(query.getOffset()));
            return this.processDefinitionService.findAll(context).stream();
        });
        processComboBox.setItemLabelGenerator(ProcessDefinitionData::getKey);
        return processComboBox;
    }

    protected JmixComboBox<ProcessDefinitionData> createProcessVersionComboBox() {
        JmixComboBox processVersionComboBox = (JmixComboBox)this.uiComponents.create(JmixComboBox.class);
        processVersionComboBox.addClassNames(new String[]{"pt-0"});
        processVersionComboBox.setClearButtonVisible(true);
        processVersionComboBox.setPlaceholder(this.messages.getMessage(this.getClass(), "enterProcessVersionValue"));
        processVersionComboBox.setLabel(this.messages.getMessage(this.getClass(), "processVersionFilterLabel"));
        processVersionComboBox.setMinWidth("10em");
        processVersionComboBox.setItemLabelGenerator((ItemLabelGenerator & Serializable)item -> {
            Integer version = item.getVersion();
            return version != null ? String.valueOf(version) : null;
        });
        this.updateVersions(processVersionComboBox);
        return processVersionComboBox;
    }

    private void updateVersions(JmixComboBox<ProcessDefinitionData> processDefinitionComboBox) {
        if (this.processComboBox.getValue() != null) {
            ProcessDefinitionFilter filter = (ProcessDefinitionFilter)this.metadata.create(ProcessDefinitionFilter.class);
            filter.setKey(((ProcessDefinitionData)this.processComboBox.getValue()).getKey());
            filter.setLatestVersionOnly(Boolean.valueOf(false));
            ProcessDefinitionLoadContext context = new ProcessDefinitionLoadContext().setFilter(filter);
            processDefinitionComboBox.setItems((Collection)this.processDefinitionService.findAll(context));
        } else {
            processDefinitionComboBox.setItems(List.of());
        }
    }
}

