/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processinstance;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.data.event.SortEvent;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteParameters;
import io.flowset.control.entity.filter.ProcessInstanceFilter;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.entity.processinstance.RuntimeProcessInstanceData;
import io.flowset.control.service.processdefinition.ProcessDefinitionService;
import io.flowset.control.service.processinstance.ProcessInstanceLoadContext;
import io.flowset.control.service.processinstance.ProcessInstanceService;
import io.flowset.control.view.processinstance.BulkActivateProcessInstanceView;
import io.flowset.control.view.processinstance.BulkSuspendProcessInstanceView;
import io.flowset.control.view.processinstance.BulkTerminateProcessInstanceView;
import io.flowset.control.view.processinstance.ProcessInstanceListItemActionsFragment;
import io.flowset.control.view.processinstance.ProcessInstanceListParamBinder;
import io.flowset.control.view.processinstance.filter.BusinessKeyHeaderFilter;
import io.flowset.control.view.processinstance.filter.EndTimeHeaderFilter;
import io.flowset.control.view.processinstance.filter.IdHeaderFilter;
import io.flowset.control.view.processinstance.filter.ProcessHeaderFilter;
import io.flowset.control.view.processinstance.filter.ProcessInstanceDataGridHeaderFilter;
import io.flowset.control.view.processinstance.filter.ProcessInstanceStateHeaderFilter;
import io.flowset.control.view.processinstance.filter.StartTimeHeaderFilter;
import io.jmix.core.DataLoadContext;
import io.jmix.core.LoadContext;
import io.jmix.core.Messages;
import io.jmix.core.Metadata;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.Dialogs;
import io.jmix.flowui.Fragments;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.component.grid.DataGridColumn;
import io.jmix.flowui.facet.UrlQueryParametersFacet;
import io.jmix.flowui.fragment.FragmentOwner;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.model.CollectionContainer;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.sys.BeanUtil;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.DialogWindow;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.LookupComponent;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardListView;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Supply;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@Route(value="bpm/process-instances", layout=DefaultMainViewParent.class)
@ViewController(value="bpm_ProcessInstance.list")
@ViewDescriptor(value="process-instance-list-view.xml")
@LookupComponent(value="processInstancesGrid")
@DialogMode(width="50em", height="38.5em")
public class ProcessInstanceListView
extends StandardListView<ProcessInstanceData> {
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected ViewNavigators viewNavigators;
    @Autowired
    protected Fragments fragments;
    @Autowired
    protected UiComponents uiComponents;
    @Autowired
    protected Messages messages;
    @Autowired
    protected ProcessInstanceService processInstanceService;
    @Autowired
    protected ProcessDefinitionService processDefinitionService;
    @ViewComponent
    protected CollectionContainer<ProcessInstanceData> processInstancesDc;
    @ViewComponent
    protected DataGrid<ProcessInstanceData> processInstancesGrid;
    @ViewComponent
    protected InstanceContainer<ProcessInstanceFilter> processInstanceFilterDc;
    @ViewComponent
    protected CollectionLoader<ProcessInstanceData> processInstancesDl;
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected Dialogs dialogs;
    @Autowired
    protected Notifications notifications;
    @Autowired
    protected DialogWindows dialogWindows;
    @ViewComponent
    protected UrlQueryParametersFacet urlQueryParameters;
    @ViewComponent
    protected HorizontalLayout modeButtonsGroup;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-s"});
        this.initFilter();
        this.initDataGridHeaderRow();
        this.setDefaultSort();
        this.urlQueryParameters.registerBinder((UrlQueryParametersFacet.Binder)new ProcessInstanceListParamBinder(this.modeButtonsGroup, this.processInstanceFilterDc, this.processInstancesDl, this.processInstancesGrid));
    }

    protected void setDefaultSort() {
        List<GridSortOrder> gridSortOrders = Collections.singletonList(new GridSortOrder((Grid.Column)this.processInstancesGrid.getColumnByKey("startTime"), SortDirection.DESCENDING));
        this.processInstancesGrid.sort(gridSortOrders);
    }

    @Install(to="processInstancesGrid.bulkActivate", subject="enabledRule")
    protected boolean processInstancesGridBulkActivateEnabledRule() {
        boolean selectedNotEmpty = !this.processInstancesGrid.getSelectedItems().isEmpty();
        boolean suspendedInstanceSelected = this.processInstancesGrid.getSelectedItems().stream().anyMatch(processInstanceData -> BooleanUtils.isTrue((Boolean)processInstanceData.getSuspended()) && BooleanUtils.isNotTrue((Boolean)processInstanceData.getComplete()));
        boolean notCompletedSelected = this.processInstancesGrid.getSelectedItems().stream().noneMatch(processInstanceData -> BooleanUtils.isTrue((Boolean)processInstanceData.getComplete()));
        return selectedNotEmpty && suspendedInstanceSelected && notCompletedSelected;
    }

    @Install(to="processInstancesGrid.bulkTerminate", subject="enabledRule")
    protected boolean processInstancesGridBulkTerminateEnabledRule() {
        boolean selectedNotEmpty = !this.processInstancesGrid.getSelectedItems().isEmpty();
        boolean notCompletedSelected = this.processInstancesGrid.getSelectedItems().stream().noneMatch(processInstanceData -> BooleanUtils.isTrue((Boolean)processInstanceData.getFinished()));
        return selectedNotEmpty && notCompletedSelected;
    }

    @Install(to="processInstancesGrid.bulkSuspend", subject="enabledRule")
    protected boolean processInstancesGridBulkSuspendEnabledRule() {
        boolean selectedNotEmpty = !this.processInstancesGrid.getSelectedItems().isEmpty();
        boolean activeInstanceSelected = this.processInstancesGrid.getSelectedItems().stream().anyMatch(processInstanceData -> BooleanUtils.isNotTrue((Boolean)processInstanceData.getSuspended()) && BooleanUtils.isNotTrue((Boolean)processInstanceData.getFinished()));
        boolean notCompletedSelected = this.processInstancesGrid.getSelectedItems().stream().noneMatch(processInstanceData -> BooleanUtils.isTrue((Boolean)processInstanceData.getFinished()));
        return selectedNotEmpty && activeInstanceSelected && notCompletedSelected;
    }

    protected void initDataGridHeaderRow() {
        HeaderRow headerRow = this.processInstancesGrid.getDefaultHeaderRow();
        this.addColumnFilter(headerRow, "id", arg_0 -> this.createIdColumnFilter(arg_0));
        this.addColumnFilter(headerRow, "processDefinitionId", arg_0 -> this.createProcessColumnFilter(arg_0));
        this.addColumnFilter(headerRow, "businessKey", arg_0 -> this.createBusinessKeyColumnFilter(arg_0));
        this.addColumnFilter(headerRow, "state", arg_0 -> this.createStateColumnFilter(arg_0));
        this.addColumnFilter(headerRow, "startTime", arg_0 -> this.createStartTimeColumnFilter(arg_0));
        this.addColumnFilter(headerRow, "endTime", arg_0 -> this.createEndTimeColumnFilter(arg_0));
    }

    @Subscribe(value="processInstancesGrid.bulkTerminate")
    public void onProcessInstancesGridBulkTerminate(ActionPerformedEvent event) {
        this.dialogWindows.view((View)this, BulkTerminateProcessInstanceView.class).withViewConfigurer(view -> view.setProcessInstances((Collection)this.processInstancesGrid.getSelectedItems())).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.processInstancesDl.load();
            }
        }).build().open();
    }

    @Subscribe(value="processInstancesGrid.bulkActivate")
    public void onProcessInstancesGridBulkActivate(ActionPerformedEvent event) {
        List<String> instancesIds = this.processInstancesGrid.getSelectedItems().stream().map(RuntimeProcessInstanceData::getInstanceId).toList();
        DialogWindow dialogWindow = this.dialogWindows.view((View)this, BulkActivateProcessInstanceView.class).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.processInstancesDl.load();
            }
        }).build();
        BulkActivateProcessInstanceView bulkActivateProcessInstanceView = (BulkActivateProcessInstanceView)dialogWindow.getView();
        bulkActivateProcessInstanceView.setInstancesIds(instancesIds);
        dialogWindow.open();
    }

    @Subscribe(value="processInstancesGrid.bulkSuspend")
    public void onProcessInstancesGridBulkSuspend(ActionPerformedEvent event) {
        List<String> instancesIds = this.processInstancesGrid.getSelectedItems().stream().map(RuntimeProcessInstanceData::getInstanceId).toList();
        DialogWindow dialogWindow = this.dialogWindows.view((View)this, BulkSuspendProcessInstanceView.class).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.processInstancesDl.load();
            }
        }).build();
        BulkSuspendProcessInstanceView bulkSuspendProcessInstanceView = (BulkSuspendProcessInstanceView)dialogWindow.getView();
        bulkSuspendProcessInstanceView.setInstancesIds(instancesIds);
        dialogWindow.open();
    }

    @Install(to="processInstancePagination", subject="totalCountDelegate")
    protected Integer processInstancePaginationTotalCountDelegate(DataLoadContext dataLoadContext) {
        return (int)this.processInstanceService.getHistoricInstancesCount((ProcessInstanceFilter)this.processInstanceFilterDc.getItemOrNull());
    }

    @Install(to="processInstancesDl", target=Target.DATA_LOADER)
    protected List<ProcessInstanceData> processInstancesDlLoadDelegate(LoadContext<ProcessInstanceData> loadContext) {
        LoadContext.Query query = loadContext.getQuery();
        ProcessInstanceFilter filter = (ProcessInstanceFilter)this.processInstanceFilterDc.getItemOrNull();
        ProcessInstanceLoadContext context = new ProcessInstanceLoadContext().setFilter(filter).setLoadIncidents(true);
        if (query != null) {
            context = context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        return this.processInstanceService.findAllHistoricInstances(context);
    }

    @Subscribe(value="processInstancesGrid")
    public void onProcessInstancesGridSort(SortEvent<DataGrid<ProcessInstanceData>, GridSortOrder<DataGrid<ProcessInstanceData>>> event) {
        this.processInstancesDl.load();
    }

    @Subscribe(value="processInstancesGrid.view")
    public void onProcessInstancesGridEdit(ActionPerformedEvent event) {
        ProcessInstanceData selectedInstance = (ProcessInstanceData)this.processInstancesGrid.getSingleSelectedItem();
        if (selectedInstance == null) {
            return;
        }
        this.viewNavigators.detailView((View)this, ProcessInstanceData.class).withBackwardNavigation(true).withRouteParameters(new RouteParameters("id", selectedInstance.getId())).navigate();
    }

    @Supply(to="processInstancesGrid.processDefinitionId", subject="renderer")
    protected Renderer<ProcessInstanceData> processInstancesGridProcessRenderer() {
        return new TextRenderer(arg_0 -> this.getProcessDisplayName(arg_0));
    }

    @Install(to="processInstancesGrid.processDefinitionId", subject="tooltipGenerator")
    protected String processInstancesGridProcessTooltipGenerator(ProcessInstanceData processInstanceData) {
        return this.getProcessDisplayName(processInstanceData);
    }

    protected String getProcessDisplayName(ProcessInstanceData item) {
        return item.getProcessDefinitionVersion() == null ? item.getProcessDefinitionId() : this.messages.formatMessage("", "common.processDefinitionKeyAndVersion", new Object[]{item.getProcessDefinitionKey(), item.getProcessDefinitionVersion()});
    }

    @Subscribe(id="processInstanceFilterDc", target=Target.DATA_CONTAINER)
    public void onProcessInstanceFilterDcItemPropertyChange(InstanceContainer.ItemPropertyChangeEvent<ProcessInstanceFilter> event) {
        this.processInstancesDl.load();
    }

    @Supply(to="processInstancesGrid.actions", subject="renderer")
    protected Renderer<ProcessInstanceData> processInstancesGridActionsRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)processInstance -> {
            ProcessInstanceListItemActionsFragment fragment = (ProcessInstanceListItemActionsFragment)this.fragments.create((FragmentOwner)this, ProcessInstanceListItemActionsFragment.class);
            fragment.setProcessInstance(processInstance);
            return fragment;
        });
    }

    @Install(to="processInstancesGrid.startTime", subject="partNameGenerator")
    protected String processInstancesGridStartTimePartNameGenerator(ProcessInstanceData processInstanceData) {
        return "multiline-text-cell";
    }

    @Install(to="processInstancesGrid.endTime", subject="partNameGenerator")
    protected String processInstancesGridEndTimePartNameGenerator(ProcessInstanceData processInstanceData) {
        return "multiline-text-cell";
    }

    protected void initFilter() {
        ProcessInstanceFilter processInstanceFilter = (ProcessInstanceFilter)this.metadata.create(ProcessInstanceFilter.class);
        processInstanceFilter.setUnfinished(Boolean.valueOf(true));
        this.processInstanceFilterDc.setItem((Object)processInstanceFilter);
    }

    protected BusinessKeyHeaderFilter createBusinessKeyColumnFilter(DataGridColumn<ProcessInstanceData> businessKeyColumn) {
        return new BusinessKeyHeaderFilter(this.processInstancesGrid, businessKeyColumn, this.processInstanceFilterDc);
    }

    protected EndTimeHeaderFilter createEndTimeColumnFilter(DataGridColumn<ProcessInstanceData> endTimeColumn) {
        return new EndTimeHeaderFilter(this.processInstancesGrid, endTimeColumn, this.processInstanceFilterDc);
    }

    protected StartTimeHeaderFilter createStartTimeColumnFilter(DataGridColumn<ProcessInstanceData> startTimeColumn) {
        return new StartTimeHeaderFilter(this.processInstancesGrid, startTimeColumn, this.processInstanceFilterDc);
    }

    protected ProcessHeaderFilter createProcessColumnFilter(DataGridColumn<ProcessInstanceData> processColumn) {
        return new ProcessHeaderFilter(this.processInstancesGrid, processColumn, this.processInstanceFilterDc);
    }

    protected IdHeaderFilter createIdColumnFilter(DataGridColumn<ProcessInstanceData> idColumn) {
        return new IdHeaderFilter(this.processInstancesGrid, idColumn, this.processInstanceFilterDc);
    }

    protected ProcessInstanceStateHeaderFilter createStateColumnFilter(DataGridColumn<ProcessInstanceData> stateColumn) {
        return new ProcessInstanceStateHeaderFilter(this.processInstancesGrid, stateColumn, this.processInstanceFilterDc);
    }

    protected <T extends ProcessInstanceDataGridHeaderFilter> void addColumnFilter(HeaderRow headerRow, String columnName, Function<DataGridColumn<ProcessInstanceData>, T> filterProvider) {
        DataGridColumn column = this.processInstancesGrid.getColumnByKey(columnName);
        ProcessInstanceDataGridHeaderFilter filterComponent = (ProcessInstanceDataGridHeaderFilter)filterProvider.apply((DataGridColumn<ProcessInstanceData>)column);
        BeanUtil.autowireContext((ApplicationContext)this.applicationContext, (Object)filterComponent);
        HeaderRow.HeaderCell headerCell = (HeaderRow.HeaderCell)headerRow.getCell((Grid.Column)column);
        headerCell.setComponent((Component)filterComponent);
    }
}

