/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processinstance;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.RouterLink;
import io.flowset.control.entity.filter.ProcessInstanceFilter;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.service.processinstance.ProcessInstanceLoadContext;
import io.flowset.control.service.processinstance.ProcessInstanceService;
import io.flowset.control.view.main.MainView;
import io.flowset.control.view.processinstance.ProcessInstanceDetailView;
import io.jmix.core.DataManager;
import io.jmix.core.LoadContext;
import io.jmix.core.Messages;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.LookupComponent;
import io.jmix.flowui.view.StandardListView;
import io.jmix.flowui.view.Supply;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="called-process-instances", layout=MainView.class)
@ViewController(id="bpm_CalledProcessInstanceData.list")
@ViewDescriptor(path="called-process-instance-data-list-view.xml")
@LookupComponent(value="processInstancesDataGrid")
@DialogMode(minWidth="65em", width="70%")
public class CalledProcessInstanceDataListView
extends StandardListView<ProcessInstanceData> {
    @Autowired
    protected UiComponents uiComponents;
    @Autowired
    protected ProcessInstanceService processInstanceService;
    @Autowired
    protected DataManager dataManager;
    @Autowired
    protected Messages messages;
    @Autowired
    protected ViewNavigators viewNavigators;
    protected List<String> processInstanceIds;

    public void setProcessInstanceIds(List<String> processInstanceIds) {
        this.processInstanceIds = processInstanceIds;
    }

    @Install(to="processInstancesDl", target=Target.DATA_LOADER)
    protected List<ProcessInstanceData> processInstancesDlLoadDelegate(LoadContext<ProcessInstanceData> loadContext) {
        if (CollectionUtils.isEmpty((Collection)this.processInstanceIds)) {
            return List.of();
        }
        ProcessInstanceFilter filter = (ProcessInstanceFilter)this.dataManager.create(ProcessInstanceFilter.class);
        filter.setProcessInstanceIds(this.processInstanceIds);
        ProcessInstanceLoadContext context = new ProcessInstanceLoadContext().setFirstResult(Integer.valueOf(0)).setMaxResults(Integer.valueOf(this.processInstanceIds.size())).setFilter(filter);
        return this.processInstanceService.findAllHistoricInstances(context);
    }

    @Supply(to="processInstancesDataGrid.processDefinitionId", subject="renderer")
    protected Renderer<ProcessInstanceData> processInstancesDataGridProcessDefinitionIdRenderer() {
        return new TextRenderer((ItemLabelGenerator & Serializable)item -> item.getProcessDefinitionVersion() == null ? item.getProcessDefinitionId() : this.messages.formatMessage("", "common.processDefinitionKeyAndVersion", new Object[]{item.getProcessDefinitionKey(), item.getProcessDefinitionVersion()}));
    }

    @Supply(to="processInstancesDataGrid.actions", subject="renderer")
    protected Renderer<ProcessInstanceData> processInstancesDataGridActionsRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)item -> {
            JmixButton viewButton = (JmixButton)this.uiComponents.create(JmixButton.class);
            viewButton.setText(this.messages.getMessage("actions.View"));
            viewButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
            viewButton.setIcon((Component)VaadinIcon.EYE.create());
            viewButton.addClickListener((ComponentEventListener & Serializable)event -> {
                if (UiComponentUtils.isComponentAttachedToDialog((Component)this)) {
                    RouterLink routerLink = new RouterLink(ProcessInstanceDetailView.class, new RouteParameters("id", item.getId()));
                    this.getUI().ifPresent(ui -> ui.getPage().open(routerLink.getHref()));
                } else {
                    this.openProcessInstanceDetailView(item);
                }
            });
            return viewButton;
        });
    }

    protected void openProcessInstanceDetailView(ProcessInstanceData item) {
        this.viewNavigators.detailView(UiComponentUtils.getCurrentView(), ProcessInstanceData.class).withViewClass(ProcessInstanceDetailView.class).withRouteParameters(new RouteParameters("id", item.getId())).withBackwardNavigation(true).navigate();
    }
}

