/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processinstance;

import com.vaadin.flow.router.Route;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.service.processinstance.ProcessInstanceService;
import io.flowset.control.view.main.MainView;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="activate-process-instance-view", layout=MainView.class)
@ViewController(id="ActivateProcessInstanceView")
@ViewDescriptor(path="activate-process-instance-view.xml")
public class ActivateProcessInstanceView
extends StandardView {
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private Notifications notifications;
    @ViewComponent
    private MessageBundle messageBundle;
    protected ProcessInstanceData processInstanceData;

    public void setProcessInstanceData(ProcessInstanceData processInstanceData) {
        this.processInstanceData = processInstanceData;
    }

    @Subscribe(value="activateAction")
    public void onActivateAction(ActionPerformedEvent event) {
        this.processInstanceService.activateById(this.processInstanceData.getId());
        this.notifications.create(this.messageBundle.getMessage("processInstanceActivated")).withType(Notifications.Type.SUCCESS).show();
        this.close(StandardOutcome.SAVE);
    }

    @Subscribe(value="cancelAction")
    public void onCancelAction(ActionPerformedEvent event) {
        this.close(StandardOutcome.CLOSE);
    }
}

