/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.newprocessdeployment;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.html.ListItem;
import com.vaadin.flow.component.html.UnorderedList;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import io.flowset.control.dto.BpmProcessDefinition;
import io.flowset.control.entity.processdefinition.ProcessDefinitionData;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.ViewComponent;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

@FragmentDescriptor(value="deployment-confirm-content-fragment.xml")
public class DeploymentConfirmContentFragment
extends Fragment<VerticalLayout> {
    @ViewComponent
    protected VerticalLayout existingProcessVBox;
    @ViewComponent
    protected Icon warningIcon;
    @ViewComponent
    protected H5 warningHeader;
    @ViewComponent
    protected UnorderedList existingProcessesList;
    @ViewComponent
    protected UnorderedList deployingProcessesList;

    @Subscribe
    public void onReady(Fragment.ReadyEvent event) {
        this.initExistingProcessesWarningStyles();
        this.deployingProcessesList.addClassName("m-0");
    }

    public void setExistingProcesses(List<ProcessDefinitionData> existingProcesses) {
        if (CollectionUtils.isNotEmpty(existingProcesses)) {
            this.existingProcessVBox.setVisible(true);
            existingProcesses.forEach(processDefinitionData -> {
                ListItem listItem = (ListItem)this.uiComponents.create(ListItem.class);
                listItem.setText(processDefinitionData.getKey());
                this.existingProcessesList.add(new Component[]{listItem});
            });
        }
    }

    public void setDeployingProcesses(List<BpmProcessDefinition> deployingProcesses) {
        deployingProcesses.forEach(processDefinitionData -> {
            ListItem listItem = (ListItem)this.uiComponents.create(ListItem.class);
            listItem.setText(processDefinitionData.getKey());
            this.deployingProcessesList.add(new Component[]{listItem});
        });
    }

    protected void initExistingProcessesWarningStyles() {
        this.warningIcon.addClassNames(new String[]{"text-warning"});
        this.warningHeader.addClassNames(new String[]{"text-warning-contrast"});
        this.existingProcessVBox.addClassNames(new String[]{"border-warning", "border", "rounded-l", "bg-warning-10"});
        this.existingProcessesList.addClassName("m-0");
    }
}

