/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.main;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H1;
import com.vaadin.flow.component.html.Header;
import com.vaadin.flow.component.icon.SvgIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.router.Route;
import io.flowset.control.entity.EngineConnectionCheckResult;
import io.flowset.control.entity.engine.BpmEngine;
import io.flowset.control.event.UserEngineSelectEvent;
import io.flowset.control.property.EngineConnectionCheckProperties;
import io.flowset.control.service.engine.EngineService;
import io.flowset.control.service.engine.EngineUiService;
import io.flowset.control.uicomponent.menu.ControlListMenu;
import io.flowset.control.view.dashboard.DashboardFragment;
import io.flowset.control.view.event.TitleUpdateEvent;
import io.flowset.control.view.main.EngineStatusBadgeFragment;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.Facets;
import io.jmix.flowui.Fragments;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.app.main.StandardMainView;
import io.jmix.flowui.asynctask.UiAsyncTasks;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.facet.Timer;
import io.jmix.flowui.fragment.FragmentOwner;
import io.jmix.flowui.kit.component.main.ListMenu;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import io.jmix.flowui.view.navigation.ViewNavigationSupport;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

@Route(value="")
@ViewController(value="MainView")
@ViewDescriptor(value="main-view.xml")
public class MainView
extends StandardMainView {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MainView.class);
    @ViewComponent
    protected H1 viewTitle;
    @ViewComponent
    protected Div viewTitleDiv;
    @Autowired
    protected Fragments fragments;
    @ViewComponent
    protected InstanceContainer<EngineConnectionCheckResult> engineConnectionStatusDc;
    @Autowired
    protected EngineService engineService;
    @Autowired
    protected EngineUiService engineUiService;
    @Autowired
    protected DialogWindows dialogWindows;
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected Facets facets;
    @ViewComponent
    protected Timer connectionCheckTimer;
    @Autowired
    protected EngineConnectionCheckProperties checkProperties;
    @ViewComponent
    protected Anchor baseLink;
    @Autowired
    protected UiAsyncTasks uiAsyncTasks;
    @ViewComponent
    protected InstanceContainer<BpmEngine> selectedEngineDc;
    @Autowired
    protected Notifications notifications;
    @Autowired
    protected ViewNavigationSupport viewNavigationSupport;
    @ViewComponent
    protected Header header;
    @ViewComponent
    protected ControlListMenu menu;
    protected EngineStatusBadgeFragment engineStatusFragment;
    protected AtomicBoolean statusCheckRunning = new AtomicBoolean(false);

    @Subscribe
    public void onQueryParametersChange(View.QueryParametersChangeEvent event) {
        this.viewTitleDiv.removeAll();
    }

    @Subscribe
    public void onInit(View.InitEvent event) {
        BpmEngine selectedEngine = this.engineService.getSelectedEngine();
        this.selectedEngineDc.setItem((Object)selectedEngine);
        this.initMenu();
        this.initBaseLink();
        this.initConnectionCheckTimer();
        this.initInitialLayout();
        this.initEngineStatusFragment();
    }

    @Subscribe
    public void onReady(View.ReadyEvent event) {
        this.updateEngineStatusManually();
    }

    @EventListener
    protected void onTitleUpdated(TitleUpdateEvent event) {
        String title = event.getTitle();
        this.viewTitle.setText(title);
        Component titleComponent = event.getSuffixComponent();
        if (titleComponent != null) {
            this.viewTitleDiv.removeAll();
            this.viewTitleDiv.add(new Component[]{titleComponent});
        }
    }

    @EventListener
    protected void onUserEngineSelectEvent(UserEngineSelectEvent event) {
        this.notifications.create(this.messageBundle.formatMessage("engineChanged", new Object[]{event.getEngine().getName()}), this.messageBundle.formatMessage("engineChanged.description", new Object[]{event.getEngine().getBaseUrl()})).withPosition(Notification.Position.TOP_END).withThemeVariant(NotificationVariant.LUMO_PRIMARY).withDuration(4000).show();
        this.selectedEngineDc.setItem((Object)event.getEngine());
        this.updateEngineStatusManually();
        View currentView = UiComponentUtils.getCurrentView();
        if (currentView == this) {
            this.refreshDashboard();
        } else {
            this.viewNavigationSupport.navigate(MainView.class);
        }
    }

    protected void refreshDashboard() {
        Component component;
        Component initialLayout = this.getInitialLayout();
        if (initialLayout != null && (component = (Component)initialLayout.getChildren().findFirst().orElse(null)) instanceof DashboardFragment) {
            DashboardFragment dashboardFragment = (DashboardFragment)component;
            dashboardFragment.updateDashboard();
        }
    }

    protected void initMenu() {
        this.menu.addMenuItemBefore(new ControlListMenu.GroupLabelMenuItem("mainLabel").withTitle(this.messageBundle.getMessage("menu.mainGroup.label")), "dashboard");
        this.menu.addMenuItemBefore(new ControlListMenu.GroupLabelMenuItem("dmnLabel").withTitle(this.messageBundle.getMessage("menu.dmnGroup.label")), "decisions");
        this.menu.addMenuItemBefore(new ControlListMenu.GroupLabelMenuItem("systemLabel").withTitle(this.messageBundle.getMessage("menu.systemGroup.label")), "deployments");
        this.menu.addMenuItemBefore(new ControlListMenu.GroupLabelMenuItem("supportLabel").withTitle(this.messageBundle.getMessage("menu.supportGroup.label")), "about");
        ListMenu.MenuItem dashboardMenu = this.menu.getMenuItem("dashboard");
        if (dashboardMenu != null) {
            dashboardMenu.setPrefixComponent((Component)new SvgIcon("icons/dashboard.svg"));
        }
    }

    protected void initInitialLayout() {
        Component initialLayout = this.getInitialLayout();
        if (initialLayout instanceof HasComponents) {
            HasComponents container = (HasComponents)initialLayout;
            initialLayout.addAttachListener((ComponentEventListener & Serializable)attachEvent -> {
                if (container.getElement().getChildCount() == 0) {
                    this.initDashboard(container);
                } else {
                    Component component = initialLayout.getChildren().findFirst().orElse(null);
                    if (component instanceof DashboardFragment) {
                        DashboardFragment dashboardFragment = (DashboardFragment)component;
                        dashboardFragment.updateDashboard();
                    }
                }
            });
        }
    }

    protected void initBaseLink() {
        SvgIcon logoIcon = new SvgIcon("icons/logo.svg");
        logoIcon.addClassNames(new String[]{"logo-icon"});
        this.baseLink.addComponentAsFirst((Component)logoIcon);
    }

    protected void initDashboard(HasComponents container) {
        DashboardFragment dashboardFragment = (DashboardFragment)this.fragments.create((FragmentOwner)this, DashboardFragment.class);
        container.add(new Component[]{dashboardFragment});
    }

    protected void initConnectionCheckTimer() {
        this.connectionCheckTimer.setDelay(this.checkProperties.getIntervalSec() * 1000);
    }

    protected void initEngineStatusFragment() {
        boolean engineStatusFragmentExists = this.header.getChildren().anyMatch(component -> component instanceof EngineStatusBadgeFragment);
        if (!engineStatusFragmentExists) {
            this.engineStatusFragment = (EngineStatusBadgeFragment)this.fragments.create((FragmentOwner)this, EngineStatusBadgeFragment.class);
            this.header.add(new Component[]{this.engineStatusFragment});
        }
    }

    @Subscribe(value="connectionCheckTimer")
    public void onConnectionCheckTimerTimerAction(Timer.TimerActionEvent event) {
        BpmEngine selectedEngine = this.engineService.getSelectedEngine();
        this.selectedEngineDc.setItem((Object)selectedEngine);
        if (selectedEngine == null) {
            this.handleNoEngineSelected();
            return;
        }
        if (this.statusCheckRunning.get()) {
            return;
        }
        this.runEngineStatusCheckAsync(selectedEngine, result -> {
            this.statusCheckRunning.set(false);
            this.handleCheckResult(result);
        }, throwable -> {
            this.statusCheckRunning.set(false);
            this.handleErrorCheckResult();
        });
        this.statusCheckRunning.set(true);
    }

    protected void updateEngineStatusManually() {
        this.connectionCheckTimer.stop();
        BpmEngine bpmEngine = (BpmEngine)this.selectedEngineDc.getItemOrNull();
        if (bpmEngine == null) {
            this.handleNoEngineSelected();
            this.refreshDashboard();
            this.connectionCheckTimer.start();
            return;
        }
        this.runEngineStatusCheckAsync(bpmEngine, result -> {
            this.handleCheckResult(result);
            this.refreshDashboard();
            this.connectionCheckTimer.start();
        }, throwable -> {
            this.handleErrorCheckResult();
            this.refreshDashboard();
            this.connectionCheckTimer.start();
        });
    }

    protected void runEngineStatusCheckAsync(BpmEngine engine, Consumer<EngineConnectionCheckResult> successHandler, Consumer<Throwable> errorHandler) {
        this.uiAsyncTasks.supplierConfigurer(() -> this.engineUiService.checkConnection(engine)).withResultHandler(successHandler).withExceptionHandler(ex -> {
            log.error("Unable to check engine status", ex);
            errorHandler.accept((Throwable)ex);
        }).supplyAsync();
    }

    protected void handleNoEngineSelected() {
        this.engineStatusFragment.setNoSelectedEngineStatus();
    }

    protected void handleCheckResult(EngineConnectionCheckResult result) {
        this.engineConnectionStatusDc.setItem((Object)result);
        this.engineStatusFragment.updateConnectionStatusComponents();
    }

    protected void handleErrorCheckResult() {
        this.engineStatusFragment.setFailedConnectionStatus();
    }
}

