/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.job;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.router.Route;
import io.flowset.control.entity.job.JobData;
import io.flowset.control.entity.job.JobDefinitionData;
import io.flowset.control.service.job.JobService;
import io.jmix.core.Messages;
import io.jmix.flowui.Dialogs;
import io.jmix.flowui.action.DialogAction;
import io.jmix.flowui.component.codeeditor.CodeEditor;
import io.jmix.flowui.component.formlayout.JmixFormLayout;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.kit.action.Action;
import io.jmix.flowui.kit.action.ActionVariant;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.EditedEntityContainer;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardDetailView;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpm/job/:id", layout=DefaultMainViewParent.class)
@ViewController(value="JobData.detail")
@ViewDescriptor(value="job-data-detail-view.xml")
@DialogMode(width="50em", height="37.5em", resizable=true)
@EditedEntityContainer(value="jobDataDc")
public class JobDataDetailView
extends StandardDetailView<JobData> {
    @Autowired
    protected Dialogs dialogs;
    @ViewComponent
    protected MessageBundle messageBundle;
    @ViewComponent
    protected CodeEditor stackTraceField;
    @Autowired
    protected JobService jobService;
    @ViewComponent
    protected TypedTextField<String> activityField;
    @ViewComponent
    protected JmixFormLayout form;
    @ViewComponent
    protected TypedTextField<Object> jobTypeField;
    @ViewComponent
    protected JmixButton retryBtn;
    @Autowired
    protected Messages messages;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-xs"});
        this.form.getOwnComponents().forEach(component -> component.addClassNames(new String[]{"pt-s"}));
    }

    @Subscribe
    protected void onBeforeShow(View.BeforeShowEvent event) {
        String stacktrace = this.jobService.getErrorDetails(((JobData)this.getEditedEntity()).getJobId());
        this.stackTraceField.setValue(stacktrace);
        JobDefinitionData jobDefinition = this.jobService.findJobDefinition(((JobData)this.getEditedEntity()).getJobDefinitionId());
        if (jobDefinition != null) {
            this.activityField.setValue(jobDefinition.getActivityId());
            this.jobTypeField.setValue(jobDefinition.getJobType());
        }
        if (((JobData)this.getEditedEntity()).getRetries() != null && ((JobData)this.getEditedEntity()).getRetries() == 0) {
            this.retryBtn.setVisible(true);
        }
    }

    @Subscribe(value="retryBtn")
    protected void onRestoreFailedJobBtnClick(ClickEvent<Button> event) {
        ((Dialogs.OptionDialogBuilder)((Dialogs.OptionDialogBuilder)this.dialogs.createOptionDialog().withHeader(this.messageBundle.getMessage("restoreFailedJobDialog.header"))).withText(this.messageBundle.getMessage("restoreFailedJobDialog.text"))).withActions(new Action[]{new DialogAction(DialogAction.Type.YES).withIcon(VaadinIcon.ROTATE_LEFT.create()).withText(this.messages.getMessage("actions.Retry")).withVariant(ActionVariant.PRIMARY).withHandler(actionPerformedEvent -> {
            this.jobService.setJobRetries(((JobData)this.getEditedEntity()).getJobId(), 1);
            this.close(StandardOutcome.SAVE);
        }), new DialogAction(DialogAction.Type.CANCEL)}).open();
    }
}

