/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.incidentdata.filter;

import com.google.common.collect.ImmutableMap;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.textfield.TextField;
import io.flowset.control.entity.filter.IncidentFilter;
import io.flowset.control.entity.incident.IncidentData;
import io.flowset.control.view.incidentdata.IncidentHeaderFilter;
import io.jmix.flowui.component.grid.DataGridColumn;
import io.jmix.flowui.kit.component.ComponentUtils;
import io.jmix.flowui.model.InstanceContainer;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class IncidentTypeHeaderFilter
extends IncidentHeaderFilter {
    private static final String CUSTOM_TYPE = "custom";
    protected TextField customTypeField;
    protected RadioButtonGroup<String> incidentTypeGroup;

    public IncidentTypeHeaderFilter(Grid<IncidentData> dataGrid, DataGridColumn<IncidentData> column, InstanceContainer<IncidentFilter> filterDc) {
        super(dataGrid, column, filterDc);
    }

    protected Component createFilterComponent() {
        return this.createIncidentTypeFilter();
    }

    protected void resetFilterValues() {
        this.incidentTypeGroup.clear();
        this.customTypeField.clear();
    }

    public void apply() {
        String value = (String)this.incidentTypeGroup.getValue();
        if (StringUtils.equals((CharSequence)value, (CharSequence)CUSTOM_TYPE)) {
            ((IncidentFilter)this.filterDc.getItem()).setIncidentType(this.customTypeField.getValue());
        } else {
            ((IncidentFilter)this.filterDc.getItem()).setIncidentType(value);
        }
        this.filterButton.getElement().setAttribute("activated", value != null);
    }

    protected VerticalLayout createIncidentTypeFilter() {
        this.incidentTypeGroup = (RadioButtonGroup)this.uiComponents.create(RadioButtonGroup.class);
        this.incidentTypeGroup.setLabel(this.messages.getMessage(IncidentFilter.class, "IncidentFilter.incidentType"));
        this.incidentTypeGroup.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            String value = (String)event.getValue();
            if (value == null || !value.equals(CUSTOM_TYPE)) {
                this.customTypeField.clear();
                this.customTypeField.setVisible(false);
            } else {
                this.customTypeField.setVisible(true);
            }
        });
        ImmutableMap incidentTypesMap = ImmutableMap.of((Object)"failedJob", (Object)"failedJob", (Object)"failedExternalTask", (Object)"failedExternalTask", (Object)CUSTOM_TYPE, (Object)this.messages.getMessage(this.getClass(), "customType"));
        ComponentUtils.setItemsMap((RadioButtonGroup)this.incidentTypeGroup, (Map)incidentTypesMap);
        this.customTypeField = (TextField)this.uiComponents.create(TextField.class);
        this.customTypeField.setVisible(false);
        this.customTypeField.setWidthFull();
        this.customTypeField.setMinWidth("10em");
        this.customTypeField.setClearButtonVisible(true);
        this.customTypeField.setLabel(this.messages.getMessage(this.getClass(), "customIncidentType.label"));
        this.customTypeField.setPlaceholder(this.messages.getMessage(this.getClass(), "customIncidentType.placeholder"));
        VerticalLayout verticalLayout = (VerticalLayout)this.uiComponents.create(VerticalLayout.class);
        verticalLayout.setPadding(false);
        verticalLayout.setWidthFull();
        verticalLayout.addClassNames(new String[]{"gap-s"});
        verticalLayout.add(new Component[]{this.incidentTypeGroup, this.customTypeField});
        return verticalLayout;
    }
}

