/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.incidentdata.filter;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import io.flowset.control.entity.filter.IncidentFilter;
import io.flowset.control.entity.incident.IncidentData;
import io.flowset.control.view.incidentdata.IncidentHeaderFilter;
import io.jmix.flowui.component.datetimepicker.TypedDateTimePicker;
import io.jmix.flowui.component.grid.DataGridColumn;
import io.jmix.flowui.model.InstanceContainer;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class IncidentTimestampHeaderFilter
extends IncidentHeaderFilter {
    private TypedDateTimePicker<LocalDateTime> timestampAfter;
    private TypedDateTimePicker<LocalDateTime> timestampBefore;

    public IncidentTimestampHeaderFilter(Grid<IncidentData> dataGrid, DataGridColumn<IncidentData> column, InstanceContainer<IncidentFilter> filterDc) {
        super(dataGrid, column, filterDc);
    }

    protected Component createFilterComponent() {
        Component dateAfterFilter = this.createDateAfterFilter();
        Component dateBeforeFilter = this.createDateBeforeFilter();
        VerticalLayout rootLayout = (VerticalLayout)this.uiComponents.create(VerticalLayout.class);
        rootLayout.setPadding(false);
        rootLayout.setSpacing(false);
        rootLayout.add(new Component[]{dateAfterFilter, dateBeforeFilter});
        return rootLayout;
    }

    public void apply() {
        LocalDateTime dateBefore = (LocalDateTime)this.timestampBefore.getValue();
        if (dateBefore != null) {
            ZoneId zoneId = this.timestampBefore.getZoneId();
            ZoneId zone = zoneId != null ? zoneId : ZoneId.systemDefault();
            ((IncidentFilter)this.filterDc.getItem()).setIncidentTimestampBefore(dateBefore.atZone(zone).toOffsetDateTime());
        } else {
            ((IncidentFilter)this.filterDc.getItem()).setIncidentTimestampBefore(null);
        }
        LocalDateTime dateAfter = (LocalDateTime)this.timestampAfter.getValue();
        if (dateAfter != null) {
            ZoneId zoneId = this.timestampAfter.getZoneId();
            ZoneId zone = zoneId != null ? zoneId : ZoneId.systemDefault();
            ((IncidentFilter)this.filterDc.getItem()).setIncidentTimestampAfter(dateAfter.atZone(zone).toOffsetDateTime());
        } else {
            ((IncidentFilter)this.filterDc.getItem()).setIncidentTimestampAfter(null);
        }
        this.filterButton.getElement().setAttribute("activated", dateAfter != null || dateBefore != null);
    }

    protected void resetFilterValues() {
        this.timestampAfter.clear();
        this.timestampBefore.clear();
    }

    private Component createDateBeforeFilter() {
        this.timestampBefore = (TypedDateTimePicker)this.uiComponents.create(TypedDateTimePicker.class);
        this.timestampBefore.setMax(LocalDateTime.now());
        this.timestampBefore.setDatePlaceholder(this.messages.getMessage(this.getClass(), "selectDate"));
        this.timestampBefore.setTimePlaceholder(this.messages.getMessage(this.getClass(), "selectTime"));
        this.timestampBefore.setLabel(this.messages.getMessage(IncidentFilter.class, "IncidentFilter.incidentTimestampBefore"));
        this.setDefaultTime(this.timestampBefore);
        return this.timestampBefore;
    }

    private Component createDateAfterFilter() {
        this.timestampAfter = (TypedDateTimePicker)this.uiComponents.create(TypedDateTimePicker.class);
        this.timestampAfter.setDatePlaceholder(this.messages.getMessage(this.getClass(), "selectDate"));
        this.timestampAfter.setTimePlaceholder(this.messages.getMessage(this.getClass(), "selectTime"));
        this.timestampAfter.setMax(LocalDateTime.now());
        this.timestampAfter.setLabel(this.messages.getMessage(IncidentFilter.class, "IncidentFilter.incidentTimestampAfter"));
        this.setDefaultTime(this.timestampAfter);
        return this.timestampAfter;
    }

    private void setDefaultTime(TypedDateTimePicker<LocalDateTime> dateTimePicker) {
        dateTimePicker.getElement().executeJs("this.__datePicker.addEventListener('change', function(){this.__timePicker.value='00:00';}.bind(this));", new Serializable[0]);
    }
}

