/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.incidentdata.filter;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.textfield.TextField;
import io.flowset.control.entity.filter.IncidentFilter;
import io.flowset.control.entity.incident.IncidentData;
import io.flowset.control.view.incidentdata.IncidentHeaderFilter;
import io.jmix.flowui.component.grid.DataGridColumn;
import io.jmix.flowui.model.InstanceContainer;
import org.apache.commons.lang3.StringUtils;

public class ActivityHeaderFilter
extends IncidentHeaderFilter {
    protected TextField activityIdField;

    public ActivityHeaderFilter(Grid<IncidentData> dataGrid, DataGridColumn<IncidentData> column, InstanceContainer<IncidentFilter> filterDc) {
        super(dataGrid, column, filterDc);
    }

    protected Component createFilterComponent() {
        return this.createActivityFilter();
    }

    protected void resetFilterValues() {
        this.activityIdField.clear();
    }

    public void apply() {
        String value = this.activityIdField.getValue();
        boolean emptyValue = StringUtils.isEmpty((CharSequence)value);
        if (emptyValue) {
            value = null;
        }
        ((IncidentFilter)this.filterDc.getItem()).setActivityId(value);
        this.filterButton.getElement().setAttribute("activated", !emptyValue);
    }

    protected TextField createActivityFilter() {
        this.activityIdField = (TextField)this.uiComponents.create(TextField.class);
        this.activityIdField.setWidthFull();
        this.activityIdField.setMinWidth("30em");
        this.activityIdField.setClearButtonVisible(true);
        this.activityIdField.setLabel(this.messages.getMessage(IncidentFilter.class, "IncidentFilter.activityId"));
        this.activityIdField.setPlaceholder(this.messages.getMessage(this.getClass(), "activityId.placeholder"));
        return this.activityIdField;
    }
}

