/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.incidentdata;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.event.SortEvent;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteParameters;
import io.flowset.control.entity.filter.IncidentFilter;
import io.flowset.control.entity.filter.ProcessDefinitionFilter;
import io.flowset.control.entity.incident.IncidentData;
import io.flowset.control.entity.processdefinition.ProcessDefinitionData;
import io.flowset.control.service.incident.IncidentLoadContext;
import io.flowset.control.service.incident.IncidentService;
import io.flowset.control.service.processdefinition.ProcessDefinitionLoadContext;
import io.flowset.control.service.processdefinition.ProcessDefinitionService;
import io.flowset.control.view.incidentdata.BulkRetryIncidentView;
import io.flowset.control.view.incidentdata.IncidentDataDetailView;
import io.flowset.control.view.incidentdata.IncidentHeaderFilter;
import io.flowset.control.view.incidentdata.RetryExternalTaskView;
import io.flowset.control.view.incidentdata.RetryJobView;
import io.flowset.control.view.incidentdata.filter.ActivityHeaderFilter;
import io.flowset.control.view.incidentdata.filter.IncidentTimestampHeaderFilter;
import io.flowset.control.view.incidentdata.filter.IncidentTypeHeaderFilter;
import io.flowset.control.view.incidentdata.filter.MessageHeaderFilter;
import io.flowset.control.view.incidentdata.filter.ProcessHeaderFilter;
import io.flowset.control.view.incidentdata.filter.ProcessInstanceIdHeaderFilter;
import io.flowset.control.view.main.MainView;
import io.flowset.control.view.util.ComponentHelper;
import io.jmix.core.DataLoadContext;
import io.jmix.core.LoadContext;
import io.jmix.core.Messages;
import io.jmix.core.Metadata;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.Dialogs;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.component.grid.DataGridColumn;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.sys.BeanUtil;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.DialogWindow;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.LookupComponent;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardListView;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Supply;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;

@Route(value="bpm/incidents", layout=MainView.class)
@ViewController(value="IncidentData.list")
@ViewDescriptor(value="incident-data-list-view.xml")
@LookupComponent(value="incidentsDataGrid")
@DialogMode(width="50em")
public class IncidentDataListView
extends StandardListView<IncidentData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IncidentDataListView.class);
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected ComponentHelper componentHelper;
    @Autowired
    protected ViewNavigators viewNavigators;
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected Messages messages;
    @Autowired
    protected UiComponents uiComponents;
    @Autowired
    protected Dialogs dialogs;
    @Autowired
    protected Notifications notifications;
    @Autowired
    private DialogWindows dialogWindows;
    @Autowired
    protected IncidentService incidentService;
    @Autowired
    protected ProcessDefinitionService processDefinitionService;
    @ViewComponent
    protected MessageBundle messageBundle;
    @ViewComponent
    protected InstanceContainer<IncidentFilter> filterDc;
    @ViewComponent
    protected CollectionLoader<IncidentData> incidentsDl;
    @ViewComponent
    protected DataGrid<IncidentData> incidentsDataGrid;
    protected Map<String, ProcessDefinitionData> processDefinitionsMap = new HashMap();

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.initFilter();
        this.initDataGridHeaderRow();
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        this.setDefaultSort();
    }

    @Install(to="incidentsDl", target=Target.DATA_LOADER)
    protected List<IncidentData> incidentsDlLoadDelegate(LoadContext<IncidentData> loadContext) {
        LoadContext.Query query = loadContext.getQuery();
        IncidentLoadContext context = new IncidentLoadContext().setFilter((IncidentFilter)this.filterDc.getItem());
        if (query != null) {
            context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        List incidents = this.incidentService.findRuntimeIncidents(context);
        this.loadProcessDefinitions(incidents);
        return incidents;
    }

    @Install(to="pagination", subject="totalCountDelegate")
    protected Integer paginationTotalCountDelegate(DataLoadContext dataLoadContext) {
        return (int)this.incidentService.getRuntimeIncidentCount((IncidentFilter)this.filterDc.getItem());
    }

    @Supply(to="incidentsDataGrid.processDefinitionId", subject="renderer")
    protected Renderer<IncidentData> incidentsDataGridProcessDefinitionIdRenderer() {
        return new TextRenderer(arg_0 -> this.getFormattedProcess(arg_0));
    }

    @Subscribe(value="incidentsDataGrid")
    public void onIncidentsDataGridSort(SortEvent<DataGrid<IncidentData>, GridSortOrder<DataGrid<IncidentData>>> event) {
        this.incidentsDl.load();
    }

    @Supply(to="incidentsDataGrid.actions", subject="renderer")
    protected Renderer<IncidentData> incidentsDataGridActionsRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)incidentData -> {
            HorizontalLayout layout = (HorizontalLayout)this.uiComponents.create(HorizontalLayout.class);
            layout.addClassNames(new String[]{"pt-xs", "pb-xs"});
            layout.setWidth("min-content");
            JmixButton viewBtn = this.createViewButton(incidentData);
            layout.add(new Component[]{viewBtn});
            if (StringUtils.equals((CharSequence)incidentData.getIncidentId(), (CharSequence)incidentData.getCauseIncidentId())) {
                if (incidentData.isJobFailed()) {
                    JmixButton retryJobBtn = this.createRetryJobButton(incidentData);
                    layout.add(new Component[]{retryJobBtn});
                } else if (incidentData.isExternalTaskFailed()) {
                    JmixButton retryExternalTaskBtn = this.createRetryExternalTaskButton(incidentData);
                    layout.add(new Component[]{retryExternalTaskBtn});
                }
            }
            return layout;
        });
    }

    @Install(to="incidentsDataGrid.processInstanceId", subject="tooltipGenerator")
    protected String incidentsDataGridProcessInstanceIdTooltipGenerator(IncidentData incidentData) {
        return incidentData.getProcessInstanceId();
    }

    @Subscribe(id="filterDc", target=Target.DATA_CONTAINER)
    public void onFilterDcItemPropertyChange(InstanceContainer.ItemPropertyChangeEvent<IncidentFilter> event) {
        this.incidentsDl.load();
    }

    @Subscribe(value="incidentsDataGrid.bulkRetry")
    public void onIncidentsDataGridBulkRetry(ActionPerformedEvent event) {
        Set selectedItems = this.incidentsDataGrid.getSelectedItems();
        if (selectedItems.isEmpty()) {
            return;
        }
        DialogWindow dialogWindow = this.dialogWindows.view((View)this, BulkRetryIncidentView.class).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.incidentsDl.load();
            }
        }).build();
        BulkRetryIncidentView bulkRetryIncidentView = (BulkRetryIncidentView)dialogWindow.getView();
        bulkRetryIncidentView.setIncidentDataSet(selectedItems);
        dialogWindow.open();
    }

    @Install(to="incidentsDataGrid.message", subject="tooltipGenerator")
    protected String incidentsDataGridMessageTooltipGenerator(IncidentData incidentData) {
        return incidentData.getMessage();
    }

    @Install(to="incidentsDataGrid.timestamp", subject="partNameGenerator")
    protected String incidentsDataGridTimestampPartNameGenerator(IncidentData incidentData) {
        return "multiline-text-cell";
    }

    @Supply(to="incidentsDataGrid.timestamp", subject="renderer")
    protected Renderer<IncidentData> incidentsDataGridTimestampRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)incidentData -> {
            Span span = this.componentHelper.createDateSpan(incidentData.getTimestamp());
            span.addClassNames(new String[]{"overflow-hidden", "overflow-ellipsis"});
            return span;
        });
    }

    protected void initFilter() {
        IncidentFilter incidentFilter = (IncidentFilter)this.metadata.create(IncidentFilter.class);
        this.filterDc.setItem((Object)incidentFilter);
    }

    protected JmixButton createViewButton(IncidentData incidentData) {
        JmixButton viewBtn = (JmixButton)this.uiComponents.create(JmixButton.class);
        viewBtn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
        viewBtn.setText(this.messages.getMessage("actions.View"));
        viewBtn.setIcon((Component)VaadinIcon.EYE.create());
        viewBtn.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> this.viewNavigators.view((View)this, IncidentDataDetailView.class).withRouteParameters(new RouteParameters("id", incidentData.getIncidentId())).withBackwardNavigation(true).navigate());
        return viewBtn;
    }

    protected void loadProcessDefinitions(List<IncidentData> incidents) {
        List<String> idsToLoad = incidents.stream().map(IncidentData::getProcessDefinitionId).filter(processDefinitionId -> !this.processDefinitionsMap.containsKey(processDefinitionId)).distinct().toList();
        ProcessDefinitionFilter filter = (ProcessDefinitionFilter)this.metadata.create(ProcessDefinitionFilter.class);
        filter.setIdIn(idsToLoad);
        List definitions = this.processDefinitionService.findAll(new ProcessDefinitionLoadContext().setFilter(filter));
        definitions.forEach(processDefinitionData -> this.processDefinitionsMap.put(processDefinitionData.getProcessDefinitionId(), processDefinitionData));
    }

    @Nullable
    protected String getFormattedProcess(IncidentData incidentData) {
        if (StringUtils.isEmpty((CharSequence)incidentData.getProcessDefinitionId())) {
            return null;
        }
        ProcessDefinitionData processDefinitionData = this.processDefinitionsMap.computeIfAbsent(incidentData.getProcessDefinitionId(), processDefinitionId -> this.processDefinitionService.getById(processDefinitionId));
        if (processDefinitionData == null) {
            log.warn("Process definition with id '{}' not found", (Object)incidentData.getProcessDefinitionId());
            return null;
        }
        return this.messages.formatMessage("", "common.processDefinitionKeyAndVersion", new Object[]{processDefinitionData.getKey(), processDefinitionData.getVersion()});
    }

    protected void initDataGridHeaderRow() {
        HeaderRow headerRow = this.incidentsDataGrid.getDefaultHeaderRow();
        this.addColumnFilter(headerRow, "activityId", arg_0 -> this.createActivityColumnFilter(arg_0));
        this.addColumnFilter(headerRow, "message", arg_0 -> this.createMessageColumnFilter(arg_0));
        this.addColumnFilter(headerRow, "timestamp", arg_0 -> this.createTimestampColumnFilter(arg_0));
        this.addColumnFilter(headerRow, "processInstanceId", arg_0 -> this.createProcessInstanceColumnFilter(arg_0));
        this.addColumnFilter(headerRow, "processDefinitionId", arg_0 -> this.createProcessColumnFilter(arg_0));
        this.addColumnFilter(headerRow, "type", arg_0 -> this.createTypeColumnFilter(arg_0));
    }

    protected <T extends IncidentHeaderFilter> void addColumnFilter(HeaderRow headerRow, String columnName, Function<DataGridColumn<IncidentData>, T> filterProvider) {
        DataGridColumn column = this.incidentsDataGrid.getColumnByKey(columnName);
        IncidentHeaderFilter filterComponent = (IncidentHeaderFilter)filterProvider.apply((DataGridColumn<IncidentData>)column);
        BeanUtil.autowireContext((ApplicationContext)this.applicationContext, (Object)filterComponent);
        HeaderRow.HeaderCell headerCell = (HeaderRow.HeaderCell)headerRow.getCell((Grid.Column)column);
        HorizontalLayout layout = (HorizontalLayout)this.uiComponents.create(HorizontalLayout.class);
        layout.setSizeFull();
        layout.addClassNames(new String[]{"gap-s"});
        headerCell.setComponent((Component)filterComponent);
        Element child = filterComponent.getElement().getChild(0);
        if (child != null && child.getStyle() != null) {
            child.getStyle().setOverflow(Style.Overflow.HIDDEN);
            child.getStyle().set("text-overflow", "ellipsis");
            child.getStyle().setWhiteSpace(Style.WhiteSpace.PRE_WRAP);
        }
    }

    protected IncidentHeaderFilter createActivityColumnFilter(DataGridColumn<IncidentData> column) {
        return new ActivityHeaderFilter((Grid)this.incidentsDataGrid, column, this.filterDc);
    }

    protected IncidentHeaderFilter createProcessInstanceColumnFilter(DataGridColumn<IncidentData> column) {
        return new ProcessInstanceIdHeaderFilter((Grid)this.incidentsDataGrid, column, this.filterDc);
    }

    protected IncidentHeaderFilter createProcessColumnFilter(DataGridColumn<IncidentData> column) {
        return new ProcessHeaderFilter((Grid)this.incidentsDataGrid, column, this.filterDc);
    }

    protected IncidentHeaderFilter createMessageColumnFilter(DataGridColumn<IncidentData> column) {
        return new MessageHeaderFilter((Grid)this.incidentsDataGrid, column, this.filterDc);
    }

    protected IncidentHeaderFilter createTypeColumnFilter(DataGridColumn<IncidentData> column) {
        return new IncidentTypeHeaderFilter((Grid)this.incidentsDataGrid, column, this.filterDc);
    }

    protected IncidentHeaderFilter createTimestampColumnFilter(DataGridColumn<IncidentData> column) {
        return new IncidentTimestampHeaderFilter((Grid)this.incidentsDataGrid, column, this.filterDc);
    }

    protected JmixButton createRetryJobButton(IncidentData incidentData) {
        JmixButton retryJobBtn = (JmixButton)this.uiComponents.create(JmixButton.class);
        retryJobBtn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
        retryJobBtn.setText(this.messages.getMessage("actions.Retry"));
        retryJobBtn.setIcon((Component)VaadinIcon.ROTATE_LEFT.create());
        retryJobBtn.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> {
            DialogWindow dialogWindow = this.dialogWindows.view(UiComponentUtils.getCurrentView(), RetryJobView.class).withAfterCloseListener(afterClose -> {
                if (afterClose.closedWith(StandardOutcome.SAVE)) {
                    this.incidentsDl.load();
                }
            }).build();
            RetryJobView retryJobView = (RetryJobView)dialogWindow.getView();
            retryJobView.setJobId(incidentData.getConfiguration());
            dialogWindow.open();
        });
        return retryJobBtn;
    }

    protected JmixButton createRetryExternalTaskButton(IncidentData incidentData) {
        JmixButton retryExternalTaskBtn = (JmixButton)this.uiComponents.create(JmixButton.class);
        retryExternalTaskBtn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
        retryExternalTaskBtn.setText(this.messages.getMessage("actions.Retry"));
        retryExternalTaskBtn.setIcon((Component)VaadinIcon.ROTATE_LEFT.create());
        retryExternalTaskBtn.addClickListener((ComponentEventListener & Serializable)buttonClickEvent -> {
            DialogWindow dialogWindow = this.dialogWindows.view((View)this, RetryExternalTaskView.class).withAfterCloseListener(closeEvent -> {
                if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                    this.incidentsDl.load();
                }
            }).build();
            RetryExternalTaskView retryExternalTaskView = (RetryExternalTaskView)dialogWindow.getView();
            retryExternalTaskView.setExternalTaskId(incidentData.getConfiguration());
            dialogWindow.open();
        });
        return retryExternalTaskBtn;
    }

    protected void setDefaultSort() {
        List<GridSortOrder> gridSortOrders = Collections.singletonList(new GridSortOrder((Grid.Column)this.incidentsDataGrid.getColumnByKey("timestamp"), SortDirection.DESCENDING));
        this.incidentsDataGrid.sort(gridSortOrders);
    }
}

