/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.decisiondeployment;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.html.ListItem;
import com.vaadin.flow.component.html.UnorderedList;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import io.flowset.control.dto.DmnDecisionDefinition;
import io.flowset.control.entity.decisiondefinition.DecisionDefinitionData;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.ViewComponent;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

@FragmentDescriptor(value="decision-deployment-confirm-content-fragment.xml")
public class DecisionDeploymentConfirmContentFragment
extends Fragment<VerticalLayout> {
    @ViewComponent
    protected VerticalLayout existingDecisionsVBox;
    @ViewComponent
    protected Icon warningIcon;
    @ViewComponent
    protected H5 warningHeader;
    @ViewComponent
    protected UnorderedList existingDecisionsList;
    @ViewComponent
    protected UnorderedList deployingDecisionsList;

    @Subscribe
    public void onReady(Fragment.ReadyEvent event) {
        this.initExistingDecisionsWarningStyles();
        this.deployingDecisionsList.addClassName("m-0");
    }

    public void setExistingDecisions(List<DecisionDefinitionData> existingDecisions) {
        if (CollectionUtils.isNotEmpty(existingDecisions)) {
            this.existingDecisionsVBox.setVisible(true);
            existingDecisions.forEach(decisionDefinitionData -> {
                ListItem listItem = (ListItem)this.uiComponents.create(ListItem.class);
                listItem.setText(decisionDefinitionData.getKey());
                this.existingDecisionsList.add(new Component[]{listItem});
            });
        }
    }

    public void setDeployingDecisions(List<DmnDecisionDefinition> deployingDecisions) {
        deployingDecisions.forEach(deployingDecision -> {
            ListItem listItem = (ListItem)this.uiComponents.create(ListItem.class);
            listItem.setText(deployingDecision.getKey());
            this.deployingDecisionsList.add(new Component[]{listItem});
        });
    }

    protected void initExistingDecisionsWarningStyles() {
        this.warningIcon.addClassNames(new String[]{"text-warning"});
        this.warningHeader.addClassNames(new String[]{"text-warning-contrast"});
        this.existingDecisionsVBox.addClassNames(new String[]{"border-warning", "border", "rounded-l", "bg-warning-10"});
        this.existingDecisionsList.addClassName("m-0");
    }
}

