/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.dashboard;

import com.google.common.collect.ImmutableList;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import io.flowset.control.entity.dashboard.IncidentStatistics;
import io.flowset.control.entity.dashboard.ProcessDefinitionStatistics;
import io.flowset.control.view.dashboard.DashboardCard;
import io.flowset.control.view.incidentsstatistics.IncidentsStatisticsView;
import io.flowset.control.view.processdefinitionsstatistics.RunningProcessesStatisticsView;
import io.jmix.chartsflowui.component.Chart;
import io.jmix.chartsflowui.kit.component.model.Title;
import io.jmix.chartsflowui.kit.component.model.shared.Color;
import io.jmix.core.Metadata;
import io.jmix.core.entity.KeyValueEntity;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.CollectionContainer;
import io.jmix.flowui.model.KeyValueCollectionContainer;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.ViewComponent;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@FragmentDescriptor(value="running-instances-and-incidents-fragment.xml")
public class RunningInstancesAndIncidentsFragment
extends DashboardCard<Div> {
    public static final List<Color> INCIDENT_COLOR_PALETTE = ImmutableList.of((Object)new Color("#ebdba4"), (Object)new Color("#f2d643"), (Object)new Color("#ffb248"), (Object)new Color("#eb8146"), (Object)new Color("#d95850"), (Object)new Color("#893448"));
    protected static final Logger log = LoggerFactory.getLogger(RunningInstancesAndIncidentsFragment.class);
    @ViewComponent
    protected KeyValueCollectionContainer groupedProcessInstancesDc;
    @ViewComponent
    protected CollectionContainer<ProcessDefinitionStatistics> processDefinitionStatisticsDc;
    @Autowired
    protected Metadata metadata;
    @ViewComponent
    protected Chart runningInstancesChart;
    @ViewComponent
    protected KeyValueCollectionContainer groupedIncidentsDc;
    @ViewComponent
    protected Chart incidentsChart;
    @Autowired
    protected DialogWindows dialogWindows;
    @ViewComponent
    protected VerticalLayout incidentLoadingBox;
    @ViewComponent
    protected VerticalLayout runningInstanceLoadingBox;
    @ViewComponent
    protected JmixButton viewIncidentsStatBtn;
    @ViewComponent
    protected JmixButton viewRunningInstancesStatBtn;
    @ViewComponent
    protected FlexLayout incidentsChartContainer;
    @ViewComponent
    protected FlexLayout runningInstancesChartContainer;

    @Subscribe
    protected void onAttachEvent(AttachEvent event) {
        this.incidentsChart.setColorPalette(INCIDENT_COLOR_PALETTE.toArray(new Color[0]));
        this.initCharts(List.of());
    }

    public void refresh(List<ProcessDefinitionStatistics> items) {
        this.updateComponents(false);
        this.initCharts(items);
    }

    protected void initCharts(List<ProcessDefinitionStatistics> items) {
        this.processDefinitionStatisticsDc.setItems(items);
        this.initRunningInstancesChart();
        this.initIncidentChart();
    }

    protected void updateComponents(boolean isLoading) {
        this.runningInstanceLoadingBox.setVisible(isLoading);
        this.runningInstancesChartContainer.setVisible(!isLoading);
        this.viewRunningInstancesStatBtn.setVisible(!isLoading);
        this.incidentLoadingBox.setVisible(isLoading);
        this.incidentsChartContainer.setVisible(!isLoading);
        this.viewIncidentsStatBtn.setVisible(!isLoading);
    }

    @Subscribe(id="viewRunningInstancesStatBtn", subject="clickListener")
    public void onViewRunningInstancesStatBtnClick(ClickEvent<JmixButton> event) {
        this.dialogWindows.view(UiComponentUtils.getCurrentView(), RunningProcessesStatisticsView.class).withViewConfigurer(view -> view.setStatistics(this.groupedProcessInstancesDc.getItems())).build().open();
    }

    @Subscribe(id="viewIncidentsStatBtn", subject="clickListener")
    public void onViewIncidentStatBtnClick(ClickEvent<JmixButton> event) {
        this.dialogWindows.view(UiComponentUtils.getCurrentView(), IncidentsStatisticsView.class).withViewConfigurer(view -> view.setStatistics(this.groupedIncidentsDc.getItems())).build().open();
    }

    protected void initRunningInstancesChart() {
        List definitionStatistics = this.processDefinitionStatisticsDc.getItems();
        Map<String, Integer> instancesStatistics = definitionStatistics.stream().filter(processDefinitionStatistics -> processDefinitionStatistics.getInstanceCount() != null && processDefinitionStatistics.getInstanceCount() > 0).collect(Collectors.groupingBy(o -> o.getProcessDefinition().getKey(), Collectors.summingInt(ProcessDefinitionStatistics::getInstanceCount)));
        this.groupedProcessInstancesDc.setItems(instancesStatistics.entrySet().stream().map(entry -> {
            KeyValueEntity keValueEntity = (KeyValueEntity)this.metadata.create(KeyValueEntity.class);
            keValueEntity.setValue("process", entry.getKey());
            keValueEntity.setValue("instanceCount", entry.getValue());
            return keValueEntity;
        }).toList());
        long totalCount = definitionStatistics.stream().mapToInt(ProcessDefinitionStatistics::getInstanceCount).sum();
        this.runningInstancesChart.setTitle(this.createTotalCountTitle(totalCount));
    }

    protected void initIncidentChart() {
        List definitionStatistics = this.processDefinitionStatisticsDc.getItems();
        Map<String, Integer> groupedIncidentStatistics = definitionStatistics.stream().filter(processDefinitionStatistics -> !processDefinitionStatistics.getIncidents().isEmpty()).collect(Collectors.groupingBy(o -> o.getProcessDefinition().getKey(), Collectors.summingInt(value -> value.getIncidents().stream().mapToInt(IncidentStatistics::getIncidentCount).sum())));
        this.groupedIncidentsDc.setItems(groupedIncidentStatistics.entrySet().stream().map(entry -> {
            KeyValueEntity keValueEntity = (KeyValueEntity)this.metadata.create(KeyValueEntity.class);
            keValueEntity.setValue("process", entry.getKey());
            keValueEntity.setValue("incidentCount", entry.getValue());
            return keValueEntity;
        }).toList());
        long totalIncidentCount = groupedIncidentStatistics.values().stream().reduce(0, Integer::sum).intValue();
        this.incidentsChart.setTitle(this.createTotalCountTitle(totalIncidentCount));
    }

    protected Title createTotalCountTitle(long totalCount) {
        return ((Title)((Title)new Title().withText(this.formattedCount(totalCount)).withLeft("center")).withTop("center")).withTextStyle((Title.TextStyle)new Title.TextStyle().withFontSize(Integer.valueOf(32)));
    }
}

