/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.dashboard;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import io.flowset.control.entity.engine.BpmEngine;
import io.flowset.control.property.UiProperties;
import io.flowset.control.service.dashboard.DashboardService;
import io.flowset.control.service.engine.EngineService;
import io.flowset.control.service.engine.EngineUiService;
import io.flowset.control.view.bpmengine.BpmEngineDetailView;
import io.flowset.control.view.dashboard.DashboardFragment;
import io.flowset.control.view.dashboard.DeployedProcessesStatisticsCardFragment;
import io.flowset.control.view.dashboard.ProcessInstanceStatisticsCardFragment;
import io.flowset.control.view.dashboard.RecentActivityCardFragment;
import io.flowset.control.view.dashboard.RunningInstancesAndIncidentsFragment;
import io.flowset.control.view.dashboard.UserTaskStatisticsCardFragment;
import io.jmix.core.security.CurrentAuthentication;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.asynctask.UiAsyncTasks;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.ViewComponent;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@FragmentDescriptor(value="dashboard-fragment.xml")
public class DashboardFragment
extends Fragment<VerticalLayout> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DashboardFragment.class);
    @ViewComponent
    protected H3 welcomeMessage;
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected CurrentAuthentication currentAuthentication;
    @Autowired
    protected DialogWindows dialogWindows;
    @Autowired
    protected EngineService engineService;
    @ViewComponent
    protected Div dashboardContainer;
    @ViewComponent
    protected Div noEnginesContainer;
    @ViewComponent
    protected InstanceContainer<BpmEngine> selectedEngineDc;
    @ViewComponent
    protected DeployedProcessesStatisticsCardFragment deployedProcessesCard;
    @ViewComponent
    protected ProcessInstanceStatisticsCardFragment processInstancesCard;
    @ViewComponent
    protected UserTaskStatisticsCardFragment userTasksCard;
    @ViewComponent
    protected RecentActivityCardFragment recentActivityCard;
    @ViewComponent
    protected RunningInstancesAndIncidentsFragment runningInstancesAndIncidentsCard;
    @Autowired
    protected UiAsyncTasks uiAsyncTasks;
    @Autowired
    protected DashboardService dashboardService;
    @Autowired
    protected UiProperties uiProperties;
    @Autowired
    protected EngineUiService engineUiService;

    @Subscribe
    public void onReady(Fragment.ReadyEvent event) {
        this.welcomeMessage.setText(this.messageBundle.formatMessage("welcomeMessage", new Object[]{this.currentAuthentication.getUser().getUsername()}));
        this.updateDashboard();
    }

    public void updateDashboard() {
        boolean engineExists = this.engineService.engineExists();
        if (!engineExists) {
            this.noEnginesContainer.setVisible(true);
            this.dashboardContainer.setVisible(false);
        } else {
            this.noEnginesContainer.setVisible(false);
            this.dashboardContainer.setVisible(true);
            this.updateDashboardCards();
        }
    }

    protected void updateDashboardCards() {
        this.deployedProcessesCard.setLoading();
        this.processInstancesCard.setLoading();
        this.userTasksCard.setLoading();
        this.runningInstancesAndIncidentsCard.setLoading();
        this.recentActivityCard.setLoading();
        this.uiAsyncTasks.supplierConfigurer(() -> this.loadDashboardData((BpmEngine)this.selectedEngineDc.getItemOrNull())).withTimeout(this.uiProperties.getDashboardLoadTimeoutSec(), TimeUnit.SECONDS).withResultHandler(dashboardData -> {
            this.deployedProcessesCard.refresh(dashboardData.getProcessCount());
            this.processInstancesCard.refresh(dashboardData.getRunningInstanceCount(), dashboardData.getSuspendedInstanceCount());
            this.userTasksCard.refresh(dashboardData.getUserTasksCount());
            this.recentActivityCard.refresh(dashboardData.getRecentActivity());
            this.runningInstancesAndIncidentsCard.refresh(dashboardData.getProcessDefinitionStatistics());
        }).withExceptionHandler(throwable -> {
            log.error("Error occurs on dashboard data loading", throwable);
            this.deployedProcessesCard.refresh(0L);
            this.processInstancesCard.refresh(0L, 0L);
            this.userTasksCard.refresh(0L);
            this.recentActivityCard.refresh(List.of());
            this.runningInstancesAndIncidentsCard.refresh(List.of());
        }).supplyAsync();
    }

    @Subscribe(id="createBpmEnginBtn", subject="clickListener")
    public void onCreateBpmEnginBtnClick(ClickEvent<JmixButton> event) {
        this.dialogWindows.detail(UiComponentUtils.getCurrentView(), BpmEngine.class).newEntity().withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                BpmEngineDetailView detailView = (BpmEngineDetailView)closeEvent.getView();
                BpmEngine createdEngine = (BpmEngine)detailView.getEditedEntity();
                this.engineUiService.selectEngine(createdEngine);
            }
        }).open();
    }

    protected DashboardData loadDashboardData(BpmEngine engine) {
        DashboardData dashboardData = new DashboardData();
        if (engine == null) {
            return dashboardData;
        }
        BpmEngine persistedEngined = this.engineService.findEngineByUuid(engine.getId());
        long deployedProcessesCount = this.dashboardService.getDeployedProcessesCount(persistedEngined);
        dashboardData.setProcessCount(deployedProcessesCount);
        long runningProcessCount = this.dashboardService.getRunningProcessCount(persistedEngined);
        dashboardData.setRunningInstanceCount(runningProcessCount);
        long suspendedProcessCount = this.dashboardService.getSuspendedProcessCount(persistedEngined);
        dashboardData.setSuspendedInstanceCount(suspendedProcessCount);
        List processStatistics = this.dashboardService.getProcessDefinitionStatistics(persistedEngined);
        dashboardData.setProcessDefinitionStatistics(processStatistics);
        long userTasksCount = this.dashboardService.getUserTasksCount(persistedEngined);
        dashboardData.setUserTasksCount(userTasksCount);
        List recentActivity = this.dashboardService.getRecentActivityStatistics(persistedEngined);
        dashboardData.setRecentActivity(recentActivity);
        return dashboardData;
    }
}

