/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.bpmengine;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.router.RouteParameters;
import io.flowset.control.entity.engine.BpmEngine;
import io.flowset.control.service.engine.EngineService;
import io.jmix.flowui.Dialogs;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.action.DialogAction;
import io.jmix.flowui.component.ListDataComponent;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.fragmentrenderer.FragmentRenderer;
import io.jmix.flowui.fragmentrenderer.RendererItemContainer;
import io.jmix.flowui.kit.action.Action;
import io.jmix.flowui.kit.action.ActionVariant;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.ViewComponent;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@FragmentDescriptor(value="bpm-engine-list-actions-fragment.xml")
@RendererItemContainer(value="bpmEngineDc")
public class BpmEngineListActionsFragment
extends FragmentRenderer<HorizontalLayout, BpmEngine> {
    protected DataGrid<BpmEngine> sourceDataGrid;
    @ViewComponent
    protected JmixButton markAsDefaultBtn;
    @Autowired
    protected ViewNavigators viewNavigators;
    @Autowired
    protected Dialogs dialogs;
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected EngineService engineService;
    @ViewComponent
    protected CollectionLoader<Object> bpmEnginesDl;

    public void setSourceDataGrid(DataGrid<BpmEngine> sourceDataGrid) {
        this.sourceDataGrid = sourceDataGrid;
    }

    public void setItem(BpmEngine item) {
        super.setItem((Object)item);
        if (BooleanUtils.isNotTrue((Boolean)item.getIsDefault())) {
            this.markAsDefaultBtn.setVisible(true);
        }
    }

    @Subscribe(id="editBtn", subject="clickListener")
    public void onEditBtnClick(ClickEvent<JmixButton> event) {
        this.viewNavigators.detailView((ListDataComponent)this.sourceDataGrid).withRouteParameters(new RouteParameters("id", ((BpmEngine)this.item).getId().toString())).navigate();
    }

    @Subscribe(id="markAsDefaultBtn", subject="clickListener")
    public void onMarkAsDefaultBtnClick(ClickEvent<JmixButton> event) {
        ((Dialogs.OptionDialogBuilder)((Dialogs.OptionDialogBuilder)this.dialogs.createOptionDialog().withHeader(this.messageBundle.getMessage("markAsDefault.header"))).withContent((Component)new Html(this.messageBundle.formatMessage("markAsDefault.text", new Object[]{((BpmEngine)this.item).getName()})))).withActions(new Action[]{new DialogAction(DialogAction.Type.OK).withVariant(ActionVariant.PRIMARY).withHandler(actionPerformedEvent -> {
            this.engineService.markAsDefault((BpmEngine)this.item);
            this.bpmEnginesDl.load();
        }), new DialogAction(DialogAction.Type.CANCEL)}).open();
    }
}

