/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.uicomponent.viewer.handler;

import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.RouterLink;
import io.flowset.control.entity.filter.ProcessDefinitionFilter;
import io.flowset.control.entity.processdefinition.ProcessDefinitionData;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.service.processdefinition.ProcessDefinitionLoadContext;
import io.flowset.control.service.processdefinition.ProcessDefinitionService;
import io.flowset.control.view.processdefinition.ProcessDefinitionDetailView;
import io.flowset.control.view.processinstance.CalledProcessInstanceDataListView;
import io.flowset.control.view.processinstance.ProcessInstanceDetailView;
import io.flowset.uikit.component.bpmnviewer.model.CallActivityData;
import io.jmix.core.Messages;
import io.jmix.core.Metadata;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.view.View;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component(value="control_CallActivityOverlayClickHandler")
public class CallActivityOverlayClickHandler {
    protected final ProcessDefinitionService processDefinitionService;
    protected final Metadata metadata;
    protected final Notifications notifications;
    protected final ViewNavigators viewNavigators;
    protected final DialogWindows dialogWindows;
    protected final Messages messages;

    public void handleProcessNavigation(ProcessDefinitionData parentProcess, CallActivityData callActivityData, boolean fromDialog) {
        ProcessDefinitionData calledProcess = this.findCalledProcess(callActivityData, parentProcess);
        if (calledProcess != null) {
            View currentView = UiComponentUtils.getCurrentView();
            if (fromDialog) {
                RouterLink routerLink = new RouterLink(ProcessDefinitionDetailView.class, new RouteParameters("id", calledProcess.getId()));
                currentView.getUI().ifPresent(ui -> ui.getPage().open(routerLink.getHref()));
            } else {
                this.viewNavigators.detailView(currentView, ProcessDefinitionData.class).withViewClass(ProcessDefinitionDetailView.class).withRouteParameters(new RouteParameters("id", calledProcess.getId())).withBackwardNavigation(true).navigate();
            }
        }
    }

    public void handleInstancesNavigation(List<String> calledProcessInstanceIds) {
        if (CollectionUtils.size(calledProcessInstanceIds) == 1) {
            this.viewNavigators.detailView(UiComponentUtils.getCurrentView(), ProcessInstanceData.class).withViewClass(ProcessInstanceDetailView.class).withRouteParameters(new RouteParameters("id", calledProcessInstanceIds.get(0))).withBackwardNavigation(true).navigate();
        } else {
            this.dialogWindows.view(UiComponentUtils.getCurrentView(), CalledProcessInstanceDataListView.class).withViewConfigurer(view -> view.setProcessInstanceIds(calledProcessInstanceIds)).open();
        }
    }

    @Nullable
    protected ProcessDefinitionData findCalledProcess(CallActivityData callActivityData, ProcessDefinitionData parentProcess) {
        ProcessDefinitionFilter filter = this.createFilter(callActivityData, parentProcess);
        if (filter == null) {
            return null;
        }
        List calledProcesses = this.processDefinitionService.findAll(new ProcessDefinitionLoadContext().setFilter(filter));
        if (CollectionUtils.isEmpty((Collection)calledProcesses)) {
            this.notifications.create(this.messages.formatMessage("", "calledProcessNotFound.title", new Object[]{callActivityData.getCalledElement()}), this.getAdditionalFilterMessage(callActivityData.getBinding(), filter)).withType(Notifications.Type.WARNING).show();
            return null;
        }
        return (ProcessDefinitionData)calledProcesses.get(0);
    }

    protected String getAdditionalFilterMessage(@Nullable String binding, ProcessDefinitionFilter filter) {
        String bindingName;
        String additionalParamMessage = switch (bindingName = (String)StringUtils.defaultIfEmpty((CharSequence)binding, (CharSequence)"latest")) {
            case "version" -> this.messages.formatMessage("", "calledProcessNotFound.description.version", new Object[]{filter.getVersion()});
            case "versionTag" -> this.messages.formatMessage("", "calledProcessNotFound.description.versionTag", new Object[]{filter.getVersionTag()});
            case "deployment" -> this.messages.formatMessage("", "calledProcessNotFound.description.deployment", new Object[]{filter.getDeploymentId()});
            default -> "";
        };
        return String.join((CharSequence)"\n", this.messages.formatMessage("", "calledProcessNotFound.description.binding", new Object[]{bindingName}), additionalParamMessage);
    }

    @Nullable
    protected ProcessDefinitionFilter createFilter(CallActivityData callActivityData, ProcessDefinitionData parentProcess) {
        String processKey = callActivityData.getCalledElement();
        String binding = callActivityData.getBinding();
        ProcessDefinitionFilter filter = (ProcessDefinitionFilter)this.metadata.create(ProcessDefinitionFilter.class);
        filter.setLatestVersionOnly(Boolean.valueOf(false));
        filter.setKey(processKey);
        switch (binding) {
            case "version": {
                try {
                    Integer version = Integer.parseInt(callActivityData.getVersion());
                    filter.setVersion(version);
                    break;
                }
                catch (NumberFormatException e) {
                    this.notifications.create(this.messages.formatMessage("", "calledProcessNotFound.title", new Object[]{processKey}), this.messages.formatMessage("", "calledProcessNotFound.description.invalidVersion", new Object[]{callActivityData.getVersion()})).withType(Notifications.Type.WARNING).show();
                    return null;
                }
            }
            case "versionTag": {
                filter.setVersionTag(callActivityData.getVersionTag());
                break;
            }
            case "deployment": {
                filter.setDeploymentId(parentProcess.getDeploymentId());
                break;
            }
            default: {
                filter.setLatestVersionOnly(Boolean.valueOf(true));
            }
        }
        return filter;
    }

    @Generated
    public CallActivityOverlayClickHandler(ProcessDefinitionService processDefinitionService, Metadata metadata, Notifications notifications, ViewNavigators viewNavigators, DialogWindows dialogWindows, Messages messages) {
        this.processDefinitionService = processDefinitionService;
        this.metadata = metadata;
        this.notifications = notifications;
        this.viewNavigators = viewNavigators;
        this.dialogWindows = dialogWindows;
        this.messages = messages;
    }
}

