/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.service.processinstance.impl;

import io.flowset.control.service.processinstance.MigrationService;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.community.rest.client.api.MigrationApiClient;
import org.camunda.community.rest.client.model.MigrationExecutionDto;
import org.camunda.community.rest.client.model.MigrationPlanDto;
import org.camunda.community.rest.client.model.MigrationPlanGenerationDto;
import org.camunda.community.rest.client.model.MigrationPlanReportDto;
import org.camunda.community.rest.client.model.ProcessInstanceQueryDto;
import org.camunda.community.rest.impl.RemoteRuntimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="control_MigrationService")
public class MigrationServiceImpl
implements MigrationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationServiceImpl.class);
    protected final MigrationApiClient migrationApiClient;
    protected final RemoteRuntimeService remoteRuntimeService;

    public MigrationServiceImpl(MigrationApiClient migrationApiClient, RemoteRuntimeService remoteRuntimeService) {
        this.migrationApiClient = migrationApiClient;
        this.remoteRuntimeService = remoteRuntimeService;
    }

    public List<String> validateMigrationOfSingleProcessInstance(String processInstanceId, String targetProcessDefinitionId) {
        ProcessInstance processInstance = this.getProcessInstanceById(processInstanceId);
        return this.validateMigrationOfProcessInstances(processInstance.getProcessDefinitionId(), targetProcessDefinitionId);
    }

    public void migrateSingleProcessInstance(String processInstanceId, String targetProcessDefinitionId) {
        ProcessInstance processInstance = this.getProcessInstanceById(processInstanceId);
        MigrationPlanDto migrationPlan = this.createMigrationPlan(processInstance.getProcessDefinitionId(), targetProcessDefinitionId);
        ResponseEntity response = this.migrationApiClient.executeMigrationPlan(new MigrationExecutionDto().migrationPlan(migrationPlan).processInstanceIds(List.of(processInstanceId)));
        if (!response.getStatusCode().is2xxSuccessful()) {
            log.error("Error on process instance migration: process instance {}, target process definition {}", (Object)processInstanceId, (Object)targetProcessDefinitionId);
        }
    }

    public List<String> validateMigrationOfProcessInstances(String srcProcessDefinitionId, String targetProcessDefinitionId) {
        MigrationPlanDto migrationPlanDto = this.createMigrationPlan(srcProcessDefinitionId, targetProcessDefinitionId);
        ResponseEntity response = this.migrationApiClient.validateMigrationPlan(migrationPlanDto);
        if (response.getStatusCode().is2xxSuccessful()) {
            List instructionReports = Optional.ofNullable((MigrationPlanReportDto)response.getBody()).map(MigrationPlanReportDto::getInstructionReports).orElse(List.of());
            return instructionReports.stream().flatMap(validationInstruction -> validationInstruction.getFailures().stream()).toList();
        }
        log.error("Error on process instances migration: source process definition {}, target process definition {}", (Object)srcProcessDefinitionId, (Object)targetProcessDefinitionId);
        return List.of();
    }

    public void migrateAllProcessInstances(String srcProcessDefinitionId, String targetProcessDefinitionId) {
        MigrationPlanDto migrationPlan = this.createMigrationPlan(srcProcessDefinitionId, targetProcessDefinitionId);
        ProcessInstanceQueryDto procInstancesQuery = new ProcessInstanceQueryDto().processDefinitionId(srcProcessDefinitionId);
        MigrationExecutionDto migrationDto = new MigrationExecutionDto().migrationPlan(migrationPlan).processInstanceQuery(procInstancesQuery);
        ResponseEntity response = this.migrationApiClient.executeMigrationPlanAsync(migrationDto);
        if (!response.getStatusCode().is2xxSuccessful()) {
            log.error("Error on starting async process instance migration: source process definition {}, target process definition {}", (Object)srcProcessDefinitionId, (Object)targetProcessDefinitionId);
        }
    }

    protected ProcessInstance getProcessInstanceById(String processInstanceId) {
        return (ProcessInstance)this.remoteRuntimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
    }

    @Nullable
    protected MigrationPlanDto createMigrationPlan(String sourceProcessDefinitionId, String targetProcessDefinitionId) {
        MigrationPlanGenerationDto migrationDto = new MigrationPlanGenerationDto();
        migrationDto.setSourceProcessDefinitionId(sourceProcessDefinitionId);
        migrationDto.setTargetProcessDefinitionId(targetProcessDefinitionId);
        ResponseEntity migrationPlanDtoResponseEntity = this.migrationApiClient.generateMigrationPlan(migrationDto);
        if (migrationPlanDtoResponseEntity.getStatusCode().is2xxSuccessful() && migrationPlanDtoResponseEntity.getBody() != null) {
            return (MigrationPlanDto)migrationPlanDtoResponseEntity.getBody();
        }
        log.error("Error on generating migration plan: source process definition {}, target process definition {}", (Object)sourceProcessDefinitionId, (Object)targetProcessDefinitionId);
        return null;
    }
}

