/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.service.job.impl;

import com.google.common.base.Strings;
import feign.FeignException;
import io.flowset.control.entity.filter.JobFilter;
import io.flowset.control.entity.job.JobData;
import io.flowset.control.entity.job.JobDefinitionData;
import io.flowset.control.mapper.JobMapper;
import io.flowset.control.service.client.EngineRestClient;
import io.flowset.control.service.job.JobLoadContext;
import io.flowset.control.service.job.JobService;
import io.flowset.control.util.EngineRestUtils;
import io.jmix.core.Sort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.camunda.community.rest.client.api.HistoryApiClient;
import org.camunda.community.rest.client.api.JobApiClient;
import org.camunda.community.rest.client.api.JobDefinitionApiClient;
import org.camunda.community.rest.client.model.CountResultDto;
import org.camunda.community.rest.client.model.JobDefinitionDto;
import org.camunda.community.rest.client.model.JobQueryDto;
import org.camunda.community.rest.client.model.JobQueryDtoSortingInner;
import org.camunda.community.rest.client.model.JobRetriesDto;
import org.camunda.community.rest.client.model.SetJobRetriesDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service(value="control_JobService")
public class JobServiceImpl
implements JobService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobServiceImpl.class);
    protected final JobMapper jobMapper;
    protected final JobApiClient jobApiClient;
    protected final JobDefinitionApiClient jobDefinitionApiClient;
    protected final HistoryApiClient historyApiClient;
    protected final EngineRestClient engineRestClient;

    public JobServiceImpl(JobMapper jobMapper, JobApiClient jobApiClient, JobDefinitionApiClient jobDefinitionApiClient, HistoryApiClient historyApiClient, EngineRestClient engineRestClient) {
        this.jobMapper = jobMapper;
        this.jobApiClient = jobApiClient;
        this.jobDefinitionApiClient = jobDefinitionApiClient;
        this.historyApiClient = historyApiClient;
        this.engineRestClient = engineRestClient;
    }

    public List<JobData> findAll(JobLoadContext loadContext) {
        JobQueryDto jobQueryDto = this.createJobQueryDto((JobFilter)loadContext.getFilter());
        jobQueryDto.setSorting(this.createSortOptions(loadContext.getSort()));
        ResponseEntity jobsResponse = this.jobApiClient.queryJobs(loadContext.getFirstResult(), loadContext.getMaxResults(), jobQueryDto);
        if (jobsResponse.getStatusCode().is2xxSuccessful()) {
            List jobDtoList = (List)jobsResponse.getBody();
            return CollectionUtils.emptyIfNull((Collection)jobDtoList).stream().map(arg_0 -> ((JobMapper)this.jobMapper).fromJobDto(arg_0)).toList();
        }
        log.error("Error on loading runtime jobs: query {}, status code {}", (Object)jobQueryDto, (Object)jobsResponse.getStatusCode());
        return List.of();
    }

    public long getCount(@Nullable JobFilter jobFilter) {
        JobQueryDto jobQueryDto = this.createJobQueryDto(jobFilter);
        ResponseEntity jobsResponse = this.jobApiClient.queryJobsCount(jobQueryDto);
        if (jobsResponse.getStatusCode().is2xxSuccessful()) {
            return EngineRestUtils.getCountResult((CountResultDto)((CountResultDto)jobsResponse.getBody()));
        }
        log.error("Error on loading runtime jobs count: query {}, status code {}", (Object)jobQueryDto, (Object)jobsResponse.getStatusCode());
        return 0L;
    }

    @Nullable
    public JobDefinitionData findJobDefinition(String jobDefinitionId) {
        ResponseEntity response = this.jobDefinitionApiClient.getJobDefinition(jobDefinitionId);
        if (response.getStatusCode().is2xxSuccessful()) {
            JobDefinitionDto jobDefinitionDto = (JobDefinitionDto)response.getBody();
            return jobDefinitionDto != null ? this.jobMapper.fromJobDefinitionDto(jobDefinitionDto) : null;
        }
        log.error("Error on loading stacktrace for job definition id {}, status code {}", (Object)jobDefinitionId, (Object)response.getStatusCode());
        return null;
    }

    public void setJobRetries(String jobId, int retries) {
        ResponseEntity response = this.jobApiClient.setJobRetries(jobId, new JobRetriesDto().retries(Integer.valueOf(retries)));
        if (!response.getStatusCode().is2xxSuccessful()) {
            log.error("Error on loading update retries to {} for job with id {}, status code {}", new Object[]{retries, jobId, response.getStatusCode()});
        } else {
            log.debug("Update retries count for job {}. New value: {}", (Object)jobId, (Object)retries);
        }
    }

    public void setJobRetriesAsync(List<String> jobIds, int retries) {
        ResponseEntity response = this.jobApiClient.setJobRetriesAsyncOperation(new SetJobRetriesDto().jobIds(jobIds).retries(Integer.valueOf(retries)));
        if (!response.getStatusCode().is2xxSuccessful()) {
            log.error("Error on loading update retries to {} for job with ids {}, status code {}", new Object[]{retries, jobIds, response.getStatusCode()});
        } else {
            log.debug("Async update retries count for jobs {}. New value: {}", jobIds, (Object)retries);
        }
    }

    public String getErrorDetails(String jobId) {
        ResponseEntity response = this.engineRestClient.getStacktrace(jobId);
        if (response.getStatusCode().is2xxSuccessful()) {
            return Strings.nullToEmpty((String)((String)response.getBody()));
        }
        return "";
    }

    public String getHistoryErrorDetails(String jobId) {
        ResponseEntity response = this.engineRestClient.getStacktraceHistoricJobLog(jobId);
        if (response.getStatusCode().is2xxSuccessful()) {
            return Strings.nullToEmpty((String)((String)response.getBody()));
        }
        return "";
    }

    public boolean isHistoryJobLogPresent(String jobId) {
        try {
            ResponseEntity jobLogResponse = this.historyApiClient.getHistoricJobLog(jobId);
            return jobLogResponse.getStatusCode().is2xxSuccessful() && jobLogResponse.getBody() != null;
        }
        catch (FeignException e) {
            log.error("Error checking job log presence for jobId: {}, error: ", (Object)jobId, (Object)e);
            return false;
        }
    }

    protected JobQueryDto createJobQueryDto(JobFilter filter) {
        JobQueryDto jobQueryDto = new JobQueryDto();
        if (filter != null) {
            jobQueryDto.processInstanceId(filter.getProcessInstanceId());
        }
        return jobQueryDto;
    }

    @Nullable
    protected List<JobQueryDtoSortingInner> createSortOptions(Sort sort) {
        if (sort == null) {
            return null;
        }
        ArrayList<JobQueryDtoSortingInner> jobQueryDtoSortingInners = new ArrayList<JobQueryDtoSortingInner>();
        for (Sort.Order order : sort.getOrders()) {
            JobQueryDtoSortingInner sortOption = new JobQueryDtoSortingInner();
            switch (order.getProperty()) {
                case "id": {
                    sortOption.setSortBy(JobQueryDtoSortingInner.SortByEnum.JOB_ID);
                    break;
                }
                case "retries": {
                    sortOption.setSortBy(JobQueryDtoSortingInner.SortByEnum.JOB_RETRIES);
                    break;
                }
                case "dueDate": {
                    sortOption.setSortBy(JobQueryDtoSortingInner.SortByEnum.JOB_DUE_DATE);
                    break;
                }
                case "priority": {
                    sortOption.setSortBy(JobQueryDtoSortingInner.SortByEnum.JOB_PRIORITY);
                    break;
                }
            }
            if (order.getDirection() == Sort.Direction.ASC) {
                sortOption.setSortOrder(JobQueryDtoSortingInner.SortOrderEnum.ASC);
            } else if (order.getDirection() == Sort.Direction.DESC) {
                sortOption.setSortOrder(JobQueryDtoSortingInner.SortOrderEnum.DESC);
            }
            if (sortOption.getSortBy() == null || sortOption.getSortOrder() == null) continue;
            jobQueryDtoSortingInners.add(sortOption);
        }
        return jobQueryDtoSortingInners;
    }
}

