/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.mapper;

import io.flowset.control.entity.variable.ObjectTypeInfo;
import io.flowset.control.entity.variable.VariableInstanceData;
import io.flowset.control.entity.variable.VariableValueInfo;
import io.jmix.core.Metadata;
import java.util.Map;
import org.camunda.community.rest.client.model.VariableValueDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessVariableMapper {
    @Autowired
    Metadata metadata;

    public VariableInstanceData fromProcessKeyValueModel(Map.Entry<String, Object> stringObjectEntry) {
        VariableInstanceData variableInstance = (VariableInstanceData)this.metadata.create(VariableInstanceData.class);
        variableInstance.setName(stringObjectEntry.getKey());
        variableInstance.setValue(stringObjectEntry.getValue());
        return variableInstance;
    }

    public VariableInstanceData fromVariableDto(Map.Entry<String, VariableValueDto> dto) {
        VariableInstanceData variableInstance = (VariableInstanceData)this.metadata.create(VariableInstanceData.class);
        variableInstance.setName(dto.getKey());
        variableInstance.setValue(dto.getValue().getValue());
        variableInstance.setType(dto.getValue().getType());
        Map valueInfoMap = dto.getValue().getValueInfo();
        if (valueInfoMap != null && !valueInfoMap.isEmpty()) {
            VariableValueInfo variableValueInfo = (VariableValueInfo)this.metadata.create(VariableValueInfo.class);
            if (valueInfoMap.containsKey("object")) {
                ObjectTypeInfo objectTypeInfo = (ObjectTypeInfo)this.metadata.create(ObjectTypeInfo.class);
                objectTypeInfo.setObjectTypeName((String)((Map)valueInfoMap.get("object")).get("objectTypeName"));
                objectTypeInfo.setSerializationDataFormat((String)((Map)valueInfoMap.get("object")).get("serializationDataFormat"));
            }
            variableValueInfo.setEncoding((String)valueInfoMap.get("encoding"));
            variableValueInfo.setFilename((String)valueInfoMap.get("filename"));
            variableValueInfo.setMimeType((String)valueInfoMap.get("mimetype"));
        }
        return variableInstance;
    }
}

