/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.mapper;

import io.flowset.control.entity.activity.ActivityInstanceTreeItem;
import io.flowset.control.entity.activity.ActivityShortData;
import io.flowset.control.entity.activity.ProcessActivityStatistics;
import io.flowset.control.entity.dashboard.IncidentStatistics;
import io.jmix.core.Metadata;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Date;
import org.camunda.community.rest.client.model.ActivityInstanceDto;
import org.camunda.community.rest.client.model.ActivityStatisticsResultDto;
import org.camunda.community.rest.client.model.HistoricActivityInstanceDto;
import org.camunda.community.rest.client.model.IncidentStatisticsResultDto;
import org.camunda.community.rest.client.model.TransitionInstanceDto;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring")
public abstract class ActivityMapper {
    @Autowired
    Metadata metadata;

    @Mappings(value={@Mapping(target="internalId", source="id"), @Mapping(target="id", ignore=true)})
    public abstract ActivityShortData fromActivityDto(HistoricActivityInstanceDto var1);

    @Mappings(value={@Mapping(target="activityInstanceId", source="id"), @Mapping(target="id", ignore=true), @Mapping(target="parentActivityInstance", ignore=true), @Mapping(target="transition", constant="false")})
    public abstract ActivityInstanceTreeItem fromRuntimeActivityDto(ActivityInstanceDto var1);

    ActivityInstanceTreeItem targetTreeItemClassFactory() {
        return (ActivityInstanceTreeItem)this.metadata.create(ActivityInstanceTreeItem.class);
    }

    @Mappings(value={@Mapping(target="activityInstanceId", source="id"), @Mapping(target="id", ignore=true), @Mapping(target="parentActivityInstance", ignore=true), @Mapping(target="transition", constant="true")})
    public abstract ActivityInstanceTreeItem fromRuntimeTransitionDto(TransitionInstanceDto var1);

    ActivityShortData targetClassFactory() {
        return (ActivityShortData)this.metadata.create(ActivityShortData.class);
    }

    Date map(OffsetDateTime value) {
        if (value == null) {
            return null;
        }
        Instant instant = value.toInstant();
        return Date.from(instant);
    }

    @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="instanceCount", source="instances"), @Mapping(target="failedJobCount", source="failedJobs"), @Mapping(target="activityId", source="id")})
    public abstract ProcessActivityStatistics fromActivityStatisticsResult(ActivityStatisticsResultDto var1);

    ProcessActivityStatistics activityStatisticsClassFactory() {
        return (ProcessActivityStatistics)this.metadata.create(ProcessActivityStatistics.class);
    }

    @Mapping(target="id", ignore=true)
    public abstract IncidentStatistics fromStatisticsResultDto(IncidentStatisticsResultDto var1);

    IncidentStatistics incidentStatisticsClassFactory() {
        return (IncidentStatistics)this.metadata.create(IncidentStatistics.class);
    }
}

