/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.user;

import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.router.Route;
import io.flowset.control.entity.User;
import io.flowset.control.view.main.MainView;
import io.jmix.core.EntityStates;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.view.EditedEntityContainer;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardDetailView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;

@Route(value="users/:id", layout=MainView.class)
@ViewController(value="User.detail")
@ViewDescriptor(value="user-detail-view.xml")
@EditedEntityContainer(value="userDc")
public class UserDetailView
extends StandardDetailView<User> {
    @ViewComponent
    protected TypedTextField<String> usernameField;
    @ViewComponent
    protected PasswordField passwordField;
    @ViewComponent
    protected PasswordField confirmPasswordField;
    @ViewComponent
    protected ComboBox<String> timeZoneField;
    @Autowired
    protected EntityStates entityStates;
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected PasswordEncoder passwordEncoder;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.timeZoneField.setItems(List.of(TimeZone.getAvailableIDs()));
    }

    @Subscribe
    public void onInitEntity(StandardDetailView.InitEntityEvent<User> event) {
        this.usernameField.setReadOnly(false);
        this.passwordField.setVisible(true);
        this.confirmPasswordField.setVisible(true);
    }

    @Subscribe
    public void onReady(View.ReadyEvent event) {
        if (this.entityStates.isNew(this.getEditedEntity())) {
            this.usernameField.focus();
        }
    }

    @Subscribe
    public void onValidation(StandardDetailView.ValidationEvent event) {
        if (this.entityStates.isNew(this.getEditedEntity()) && !Objects.equals(this.passwordField.getValue(), this.confirmPasswordField.getValue())) {
            event.getErrors().add(this.messageBundle.getMessage("passwordsDoNotMatch"));
        }
    }

    @Subscribe
    protected void onBeforeSave(StandardDetailView.BeforeSaveEvent event) {
        if (this.entityStates.isNew(this.getEditedEntity())) {
            ((User)this.getEditedEntity()).setPassword(this.passwordEncoder.encode((CharSequence)this.passwordField.getValue()));
        }
    }
}

