/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processinstancemigration;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.Route;
import io.flowset.control.entity.processdefinition.ProcessDefinitionData;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.service.processdefinition.ProcessDefinitionService;
import io.flowset.control.service.processinstance.MigrationService;
import io.flowset.control.service.processinstance.ProcessInstanceService;
import io.jmix.flowui.Dialogs;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpm/processinstancemigration", layout=DefaultMainViewParent.class)
@ViewController(value="bpm_ProcessInstanceMigration")
@ViewDescriptor(value="process-instance-migration-view.xml")
public class ProcessInstanceMigrationView
extends StandardView {
    public static final String ID = "bpm_ProcessInstanceMigration";
    @Autowired
    protected ProcessDefinitionService processDefinitionService;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    protected MigrationService migrationService;
    @Autowired
    protected Dialogs dialogs;
    @ViewComponent
    protected MessageBundle messageBundle;
    @ViewComponent
    protected ComboBox<ProcessDefinitionData> processDefinitionVersionComboBox;
    @ViewComponent
    protected ComboBox<String> processDefinitionKeyComboBox;
    @ViewComponent
    protected HorizontalLayout rootHBox;
    @ViewComponent
    protected Icon arrowIcon;
    @ViewComponent
    protected TypedTextField<Object> sourceDefinitionKeyField;
    @ViewComponent
    protected TypedTextField<Integer> sourceDefinitionVersionField;
    @ViewComponent
    private JmixButton migrateBtn;
    @ViewComponent
    private HorizontalLayout migrationWarningPanel;
    protected ProcessInstanceData processInstanceData;
    protected ProcessDefinitionData processDefinitionData;

    public void setProcessDefinitionData(ProcessDefinitionData processDefinitionData) {
        this.processDefinitionData = processDefinitionData;
    }

    public void setProcessInstanceData(ProcessInstanceData processInstanceData) {
        this.processInstanceData = processInstanceData;
    }

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-0", "pl-l", "pr-l", "pb-m"});
        this.arrowIcon.addClassNames(new String[]{"text-secondary"});
        this.rootHBox.getChildren().filter(component -> component instanceof VerticalLayout).forEach(component -> component.addClassNames(new String[]{"border", "rounded-l", "border-contrast-30"}));
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        this.sourceDefinitionKeyField.setValue(this.processDefinitionData.getKey());
        this.sourceDefinitionVersionField.setTypedValue((Object)this.processDefinitionData.getVersion());
        List<String> processDefinitionKeys = this.processDefinitionService.findLatestVersions().stream().map(ProcessDefinitionData::getKey).toList();
        this.processDefinitionKeyComboBox.setItems(processDefinitionKeys);
        this.processDefinitionKeyComboBox.setValue((Object)this.processDefinitionData.getKey());
        if (this.processInstanceData != null) {
            return;
        }
        long runningInstancesCount = this.processInstanceService.getCountByProcessDefinitionId(this.processDefinitionData.getProcessDefinitionId());
        if (runningInstancesCount == 0L) {
            this.migrateBtn.setEnabled(false);
            this.migrationWarningPanel.setVisible(true);
        }
    }

    @Subscribe(value="processDefinitionKeyComboBox")
    public void onProcessDefinitionKeyComboBoxValueChange(AbstractField.ComponentValueChangeEvent<ComboBox<String>, String> event) {
        String processDefinitionKey = (String)event.getValue();
        List definitions = this.processDefinitionService.findAllByKey(processDefinitionKey);
        this.processDefinitionVersionComboBox.setItems((Collection)definitions);
        this.processDefinitionVersionComboBox.setItemLabelGenerator((ItemLabelGenerator & Serializable)item -> {
            Integer version = item.getVersion();
            return version != null ? String.valueOf(version) : null;
        });
        if (!definitions.isEmpty()) {
            this.processDefinitionVersionComboBox.setValue((Object)((ProcessDefinitionData)definitions.get(0)));
        }
    }

    @Subscribe(value="migrateBtn")
    public void onMigrateBtnClick(ClickEvent<Button> event) {
        if (this.processInstanceData != null) {
            this.migrateSingleProcessInstance();
        } else {
            this.migrateAllProcessInstances();
        }
    }

    @Subscribe(value="cancelBtn")
    public void onCancelBtnClick(ClickEvent<Button> event) {
        this.close(StandardOutcome.DISCARD);
    }

    protected void migrateSingleProcessInstance() {
        ProcessDefinitionData dstProcessDefinition = (ProcessDefinitionData)this.processDefinitionVersionComboBox.getValue();
        String destinationProcessDefinitionId = dstProcessDefinition.getId();
        String processInstanceId = this.processInstanceData.getId();
        List validationMessages = this.migrationService.validateMigrationOfSingleProcessInstance(processInstanceId, destinationProcessDefinitionId);
        if (validationMessages.isEmpty()) {
            this.migrationService.migrateSingleProcessInstance(processInstanceId, destinationProcessDefinitionId);
            this.close(StandardOutcome.SAVE);
        } else {
            this.displayValidationError(validationMessages);
        }
    }

    protected void migrateAllProcessInstances() {
        ProcessDefinitionData dstProcessDefinition = (ProcessDefinitionData)this.processDefinitionVersionComboBox.getValue();
        String dstProcessDefinitionId = dstProcessDefinition.getId();
        String srcProcessDefinitionId = this.processDefinitionData.getId();
        List validationMessages = this.migrationService.validateMigrationOfProcessInstances(srcProcessDefinitionId, dstProcessDefinitionId);
        if (validationMessages.isEmpty()) {
            this.migrationService.migrateAllProcessInstances(srcProcessDefinitionId, dstProcessDefinitionId);
            this.close(StandardOutcome.SAVE);
        } else {
            this.displayValidationError(validationMessages);
        }
    }

    protected void displayValidationError(List<String> validationMessages) {
        String combinedErrorMsg = String.join((CharSequence)"\n", validationMessages);
        ((Dialogs.MessageDialogBuilder)((Dialogs.MessageDialogBuilder)((Dialogs.MessageDialogBuilder)this.dialogs.createMessageDialog().withHeader(this.messageBundle.getMessage("processInstanceMigrationView.migrationValidationError"))).withText(combinedErrorMsg)).withHeight("12.5em")).open();
    }
}

