/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processinstance.runtime;

import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.event.SortEvent;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import io.flowset.control.entity.filter.IncidentFilter;
import io.flowset.control.entity.incident.IncidentData;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.service.incident.IncidentLoadContext;
import io.flowset.control.service.incident.IncidentService;
import io.flowset.control.view.incidentdata.RetryExternalTaskView;
import io.flowset.control.view.incidentdata.RetryJobView;
import io.flowset.control.view.processinstance.event.IncidentCountUpdateEvent;
import io.flowset.control.view.processinstance.event.IncidentUpdateEvent;
import io.flowset.control.view.util.ComponentHelper;
import io.jmix.core.DataLoadContext;
import io.jmix.core.LoadContext;
import io.jmix.core.Messages;
import io.jmix.core.Metadata;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.Dialogs;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.UiEventPublisher;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.DialogWindow;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Supply;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.ViewComponent;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;

@FragmentDescriptor(value="runtime-incident-tab-fragment.xml")
public class RuntimeIncidentsTabFragment
extends Fragment<VerticalLayout> {
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected UiEventPublisher uiEventPublisher;
    @Autowired
    protected DialogWindows dialogWindows;
    @Autowired
    protected ViewNavigators viewNavigators;
    @Autowired
    protected Dialogs dialogs;
    @Autowired
    protected Messages messages;
    @Autowired
    protected Notifications notifications;
    @Autowired
    protected ComponentHelper componentHelper;
    @Autowired
    protected IncidentService incidentService;
    @ViewComponent
    protected CollectionLoader<IncidentData> runtimeIncidentsDl;
    @ViewComponent
    protected InstanceContainer<ProcessInstanceData> processInstanceDataDc;
    @ViewComponent
    protected DataGrid<IncidentData> runtimeIncidentsGrid;
    protected IncidentFilter filter;
    protected String selectedActivityId;
    protected boolean initialized = false;

    public void setSelectedActivityId(String selectedActivityId) {
        this.selectedActivityId = selectedActivityId;
    }

    public void refreshIfChanged(String selectedActivityId) {
        if (!this.initialized) {
            this.filter = (IncidentFilter)this.metadata.create(IncidentFilter.class);
            this.filter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getId());
            this.runtimeIncidentsDl.load();
            this.initialized = true;
            return;
        }
        if (!StringUtils.equals((CharSequence)this.selectedActivityId, (CharSequence)selectedActivityId)) {
            this.selectedActivityId = selectedActivityId;
            this.filter.setActivityId(selectedActivityId);
            this.runtimeIncidentsDl.load();
        }
    }

    @Subscribe(value="runtimeIncidentsGrid.view")
    public void onViewAction(ActionPerformedEvent event) {
        IncidentData incidentData = (IncidentData)this.runtimeIncidentsGrid.getSingleSelectedItem();
        if (incidentData == null) {
            return;
        }
        this.dialogWindows.detail(UiComponentUtils.getCurrentView(), IncidentData.class).editEntity((Object)incidentData).withAfterCloseListener(closeEvent -> {
            if (closeEvent.closedWith(StandardOutcome.SAVE)) {
                this.reloadIncidents();
            }
        }).build().open();
    }

    @Install(to="runtimeIncidentsGrid.retry", subject="enabledRule")
    protected boolean runtimeIncidentsGridRetryEnabledRule() {
        IncidentData selectedItem = (IncidentData)this.runtimeIncidentsGrid.getSingleSelectedItem();
        return selectedItem != null && selectedItem.getConfiguration() != null && (selectedItem.isJobFailed() || selectedItem.isExternalTaskFailed());
    }

    @Subscribe(value="runtimeIncidentsGrid.retry")
    public void onRetryAction(ActionPerformedEvent event) {
        IncidentData incident = (IncidentData)this.runtimeIncidentsGrid.getSingleSelectedItem();
        if (incident == null || incident.getConfiguration() == null) {
            return;
        }
        if (incident.isExternalTaskFailed()) {
            DialogWindow dialogWindow = this.dialogWindows.view(UiComponentUtils.getCurrentView(), RetryExternalTaskView.class).withAfterCloseListener(afterClose -> {
                if (afterClose.closedWith(StandardOutcome.SAVE)) {
                    this.reloadIncidents();
                }
            }).build();
            RetryExternalTaskView retryExternalTaskView = (RetryExternalTaskView)dialogWindow.getView();
            retryExternalTaskView.setExternalTaskId(incident.getConfiguration());
            dialogWindow.open();
        } else if (incident.isJobFailed()) {
            DialogWindow dialogWindow = this.dialogWindows.view(UiComponentUtils.getCurrentView(), RetryJobView.class).withAfterCloseListener(afterClose -> {
                if (afterClose.closedWith(StandardOutcome.SAVE)) {
                    this.reloadIncidents();
                }
            }).build();
            RetryJobView retryJobView = (RetryJobView)dialogWindow.getView();
            retryJobView.setJobId(incident.getConfiguration());
            dialogWindow.open();
        }
    }

    @Install(to="runtimeIncidentsGrid.timestamp", subject="partNameGenerator")
    protected String runtimeIncidentsGridTimestampPartNameGenerator(IncidentData incidentData) {
        return "multiline-text-cell";
    }

    @Supply(to="runtimeIncidentsGrid.timestamp", subject="renderer")
    protected Renderer<IncidentData> runtimeIncidentsGridTimestampRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)incidentData -> {
            Span span = this.componentHelper.createDateSpan(incidentData.getTimestamp());
            span.addClassNames(new String[]{"overflow-hidden", "overflow-ellipsis"});
            return span;
        });
    }

    @Install(to="runtimeIncidentsDl", target=Target.DATA_LOADER)
    protected List<IncidentData> runtimeIncidentsDlLoadDelegate(LoadContext<IncidentData> loadContext) {
        LoadContext.Query query = loadContext.getQuery();
        IncidentLoadContext context = new IncidentLoadContext().setFilter(this.filter);
        if (query != null) {
            context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        return this.incidentService.findRuntimeIncidents(context);
    }

    @Install(to="incidentsPagination", subject="totalCountDelegate")
    protected Integer incidentsPaginationTotalCountDelegate(DataLoadContext dataLoadContext) {
        long incidentCount = this.incidentService.getRuntimeIncidentCount(this.filter);
        this.uiEventPublisher.publishEventForCurrentUI((ApplicationEvent)new IncidentCountUpdateEvent((Object)this, incidentCount));
        return (int)incidentCount;
    }

    @Subscribe(value="runtimeIncidentsGrid")
    public void onRuntimeIncidentsGridGridSort(SortEvent<DataGrid<IncidentData>, GridSortOrder<DataGrid<IncidentData>>> event) {
        this.runtimeIncidentsDl.load();
    }

    protected void reloadIncidents() {
        this.runtimeIncidentsDl.load();
        this.uiEventPublisher.publishEventForCurrentUI((ApplicationEvent)new IncidentUpdateEvent((Object)this));
    }
}

