/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processinstance.history;

import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.event.SortEvent;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import io.flowset.control.entity.filter.VariableFilter;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.entity.variable.HistoricVariableInstanceData;
import io.flowset.control.service.variable.VariableLoadContext;
import io.flowset.control.service.variable.VariableService;
import io.flowset.control.view.processinstance.event.HistoryVariableCountUpdateEvent;
import io.flowset.control.view.processinstance.history.HasRefresh;
import io.jmix.core.DataLoadContext;
import io.jmix.core.LoadContext;
import io.jmix.core.Metadata;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.UiEventPublisher;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Supply;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.ViewComponent;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.lang.Nullable;

@FragmentDescriptor(value="history-variables-tab-fragment.xml")
public class HistoryVariablesTabFragment
extends Fragment<VerticalLayout>
implements HasRefresh {
    @Autowired
    protected VariableService variableService;
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected UiEventPublisher uiEventPublisher;
    @Autowired
    protected DialogWindows dialogWindows;
    @Autowired
    protected ViewNavigators viewNavigators;
    @ViewComponent
    protected CollectionLoader<HistoricVariableInstanceData> historicVariableInstancesDl;
    @ViewComponent
    protected DataGrid<HistoricVariableInstanceData> historicVariableInstancesGrid;
    @ViewComponent
    protected InstanceContainer<ProcessInstanceData> processInstanceDataDc;
    protected VariableFilter filter;
    protected boolean initialized;

    public void refreshIfRequired() {
        if (!this.initialized) {
            this.filter = (VariableFilter)this.metadata.create(VariableFilter.class);
            this.filter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getId());
            this.historicVariableInstancesDl.load();
            this.initialized = true;
        }
    }

    @Supply(to="historicVariableInstancesGrid.value", subject="renderer")
    protected Renderer<HistoricVariableInstanceData> historicVariableInstancesGridValueRenderer() {
        return new TextRenderer(arg_0 -> this.getVariableValueColumnText(arg_0));
    }

    @Install(to="historicVariableInstancesGrid.value", subject="tooltipGenerator")
    protected String historicVariableInstancesGridTooltipGenerator(HistoricVariableInstanceData variableInstanceData) {
        return this.getVariableValueColumnText(variableInstanceData);
    }

    @Subscribe(value="historicVariableInstancesGrid.view")
    public void onViewAction(ActionPerformedEvent event) {
        HistoricVariableInstanceData variableInstance = (HistoricVariableInstanceData)this.historicVariableInstancesGrid.getSingleSelectedItem();
        if (variableInstance == null) {
            return;
        }
        this.dialogWindows.detail(UiComponentUtils.getCurrentView(), HistoricVariableInstanceData.class).editEntity((Object)variableInstance).build().open();
    }

    @Install(to="historicVariableInstancesDl", target=Target.DATA_LOADER)
    protected List<HistoricVariableInstanceData> historicVariableInstancesDlLoadDelegate(LoadContext<HistoricVariableInstanceData> loadContext) {
        LoadContext.Query query = loadContext.getQuery();
        VariableLoadContext context = new VariableLoadContext().setFilter(this.filter);
        if (query != null) {
            context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        return this.variableService.findHistoricVariables(context);
    }

    @Install(to="historicVariableInstancesPagination", subject="totalCountDelegate")
    protected Integer historicVariableInstancesPaginationTotalCountDelegate(DataLoadContext dataLoadContext) {
        long historicVariableInstancesCount = this.variableService.getHistoricVariablesCount(this.filter);
        this.uiEventPublisher.publishEventForCurrentUI((ApplicationEvent)new HistoryVariableCountUpdateEvent((Object)this, historicVariableInstancesCount));
        return (int)historicVariableInstancesCount;
    }

    @Subscribe(value="historicVariableInstancesGrid")
    public void onHistoricVariableInstancesGridGridSort(SortEvent<DataGrid<HistoricVariableInstanceData>, GridSortOrder<DataGrid<HistoricVariableInstanceData>>> event) {
        this.historicVariableInstancesDl.load();
    }

    @Nullable
    protected String getVariableValueColumnText(HistoricVariableInstanceData variableInstance) {
        if (variableInstance.getValue() != null) {
            return variableInstance.getValue().toString();
        }
        return null;
    }
}

