/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processinstance.history;

import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.event.SortEvent;
import io.flowset.control.entity.UserTaskData;
import io.flowset.control.entity.filter.UserTaskFilter;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.service.usertask.UserTaskLoadContext;
import io.flowset.control.service.usertask.UserTaskService;
import io.flowset.control.view.processinstance.event.HistoryUserTaskCountUpdateEvent;
import io.flowset.control.view.processinstance.history.HasRefresh;
import io.jmix.core.DataLoadContext;
import io.jmix.core.LoadContext;
import io.jmix.core.Metadata;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.UiEventPublisher;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.model.CollectionContainer;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.ViewComponent;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;

@FragmentDescriptor(value="history-user-tasks-tab-fragment.xml")
public class HistoryUserTasksTabFragment
extends Fragment<VerticalLayout>
implements HasRefresh {
    @Autowired
    protected UserTaskService userTaskService;
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected UiEventPublisher uiEventPublisher;
    @Autowired
    protected DialogWindows dialogWindows;
    @Autowired
    protected ViewNavigators viewNavigators;
    @ViewComponent
    protected CollectionLoader<UserTaskData> historyTasksDl;
    @ViewComponent
    protected CollectionContainer<UserTaskData> historyTasksDc;
    @ViewComponent
    protected DataGrid<UserTaskData> historyTasksGrid;
    @ViewComponent
    protected InstanceContainer<ProcessInstanceData> processInstanceDataDc;
    protected UserTaskFilter filter;
    protected boolean initialized;

    public void refreshIfRequired() {
        if (!this.initialized) {
            this.filter = (UserTaskFilter)this.metadata.create(UserTaskFilter.class);
            this.filter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getId());
            this.historyTasksDl.load();
            this.initialized = true;
        }
    }

    @Subscribe(value="historyTasksGrid.view")
    public void onViewAction(ActionPerformedEvent event) {
        UserTaskData userTaskData = (UserTaskData)this.historyTasksGrid.getSingleSelectedItem();
        if (userTaskData == null) {
            return;
        }
        this.dialogWindows.detail(UiComponentUtils.getCurrentView(), UserTaskData.class).editEntity((Object)userTaskData).build().open();
    }

    @Install(to="historyTasksDl", target=Target.DATA_LOADER)
    protected List<UserTaskData> historyTasksDlLoadDelegate(LoadContext<UserTaskData> loadContext) {
        LoadContext.Query query = loadContext.getQuery();
        UserTaskLoadContext context = new UserTaskLoadContext().setFilter(this.filter);
        if (query != null) {
            context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        return this.userTaskService.findHistoricTasks(context);
    }

    @Install(to="userTasksPagination", subject="totalCountDelegate")
    protected Integer userTasksPaginationTotalCountDelegate(DataLoadContext dataLoadContext) {
        long historyTasksCount = this.userTaskService.getHistoryTasksCount(this.filter);
        this.uiEventPublisher.publishEventForCurrentUI((ApplicationEvent)new HistoryUserTaskCountUpdateEvent((Object)this, historyTasksCount));
        return (int)historyTasksCount;
    }

    @Subscribe(value="historyTasksGrid")
    public void onHistoryTasksGridGridSort(SortEvent<DataGrid<UserTaskData>, GridSortOrder<DataGrid<UserTaskData>>> event) {
        this.historyTasksDl.load();
    }
}

