/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processinstance.history;

import com.vaadin.flow.component.grid.GridSortOrder;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.event.SortEvent;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import io.flowset.control.entity.filter.IncidentFilter;
import io.flowset.control.entity.incident.HistoricIncidentData;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.service.incident.IncidentLoadContext;
import io.flowset.control.service.incident.IncidentService;
import io.flowset.control.view.processinstance.event.HistoryUserTaskCountUpdateEvent;
import io.flowset.control.view.processinstance.event.IncidentUpdateEvent;
import io.flowset.control.view.processinstance.event.JobRetriesUpdateEvent;
import io.flowset.control.view.processinstance.history.HasRefresh;
import io.flowset.control.view.util.ComponentHelper;
import io.jmix.core.DataLoadContext;
import io.jmix.core.LoadContext;
import io.jmix.core.Metadata;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.UiEventPublisher;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.model.CollectionLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Supply;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.ViewComponent;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.EventListener;

@FragmentDescriptor(value="history-incidents-tab-fragment.xml")
public class HistoryIncidentsTabFragment
extends Fragment<VerticalLayout>
implements HasRefresh {
    @Autowired
    protected IncidentService userTaskService;
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected UiEventPublisher uiEventPublisher;
    @Autowired
    protected DialogWindows dialogWindows;
    @Autowired
    protected ViewNavigators viewNavigators;
    @ViewComponent
    protected InstanceContainer<ProcessInstanceData> processInstanceDataDc;
    @ViewComponent
    protected CollectionLoader<HistoricIncidentData> incidentsDl;
    @ViewComponent
    protected DataGrid<HistoricIncidentData> incidentsGrid;
    @Autowired
    protected ComponentHelper componentHelper;
    protected IncidentFilter filter;
    protected boolean initialized;

    public void refreshIfRequired() {
        if (!this.initialized) {
            this.filter = (IncidentFilter)this.metadata.create(IncidentFilter.class);
            this.filter.setProcessInstanceId(((ProcessInstanceData)this.processInstanceDataDc.getItem()).getId());
            this.incidentsDl.load();
            this.initialized = true;
        }
    }

    @Subscribe(value="incidentsGrid.view")
    public void onViewAction(ActionPerformedEvent event) {
        HistoricIncidentData incident = (HistoricIncidentData)this.incidentsGrid.getSingleSelectedItem();
        if (incident == null) {
            return;
        }
        this.dialogWindows.detail(UiComponentUtils.getCurrentView(), HistoricIncidentData.class).editEntity((Object)incident).build().open();
    }

    @Install(to="incidentsDl", target=Target.DATA_LOADER)
    protected List<HistoricIncidentData> incidentsDlLoadDelegate(LoadContext<HistoricIncidentData> loadContext) {
        LoadContext.Query query = loadContext.getQuery();
        IncidentLoadContext context = new IncidentLoadContext().setFilter(this.filter);
        if (query != null) {
            context.setFirstResult(Integer.valueOf(query.getFirstResult())).setMaxResults(Integer.valueOf(query.getMaxResults())).setSort(query.getSort());
        }
        return this.userTaskService.findHistoricIncidents(context);
    }

    @Install(to="incidentsPagination", subject="totalCountDelegate")
    protected Integer incidentsPaginationTotalCountDelegate(DataLoadContext dataLoadContext) {
        long incidentsCount = this.userTaskService.getHistoricIncidentCount(this.filter);
        this.uiEventPublisher.publishEventForCurrentUI((ApplicationEvent)new HistoryUserTaskCountUpdateEvent((Object)this, incidentsCount));
        return (int)incidentsCount;
    }

    @Subscribe(value="incidentsGrid")
    public void onHistoryTasksGridGridSort(SortEvent<DataGrid<HistoricIncidentData>, GridSortOrder<DataGrid<HistoricIncidentData>>> event) {
        this.incidentsDl.load();
    }

    @Supply(to="incidentsGrid.resolved", subject="renderer")
    protected Renderer<HistoricIncidentData> incidentsGridResolvedRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)historicIncidentData -> {
            Icon icon = BooleanUtils.isTrue((Boolean)historicIncidentData.getResolved()) ? VaadinIcon.CHECK.create() : VaadinIcon.CLOSE.create();
            icon.setSize("0.85em");
            return icon;
        });
    }

    @EventListener
    public void handleIncidentUpdate(IncidentUpdateEvent event) {
        this.initialized = false;
    }

    @EventListener
    public void handleIncidentUpdate(JobRetriesUpdateEvent event) {
        this.initialized = false;
    }

    @Install(to="incidentsGrid.createTime", subject="partNameGenerator")
    protected String incidentsGridCreateTimePartNameGenerator(HistoricIncidentData historicIncidentData) {
        return "multiline-text-cell";
    }

    @Supply(to="incidentsGrid.createTime", subject="renderer")
    protected Renderer<HistoricIncidentData> incidentsGridCreateTimeRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)incidentData -> {
            Span dateSpan = this.componentHelper.createDateSpan(incidentData.getCreateTime());
            dateSpan.addClassNames(new String[]{"overflow-hidden", "overflow-ellipsis"});
            return dateSpan;
        });
    }

    @Install(to="incidentsGrid.endTime", subject="partNameGenerator")
    protected String incidentsGridEndTimePartNameGenerator(HistoricIncidentData historicIncidentData) {
        return "multiline-text-cell";
    }

    @Supply(to="incidentsGrid.endTime", subject="renderer")
    protected Renderer<HistoricIncidentData> incidentsGridEndTimeRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)incidentData -> {
            Span dateSpan = this.componentHelper.createDateSpan(incidentData.getEndTime());
            dateSpan.addClassNames(new String[]{"overflow-hidden", "overflow-ellipsis"});
            return dateSpan;
        });
    }
}

