/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processinstance.filter;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import io.flowset.control.entity.filter.ProcessInstanceFilter;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.view.processinstance.filter.ProcessInstanceDataGridHeaderFilter;
import io.jmix.flowui.component.datetimepicker.TypedDateTimePicker;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.component.grid.DataGridColumn;
import io.jmix.flowui.model.InstanceContainer;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class EndTimeHeaderFilter
extends ProcessInstanceDataGridHeaderFilter {
    protected TypedDateTimePicker<LocalDateTime> endTimeBefore;
    protected TypedDateTimePicker<LocalDateTime> endTimeAfter;

    public EndTimeHeaderFilter(DataGrid<ProcessInstanceData> dataGrid, DataGridColumn<ProcessInstanceData> column, InstanceContainer<ProcessInstanceFilter> filterDc) {
        super(dataGrid, column, filterDc);
    }

    protected Component createFilterComponent() {
        Component endTimeAfterFilter = this.createEndTimeAfterFilter();
        Component endTimeBeforeFilter = this.createEndTimeBeforeFilter();
        VerticalLayout rootLayout = (VerticalLayout)this.uiComponents.create(VerticalLayout.class);
        rootLayout.setPadding(false);
        rootLayout.setSpacing(false);
        rootLayout.add(new Component[]{endTimeAfterFilter, endTimeBeforeFilter});
        return rootLayout;
    }

    protected void resetFilterValues() {
        this.endTimeBefore.clear();
        this.endTimeAfter.clear();
    }

    public void apply() {
        LocalDateTime endTimeBefore = (LocalDateTime)this.endTimeBefore.getValue();
        if (endTimeBefore != null) {
            ZoneId zoneId = this.endTimeBefore.getZoneId();
            ZoneId zone = zoneId != null ? zoneId : ZoneId.systemDefault();
            ((ProcessInstanceFilter)this.filterDc.getItem()).setEndTimeBefore(endTimeBefore.atZone(zone).toOffsetDateTime());
        } else {
            ((ProcessInstanceFilter)this.filterDc.getItem()).setEndTimeBefore(null);
        }
        LocalDateTime endTimeAfter = (LocalDateTime)this.endTimeAfter.getValue();
        if (endTimeAfter != null) {
            ZoneId zoneId = this.endTimeAfter.getZoneId();
            ZoneId zone = zoneId != null ? zoneId : ZoneId.systemDefault();
            ((ProcessInstanceFilter)this.filterDc.getItem()).setEndTimeAfter(endTimeAfter.atZone(zone).toOffsetDateTime());
        } else {
            ((ProcessInstanceFilter)this.filterDc.getItem()).setEndTimeAfter(null);
        }
        this.filterButton.getElement().setAttribute("activated", endTimeAfter != null || endTimeBefore != null);
    }

    protected Component createEndTimeBeforeFilter() {
        this.endTimeBefore = (TypedDateTimePicker)this.uiComponents.create(TypedDateTimePicker.class);
        this.endTimeBefore.setMax(LocalDateTime.now());
        this.endTimeBefore.setDatePlaceholder(this.messages.getMessage(this.getClass(), "selectDate"));
        this.endTimeBefore.setTimePlaceholder(this.messages.getMessage(this.getClass(), "selectTime"));
        this.endTimeBefore.setLabel(this.messages.getMessage(ProcessInstanceFilter.class, "ProcessInstanceFilter.endTimeBefore"));
        return this.endTimeBefore;
    }

    protected Component createEndTimeAfterFilter() {
        this.endTimeAfter = (TypedDateTimePicker)this.uiComponents.create(TypedDateTimePicker.class);
        this.endTimeAfter.setMax(LocalDateTime.now());
        this.endTimeAfter.setDatePlaceholder(this.messages.getMessage(this.getClass(), "selectDate"));
        this.endTimeAfter.setTimePlaceholder(this.messages.getMessage(this.getClass(), "selectTime"));
        this.endTimeAfter.setLabel(this.messages.getMessage(ProcessInstanceFilter.class, "ProcessInstanceFilter.endTimeAfter"));
        this.setDefaultTime(this.endTimeAfter);
        return this.endTimeAfter;
    }

    private void setDefaultTime(TypedDateTimePicker<LocalDateTime> dateTimePicker) {
        dateTimePicker.getElement().executeJs("this.__datePicker.addEventListener('change', function(){this.__timePicker.value='00:00';}.bind(this));", new Serializable[0]);
    }
}

