/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processinstance;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.router.Route;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.entity.processinstance.RuntimeProcessInstanceData;
import io.flowset.control.service.processinstance.ProcessInstanceService;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpm/bulkterminateprocessinstance", layout=DefaultMainViewParent.class)
@ViewController(value="bpm_BulkTerminateProcessInstance")
@ViewDescriptor(value="bulk-terminate-process-instance-view.xml")
@DialogMode(width="35em")
public class BulkTerminateProcessInstanceView
extends StandardView {
    public static final int REASON_MAX_LENGTH = 4000;
    @Autowired
    protected Notifications notifications;
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected ProcessInstanceService processInstanceService;
    @ViewComponent
    protected TextArea reasonTextArea;
    protected Collection<ProcessInstanceData> processInstances;

    public void setProcessInstances(Collection<ProcessInstanceData> processInstances) {
        this.processInstances = processInstances;
    }

    @Subscribe
    protected void onBeforeShow(View.BeforeShowEvent event) {
        this.addClassNames(new String[]{"gap-xs"});
        this.reasonTextArea.getStyle().set("resize", "vertical");
        this.reasonTextArea.getStyle().set("overflow", "auto");
        this.reasonTextArea.setMaxLength(4000);
    }

    @Subscribe(value="okBtn")
    protected void onOkBtnClick(ClickEvent<Button> event) {
        List<String> ids = this.processInstances.stream().map(RuntimeProcessInstanceData::getInstanceId).toList();
        this.processInstanceService.terminateByIdsAsync(ids, this.reasonTextArea.getValue());
        this.notifications.create(this.messageBundle.getMessage("bulkTerminateProcessesStarted")).withThemeVariant(NotificationVariant.LUMO_PRIMARY).show();
        this.close(StandardOutcome.SAVE);
    }

    @Subscribe(value="cancelBtn")
    protected void onCancelBtnClick(ClickEvent<Button> event) {
        this.close(StandardOutcome.DISCARD);
    }
}

