/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processinstance;

import com.vaadin.flow.router.Route;
import io.flowset.control.service.processinstance.ProcessInstanceService;
import io.flowset.control.view.main.MainView;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bulk-suspend-process-instance-view", layout=MainView.class)
@ViewController(id="BulkSuspendProcessInstanceView")
@ViewDescriptor(path="bulk-suspend-process-instance-view.xml")
public class BulkSuspendProcessInstanceView
extends StandardView {
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private Notifications notifications;
    @ViewComponent
    private MessageBundle messageBundle;
    protected List<String> instancesIds;

    public void setInstancesIds(List<String> instancesIds) {
        this.instancesIds = instancesIds;
    }

    @Subscribe(value="suspendAction")
    public void onSuspendAction(ActionPerformedEvent event) {
        this.processInstanceService.suspendByIdsAsync(this.instancesIds);
        this.notifications.create(this.messageBundle.getMessage("bulkSuspendProcessInstancesStarted")).withType(Notifications.Type.SUCCESS).show();
        this.close(StandardOutcome.SAVE);
    }

    @Subscribe(value="cancelAction")
    public void onCancelAction(ActionPerformedEvent event) {
        this.close(StandardOutcome.CLOSE);
    }
}

