/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processdefinition;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.router.Route;
import io.flowset.control.service.processdefinition.ProcessDefinitionService;
import io.jmix.core.Messages;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.StandardView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpm/suspendprocessdefinition", layout=DefaultMainViewParent.class)
@ViewController(value="bpm_SuspendProcessDefinition")
@ViewDescriptor(value="suspend-process-definition-view.xml")
@DialogMode(width="35em")
public class SuspendProcessDefinitionView
extends StandardView {
    @Autowired
    protected Notifications notifications;
    @Autowired
    protected Messages messages;
    @Autowired
    protected ProcessDefinitionService processDefinitionService;
    @ViewComponent
    protected Checkbox suspendProcessInstancesCheckBox;
    @ViewComponent
    protected Icon allInstancesContextHelp;
    protected String processDefinitionId;

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.allInstancesContextHelp.addClassNames(new String[]{"text-secondary"});
    }

    @Subscribe
    protected void onBeforeShow(View.BeforeShowEvent event) {
        this.suspendProcessInstancesCheckBox.setValue((Object)true);
    }

    @Subscribe(value="suspendBtn")
    protected void onSuspendBtnClick(ClickEvent<Button> event) {
        this.processDefinitionService.suspendById(this.processDefinitionId, Boolean.TRUE.equals(this.suspendProcessInstancesCheckBox.getValue()));
        this.notifications.create(this.messages.getMessage(this.getClass(), "suspendSuccessNotification.headed")).withType(Notifications.Type.SUCCESS).build().open();
        this.close(StandardOutcome.SAVE);
    }

    @Subscribe(value="cancelBtn")
    protected void onCancelBtnClick(ClickEvent<Button> event) {
        this.close(StandardOutcome.DISCARD);
    }
}

