/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processdefinition;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.shared.Tooltip;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.RouteParameters;
import io.flowset.control.entity.filter.ProcessInstanceFilter;
import io.flowset.control.entity.processdefinition.ProcessDefinitionData;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.entity.processinstance.RuntimeProcessInstanceData;
import io.flowset.control.service.processinstance.ProcessInstanceService;
import io.flowset.control.view.processdefinition.event.ResetActivityEvent;
import io.jmix.core.AccessManager;
import io.jmix.core.DataLoadContext;
import io.jmix.core.Messages;
import io.jmix.core.Metadata;
import io.jmix.core.accesscontext.AccessContext;
import io.jmix.flowui.Fragments;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.UiEventPublisher;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.accesscontext.UiEntityContext;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.component.pagination.SimplePagination;
import io.jmix.flowui.data.pagination.PaginationDataLoader;
import io.jmix.flowui.data.pagination.PaginationDataLoaderImpl;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.action.ActionPerformedEvent;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.BaseCollectionLoader;
import io.jmix.flowui.model.CollectionContainer;
import io.jmix.flowui.model.HasLoader;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Supply;
import io.jmix.flowui.view.ViewComponent;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

@FragmentDescriptor(value="process-instances-fragment.xml")
public class ProcessInstancesFragment
extends Fragment<VerticalLayout> {
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected Notifications notifications;
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected Messages messages;
    @Autowired
    protected ViewNavigators viewNavigators;
    @ViewComponent
    protected InstanceContainer<ProcessDefinitionData> processDefinitionDataDc;
    @ViewComponent
    protected CollectionContainer<RuntimeProcessInstanceData> processInstanceDataDc;
    @Autowired
    protected ProcessInstanceService processInstanceService;
    @ViewComponent
    protected VerticalLayout processInstanceVBox;
    @ViewComponent
    protected DataGrid<RuntimeProcessInstanceData> processInstancesGrid;
    @ViewComponent
    protected SimplePagination processInstancesPagination;
    @Autowired
    protected Fragments fragments;
    @Autowired
    protected AccessManager accessManager;
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected UiComponents uiComponents;
    @ViewComponent
    private Div selectedActivityContainer;
    @Autowired
    private UiEventPublisher uiEventPublisher;
    @ViewComponent
    private InstanceContainer<ProcessInstanceFilter> processInstanceFilterDc;

    @Subscribe
    public void onReady(Fragment.ReadyEvent event) {
        HasLoader container;
        CollectionContainer collectionContainer = this.processInstanceDataDc;
        if (collectionContainer instanceof HasLoader && (container = (HasLoader)collectionContainer).getLoader() instanceof BaseCollectionLoader) {
            PaginationDataLoader paginationLoader = (PaginationDataLoader)this.applicationContext.getBean(PaginationDataLoaderImpl.class, new Object[]{container.getLoader()});
            this.processInstancesPagination.setPaginationLoader(paginationLoader);
        }
    }

    @Install(to="processInstancesPagination", subject="totalCountDelegate")
    protected Integer processInstancesPaginationTotalCountDelegate(DataLoadContext dataLoadContext) {
        return (int)this.processInstanceService.getRuntimeInstancesCount((ProcessInstanceFilter)this.processInstanceFilterDc.getItem());
    }

    @Subscribe(value="processInstancesGrid.edit")
    public void onProcessDefinitionsGridViewDetails(ActionPerformedEvent event) {
        RuntimeProcessInstanceData selectedInstance = (RuntimeProcessInstanceData)this.processInstancesGrid.getSingleSelectedItem();
        if (selectedInstance == null) {
            return;
        }
        this.openProcessInstanceDetailView(selectedInstance);
    }

    @Install(to="processInstancesGrid.id", subject="tooltipGenerator")
    protected String processInstancesGridIdTooltipGenerator(RuntimeProcessInstanceData processInstanceData) {
        return processInstanceData.getId();
    }

    @Supply(to="processInstancesGrid.actions", subject="renderer")
    protected Renderer<RuntimeProcessInstanceData> processInstancesGridActionsRenderer() {
        return new ComponentRenderer((SerializableFunction & Serializable)processInstance -> {
            UiEntityContext context = new UiEntityContext(this.metadata.getClass(processInstance));
            this.accessManager.applyRegisteredConstraints((AccessContext)context);
            if (!context.isViewPermitted()) {
                return null;
            }
            JmixButton viewButton = (JmixButton)this.uiComponents.create(JmixButton.class);
            viewButton.setIcon((Component)VaadinIcon.EYE.create());
            viewButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY, ButtonVariant.LUMO_SMALL});
            viewButton.setText(this.messages.getMessage("actions.View"));
            viewButton.addClickListener((ComponentEventListener & Serializable)event -> this.openProcessInstanceDetailView(processInstance));
            return viewButton;
        });
    }

    protected void openProcessInstanceDetailView(RuntimeProcessInstanceData selectedInstance) {
        this.viewNavigators.detailView(UiComponentUtils.getCurrentView(), ProcessInstanceData.class).withRouteParameters(new RouteParameters("id", selectedInstance.getId())).withBackwardNavigation(true).navigate();
    }

    public void clearActivity() {
        this.selectedActivityContainer.removeAll();
    }

    public void showActivity(String elementId, String elementType, String elementName) {
        this.selectedActivityContainer.removeAll();
        Span activityBadge = new Span(this.messageBundle.formatMessage("selectedActivityBadge.text", new Object[]{elementId}));
        activityBadge.getElement().getThemeList().add((Object)"badge pill primary small");
        activityBadge.setHeight("min-content");
        Tooltip tooltip = Tooltip.forComponent((Component)activityBadge);
        tooltip.setText("%s: %s".formatted(elementType, elementName));
        JmixButton clearBtn = (JmixButton)this.uiComponents.create(JmixButton.class);
        clearBtn.setIcon((Component)VaadinIcon.CLOSE_SMALL.create());
        clearBtn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
        clearBtn.addClassNames(new String[]{"text-primary-contrast"});
        clearBtn.addClickListener((ComponentEventListener & Serializable)clickEvent -> {
            this.clearActivity();
            this.uiEventPublisher.publishEventForCurrentUI((ApplicationEvent)new ResetActivityEvent((Object)this, elementId));
        });
        activityBadge.add(new Component[]{clearBtn});
        this.selectedActivityContainer.add(new Component[]{activityBadge});
    }
}

