/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processdefinition;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.router.Route;
import io.flowset.control.entity.processdefinition.ProcessDefinitionData;
import io.flowset.control.service.processdefinition.ProcessDefinitionService;
import io.flowset.control.view.processdefinition.ProcessDefinitionBulkOperationView;
import io.jmix.core.Messages;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.component.checkbox.JmixCheckbox;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpm/bulksuspendprocessdefinition", layout=DefaultMainViewParent.class)
@ViewController(value="bpm_BulkSuspendProcessDefinition")
@ViewDescriptor(value="bulk-suspend-process-definition-view.xml")
@DialogMode(width="35em")
public class BulkSuspendProcessDefinitionView
extends ProcessDefinitionBulkOperationView {
    @Autowired
    protected ProcessDefinitionService processDefinitionService;
    @ViewComponent
    protected Checkbox suspendProcessInstancesCheckBox;
    @Autowired
    protected Notifications notifications;
    @Autowired
    protected Messages messages;
    @ViewComponent
    protected JmixCheckbox suspendAllVersionsCheckBox;

    @Subscribe
    protected void onBeforeShow(View.BeforeShowEvent event) {
        this.suspendProcessInstancesCheckBox.setValue((Object)true);
    }

    @Subscribe(value="suspendBtn")
    protected void onSuspendBtnClick(ClickEvent<Button> event) {
        if (BooleanUtils.isTrue((Boolean)((Boolean)this.suspendAllVersionsCheckBox.getValue()))) {
            Set processDefinitionKeys = this.collectProcessDefinitionKeys();
            for (String key : processDefinitionKeys) {
                this.processDefinitionService.suspendAllVersionsByKey(key, Boolean.TRUE.equals(this.suspendProcessInstancesCheckBox.getValue()));
            }
        } else {
            for (ProcessDefinitionData processDefinition : this.processDefinitions) {
                this.processDefinitionService.suspendById(processDefinition.getId(), Boolean.TRUE.equals(this.suspendProcessInstancesCheckBox.getValue()));
            }
        }
        this.notifications.create(this.messages.getMessage(this.getClass(), "bulkSuspendSuccessNotification.headed")).withType(Notifications.Type.SUCCESS).build().open();
        this.close(StandardOutcome.SAVE);
    }

    @Subscribe(value="cancelBtn")
    protected void onCancelBtnClick(ClickEvent<Button> event) {
        this.close(StandardOutcome.DISCARD);
    }
}

