/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.processdefinition;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.router.Route;
import io.flowset.control.entity.processdefinition.ProcessDefinitionData;
import io.flowset.control.exception.RemoteProcessEngineException;
import io.flowset.control.service.processdefinition.ProcessDefinitionService;
import io.flowset.control.service.processinstance.ProcessInstanceService;
import io.flowset.control.view.processdefinition.ProcessDefinitionBulkOperationView;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.component.checkbox.JmixCheckbox;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpm/bulkdeleteprocessdefinition", layout=DefaultMainViewParent.class)
@ViewController(value="bpm_BulkDeleteProcessDefinition")
@ViewDescriptor(value="bulk-delete-process-definition-view.xml")
@DialogMode(width="35em")
public class BulkDeleteProcessDefinitionView
extends ProcessDefinitionBulkOperationView {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BulkDeleteProcessDefinitionView.class);
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected Notifications notifications;
    @Autowired
    protected ProcessDefinitionService processDefinitionService;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @ViewComponent
    protected JmixCheckbox deleteAllVersionsCheckBox;
    @ViewComponent
    protected JmixCheckbox deleteProcessInstancesCheckBox;

    @Subscribe
    protected void onBeforeShow(View.BeforeShowEvent event) {
        this.deleteProcessInstancesCheckBox.setValue(Boolean.valueOf(true));
        boolean hasRunningInstances = false;
        for (ProcessDefinitionData processDefinitionData : this.processDefinitions) {
            long countByProcessDefinitionId = this.processInstanceService.getCountByProcessDefinitionId(processDefinitionData.getProcessDefinitionId());
            if (countByProcessDefinitionId <= 0L) continue;
            hasRunningInstances = true;
            break;
        }
        if (hasRunningInstances) {
            this.allInstancesContextHelp.setTooltipText(this.messageBundle.getMessage("bulkDeleteAllRunningInstances.tooltip"));
        }
        this.deleteProcessInstancesCheckBox.setEnabled(!hasRunningInstances);
    }

    @Subscribe(value="okBtn")
    protected void onOkBtnClick(ClickEvent<Button> event) {
        boolean deleteAllRelatedInstances = BooleanUtils.isTrue((Boolean)((Boolean)this.deleteProcessInstancesCheckBox.getValue()));
        try {
            if (BooleanUtils.isTrue((Boolean)((Boolean)this.deleteAllVersionsCheckBox.getValue()))) {
                Set processDefinitionKeys = this.collectProcessDefinitionKeys();
                for (String key : processDefinitionKeys) {
                    this.processDefinitionService.deleteAllVersionsByKey(key, deleteAllRelatedInstances);
                }
            } else {
                for (ProcessDefinitionData processDefinition : this.processDefinitions) {
                    this.processDefinitionService.deleteById(processDefinition.getId(), deleteAllRelatedInstances);
                }
            }
            this.notifications.create(this.messageBundle.getMessage("processesDeleted")).withType(Notifications.Type.SUCCESS).show();
        }
        catch (Exception e) {
            if (e instanceof RemoteProcessEngineException) {
                RemoteProcessEngineException processEngineException = (RemoteProcessEngineException)e;
                log.error("Unable to delete process definitions", (Throwable)e);
                String responseMessage = processEngineException.getResponseMessage();
                String errorReason = StringUtils.isNotEmpty((CharSequence)responseMessage) ? responseMessage.replaceAll("\\.", ".\n") : e.getMessage();
                this.notifications.create(errorReason).withType(Notifications.Type.ERROR).withDuration(10000).show();
                return;
            }
            throw e;
        }
        this.close(StandardOutcome.SAVE);
    }

    @Subscribe(value="cancelBtn")
    protected void onCancelBtnClick(ClickEvent<Button> event) {
        this.close(StandardOutcome.DISCARD);
    }
}

