/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.main;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import io.flowset.control.entity.EngineConnectionCheckResult;
import io.flowset.control.entity.engine.BpmEngine;
import io.flowset.control.entity.engine.EngineType;
import io.flowset.control.view.engineconnectionsettings.EngineConnectionSettingsView;
import io.jmix.core.Messages;
import io.jmix.flowui.DialogWindows;
import io.jmix.flowui.component.UiComponentUtils;
import io.jmix.flowui.fragment.Fragment;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.ViewComponent;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.vaadin.addons.componentfactory.spinner.Spinner;

@FragmentDescriptor(value="engine-status-badge-fragment.xml")
public class EngineStatusBadgeFragment
extends Fragment<FlexLayout> {
    @ViewComponent
    protected Spinner statusSpinner;
    @ViewComponent
    protected InstanceContainer<EngineConnectionCheckResult> engineConnectionStatusDc;
    @ViewComponent
    protected InstanceContainer<BpmEngine> selectedEngineDc;
    @ViewComponent
    protected Span engineStateBadge;
    @ViewComponent
    protected Div connectionStatusText;
    @ViewComponent
    protected MessageBundle messageBundle;
    @ViewComponent
    protected Icon successStatusIcon;
    @ViewComponent
    protected Icon warningStatusIcon;
    @Autowired
    protected Messages messages;
    @Autowired
    protected DialogWindows dialogWindows;

    @Subscribe
    protected void onAttachEvent(AttachEvent event) {
        this.initConnectionStatusComponents();
    }

    public void initConnectionStatusComponents() {
        this.statusSpinner.setVisible(true);
        this.statusSpinner.setLoading(true);
        this.successStatusIcon.setVisible(false);
        this.warningStatusIcon.setVisible(false);
        if (this.selectedEngineDc.getItemOrNull() != null) {
            this.engineStateBadge.setTitle(((BpmEngine)this.selectedEngineDc.getItem()).getBaseUrl());
            this.addSelectedEngineData(null);
        } else {
            this.setNoSelectedEngineStatus();
        }
    }

    public void updateConnectionStatusComponents() {
        this.statusSpinner.setLoading(false);
        EngineConnectionCheckResult item = (EngineConnectionCheckResult)this.engineConnectionStatusDc.getItem();
        if (BooleanUtils.isTrue((Boolean)item.getSuccess())) {
            this.setSuccessfulConnectionStatus(item.getVersion());
        } else {
            this.setFailedConnectionStatus();
        }
    }

    @Subscribe(id="viewEngineConfigBtn", subject="clickListener")
    public void onViewEngineConfigBtnClick(ClickEvent<JmixButton> event) {
        this.dialogWindows.view(UiComponentUtils.getCurrentView(), EngineConnectionSettingsView.class).build().open();
    }

    protected void setSuccessfulConnectionStatus(String version) {
        this.addSelectedEngineData(version);
        this.engineStateBadge.getElement().getThemeList().clear();
        this.engineStateBadge.getElement().getThemeList().add((Object)"badge pill success");
        this.successStatusIcon.setVisible(true);
        this.warningStatusIcon.setVisible(false);
    }

    protected void addSelectedEngineData(@Nullable String version) {
        Span engineTypeAndVersion;
        this.connectionStatusText.removeAll();
        BpmEngine engine = (BpmEngine)this.selectedEngineDc.getItem();
        Span engineName = new Span(engine.getName());
        engineName.setMaxWidth("10em");
        engineName.addClassNames(new String[]{"overflow-ellipsis", "overflow-hidden", "whitespace-nowrap"});
        if (version != null) {
            String generalTypeName = this.messages.getMessage(EngineType.class, "EngineType.%s.general".formatted(engine.getType().name()));
            engineTypeAndVersion = new Span("(%s %s)".formatted(generalTypeName, version));
        } else {
            engineTypeAndVersion = new Span("(%s)".formatted(this.messages.getMessage((Enum)engine.getType())));
        }
        this.connectionStatusText.add(new Component[]{engineName, engineTypeAndVersion});
    }

    public void setFailedConnectionStatus() {
        this.statusSpinner.setLoading(false);
        this.addSelectedEngineData(null);
        this.engineStateBadge.getElement().getThemeList().clear();
        this.engineStateBadge.getElement().getThemeList().add((Object)"badge pill error");
        this.successStatusIcon.setVisible(false);
        this.warningStatusIcon.setVisible(true);
    }

    public void setNoSelectedEngineStatus() {
        this.connectionStatusText.removeAll();
        this.connectionStatusText.setText(this.messageBundle.getMessage("noSelectedEngine"));
        this.engineStateBadge.getElement().getThemeList().clear();
        this.engineStateBadge.getElement().getThemeList().add((Object)"badge pill warning");
        this.successStatusIcon.setVisible(false);
        this.warningStatusIcon.setVisible(true);
        this.statusSpinner.setLoading(false);
    }
}

