/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.historicvariableinstancedata;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.textfield.IntegerField;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.router.Route;
import io.flowset.control.entity.variable.CamundaVariableType;
import io.flowset.control.entity.variable.HistoricVariableInstanceData;
import io.flowset.control.service.variable.VariableService;
import io.flowset.control.service.variable.VariableUtils;
import io.flowset.control.view.historicvariableinstancedata.HistoricVariableInstanceDataDetailView;
import io.flowset.control.view.main.MainView;
import io.jmix.core.LoadContext;
import io.jmix.core.metamodel.datatype.DatatypeRegistry;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.component.datetimepicker.TypedDateTimePicker;
import io.jmix.flowui.component.formlayout.JmixFormLayout;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.EditedEntityContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardDetailView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="historicVariableInstanceDatas/:id", layout=MainView.class)
@ViewController(value="HistoricVariableInstanceData.detail")
@ViewDescriptor(value="historic-variable-instance-data-detail-view.xml")
@EditedEntityContainer(value="historicVariableInstanceDataDc")
@DialogMode(minWidth="30em", maxWidth="60em")
public class HistoricVariableInstanceDataDetailView
extends StandardDetailView<HistoricVariableInstanceData> {
    @Autowired
    protected VariableService variableService;
    @ViewComponent
    protected JmixFormLayout form;
    @ViewComponent
    protected InstanceContainer<HistoricVariableInstanceData> historicVariableInstanceDataDc;
    @Autowired
    protected UiComponents uiComponents;
    @Autowired
    protected DatatypeRegistry datatypeRegistry;
    @ViewComponent
    protected MessageBundle messageBundle;
    @ViewComponent
    protected TypedTextField<String> fileNameField;
    @ViewComponent
    protected TypedTextField<String> mimeTypeField;
    @ViewComponent
    protected TypedTextField<String> encodingField;
    @ViewComponent
    protected TypedTextField<String> objectTypeInfoField;
    @ViewComponent
    protected TypedTextField<String> serializationDataFormatField;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.addClassNames(new String[]{"pt-xs"});
        this.form.getOwnComponents().forEach(component -> component.addClassNames(new String[]{"pt-s"}));
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        HistoricVariableInstanceData variableInstance = this.variableService.findHistoricVariableById(((HistoricVariableInstanceData)this.getEditedEntity()).getHistoricVariableInstanceId());
        this.historicVariableInstanceDataDc.setItem((Object)variableInstance);
        if (variableInstance.getType() != null) {
            this.initValueComponent();
            CamundaVariableType camundaVariableType = CamundaVariableType.fromId((String)variableInstance.getType());
            if (camundaVariableType == CamundaVariableType.FILE) {
                this.fileNameField.setVisible(true);
                this.mimeTypeField.setVisible(true);
                this.encodingField.setVisible(true);
            } else if (camundaVariableType == CamundaVariableType.OBJECT) {
                this.objectTypeInfoField.setVisible(true);
                this.serializationDataFormatField.setVisible(true);
            }
        }
    }

    protected void initValueComponent() {
        Component valueComponent = this.createComponent();
        if (valueComponent instanceof HasSize) {
            HasSize hasSize = (HasSize)valueComponent;
            hasSize.setWidthFull();
        }
        if (valueComponent instanceof HasLabel) {
            HasLabel hasLabel = (HasLabel)valueComponent;
            hasLabel.setLabel(this.messageBundle.getMessage("historicVariableInstanceData.value"));
        }
        this.form.addComponentAtIndex(2, valueComponent);
    }

    protected Component createComponent() {
        String typeName = ((HistoricVariableInstanceData)this.getEditedEntity()).getType();
        CamundaVariableType type = CamundaVariableType.fromId((String)typeName);
        if (type == null) {
            return this.createTextField(String.class);
        }
        return switch (1.$SwitchMap$io$flowset$control$entity$variable$CamundaVariableType[type.ordinal()]) {
            case 1 -> this.createTextField(Long.class);
            case 2 -> this.createTextField(Short.class);
            case 3 -> this.createIntegerField();
            case 4 -> this.createNumberField();
            case 5 -> this.createDateField();
            default -> this.createTextField(String.class);
        };
    }

    protected NumberField createNumberField() {
        NumberField numberField = (NumberField)this.uiComponents.create(NumberField.class);
        numberField.setReadOnly(true);
        numberField.setValue((Number)((Double)((HistoricVariableInstanceData)this.getEditedEntity()).getValue()));
        return numberField;
    }

    protected IntegerField createIntegerField() {
        IntegerField integerField = (IntegerField)this.uiComponents.create(IntegerField.class);
        integerField.setReadOnly(true);
        integerField.setValue((Number)((Integer)((HistoricVariableInstanceData)this.getEditedEntity()).getValue()));
        return integerField;
    }

    protected <V> TypedTextField<V> createTextField(Class<V> clazz) {
        TypedTextField component = (TypedTextField)this.uiComponents.create(TypedTextField.class);
        component.setDatatype(this.datatypeRegistry.get(clazz));
        component.setReadOnly(true);
        if (((HistoricVariableInstanceData)this.getEditedEntity()).getValue() != null) {
            if (((HistoricVariableInstanceData)this.getEditedEntity()).getValue().getClass().isAssignableFrom(clazz)) {
                component.setTypedValue(((HistoricVariableInstanceData)this.getEditedEntity()).getValue());
            } else {
                component.setValue(((HistoricVariableInstanceData)this.getEditedEntity()).getValue().toString());
            }
        }
        return component;
    }

    protected TypedDateTimePicker<Date> createDateField() {
        TypedDateTimePicker component = (TypedDateTimePicker)this.uiComponents.create(TypedDateTimePicker.class);
        component.setDatatype(this.datatypeRegistry.get(Date.class));
        component.setReadOnly(true);
        component.setTypedValue((Comparable)((Date)VariableUtils.parseDateValue((Object)((HistoricVariableInstanceData)this.getEditedEntity()).getValue())));
        return component;
    }

    @Install(to="historicVariableInstanceDataDl", target=Target.DATA_LOADER)
    protected HistoricVariableInstanceData historicVariableInstanceDataDlLoadDelegate(LoadContext<HistoricVariableInstanceData> loadContext) {
        Object id = loadContext.getId();
        if (id != null) {
            return this.variableService.findHistoricVariableById(id.toString());
        }
        return null;
    }
}

