/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.externaltask;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.router.Route;
import io.flowset.control.entity.ExternalTaskData;
import io.flowset.control.service.externaltask.ExternalTaskService;
import io.flowset.control.view.main.MainView;
import io.jmix.core.Messages;
import io.jmix.flowui.Dialogs;
import io.jmix.flowui.action.DialogAction;
import io.jmix.flowui.kit.action.Action;
import io.jmix.flowui.kit.action.ActionVariant;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.EditedEntityContainer;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardDetailView;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="external-tasks/:id", layout=MainView.class)
@ViewController(value="ExternalTaskData.detail")
@ViewDescriptor(value="external-task-data-detail-view.xml")
@EditedEntityContainer(value="externalTaskDataDc")
@DialogMode(width="60em", resizable=true)
public class ExternalTaskDataDetailView
extends StandardDetailView<ExternalTaskData> {
    @Autowired
    protected ExternalTaskService externalTaskService;
    @ViewComponent
    protected TextArea errorDetailsField;
    @ViewComponent
    protected JmixButton retryBtn;
    @Autowired
    protected Dialogs dialogs;
    @ViewComponent
    protected MessageBundle messageBundle;
    @Autowired
    protected Messages messages;

    @Subscribe
    protected void onBeforeShow(View.BeforeShowEvent event) {
        String errorDetails = this.externalTaskService.getErrorDetails(((ExternalTaskData)this.getEditedEntity()).getExternalTaskId());
        this.errorDetailsField.setValue(errorDetails);
        if (((ExternalTaskData)this.getEditedEntity()).getRetries() != null && ((ExternalTaskData)this.getEditedEntity()).getRetries() == 0) {
            this.retryBtn.setVisible(true);
        }
    }

    @Subscribe(value="retryBtn")
    protected void onRestoreFailedJobBtnClick(ClickEvent<Button> event) {
        ((Dialogs.OptionDialogBuilder)((Dialogs.OptionDialogBuilder)this.dialogs.createOptionDialog().withHeader(this.messageBundle.getMessage("retryExternalTaskDialog.header"))).withText(this.messageBundle.getMessage("retryExternalTaskDialog.text"))).withActions(new Action[]{new DialogAction(DialogAction.Type.YES).withIcon(VaadinIcon.ROTATE_LEFT.create()).withText(this.messages.getMessage("actions.Retry")).withVariant(ActionVariant.PRIMARY).withHandler(actionPerformedEvent -> {
            this.externalTaskService.setRetries(((ExternalTaskData)this.getEditedEntity()).getExternalTaskId(), 1);
            this.close(StandardOutcome.SAVE);
        }), new DialogAction(DialogAction.Type.CANCEL)}).open();
    }
}

