/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.deploymentdata;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.IFrame;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.selection.SelectionEvent;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import io.flowset.control.action.CopyComponentValueToClipboardAction;
import io.flowset.control.entity.deployment.DeploymentData;
import io.flowset.control.entity.deployment.DeploymentProcessInstancesInfo;
import io.flowset.control.entity.deployment.DeploymentResource;
import io.flowset.control.entity.filter.ProcessDefinitionFilter;
import io.flowset.control.entity.processdefinition.ProcessDefinitionData;
import io.flowset.control.exception.EngineResourceNotAvailableException;
import io.flowset.control.service.deployment.DeploymentService;
import io.flowset.control.service.processdefinition.ProcessDefinitionLoadContext;
import io.flowset.control.service.processdefinition.ProcessDefinitionService;
import io.flowset.control.service.processinstance.ProcessInstanceService;
import io.flowset.control.view.main.MainView;
import io.flowset.control.view.processdefinition.ProcessDefinitionDetailView;
import io.flowset.uikit.fragment.bpmnviewer.BpmnViewerFragment;
import io.flowset.uikit.fragment.dmnviewer.DmnViewerFragment;
import io.flowset.uikit.fragment.formviewer.FormViewerFragment;
import io.jmix.core.LoadContext;
import io.jmix.core.Messages;
import io.jmix.core.Metadata;
import io.jmix.flowui.Fragments;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.component.grid.DataGridColumn;
import io.jmix.flowui.component.tabsheet.JmixTabSheet;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.download.Downloader;
import io.jmix.flowui.fragment.FragmentOwner;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.kit.component.codeeditor.CodeEditorMode;
import io.jmix.flowui.kit.component.codeeditor.JmixCodeEditor;
import io.jmix.flowui.kit.component.grid.JmixGrid;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.EditedEntityContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.PrimaryDetailView;
import io.jmix.flowui.view.StandardDetailView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;

/*
 * Exception performing whole class analysis ignored.
 */
@Route(value="bpm/deployment/:id", layout=MainView.class)
@ViewController(id="bpm_Deployment.detail")
@ViewDescriptor(path="deployment-detail-view.xml")
@EditedEntityContainer(value="deploymentDataDc")
@DialogMode(width="70em", height="40em")
@PrimaryDetailView(value=DeploymentData.class)
public class DeploymentDetailView
extends StandardDetailView<DeploymentData> {
    private static final Pattern BPMN_PATTERN = Pattern.compile(".*\\.(bpmn\\d*\\.xml|bpmn)$");
    private static final Pattern DMN_PATTERN = Pattern.compile(".*\\.(dmn\\d*\\.xml|dmn)$");
    private static final Pattern FORM_PATTERN = Pattern.compile(".*\\.form$");
    private static final Pattern IMAGE_PATTERN = Pattern.compile(".*\\.(gif|jpg|jpeg|jpe|png|svg|tif|tiff)$");
    private static final Pattern HTML_PATTERN = Pattern.compile(".*\\.html$");
    @Autowired
    private DeploymentService deploymentService;
    @Autowired
    private Downloader downloader;
    @Autowired
    private ProcessDefinitionService processDefinitionService;
    @Autowired
    private Metadata metadata;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private Messages messages;
    @Autowired
    private UiComponents uiComponents;
    @Autowired
    private Fragments fragments;
    @Autowired
    private ViewNavigators viewNavigators;
    @ViewComponent
    private InstanceContainer<DeploymentData> deploymentDataDc;
    @ViewComponent
    private JmixTabSheet resourceTabSheet;
    @ViewComponent
    private JmixButton downloadResourceButton;
    @ViewComponent
    private Div emptyResourceMessageContainer;
    @ViewComponent
    private DataGrid<DeploymentResource> resourcesDataGrid;
    @ViewComponent
    private Span deploymentResourcesLabel;
    @ViewComponent
    private CopyComponentValueToClipboardAction copyToClipboardAction;
    @ViewComponent
    private TypedTextField<String> nameTextField;
    @ViewComponent
    private TypedTextField<String> deploymentIdTextField;
    private String viewTabLabel;
    private String sourceTabLabel;
    private String runningInstancesTabLabel;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.viewTabLabel = this.messages.getMessage(this.getClass(), "viewTab.title");
        this.sourceTabLabel = this.messages.getMessage(this.getClass(), "viewTab.source");
        this.runningInstancesTabLabel = this.messages.getMessage(this.getClass(), "viewTab.runningInstances");
        this.initResourcesDataGrid();
        this.deploymentResourcesLabel.addClassNames(new String[]{"text-secondary"});
        this.deploymentResourcesLabel.addClassNames(new String[]{"font-semibold"});
        this.addClassName("pb-s");
    }

    @Subscribe(id="copyDeploymentId", subject="clickListener")
    public void onCopyDeploymentIdClick(ClickEvent<JmixButton> event) {
        this.copyToClipboardAction.setTarget((HasValue)this.deploymentIdTextField);
        this.copyToClipboardAction.actionPerform(event.getSource());
    }

    @Subscribe(id="copyName", subject="clickListener")
    public void onCopyNameClick(ClickEvent<JmixButton> event) {
        this.copyToClipboardAction.setTarget((HasValue)this.nameTextField);
        this.copyToClipboardAction.actionPerform(event.getSource());
    }

    @Subscribe(id="downloadResourceButton", subject="clickListener")
    public void onDownloadResourceButtonClick(ClickEvent<JmixButton> event) {
        DeploymentResource selectedResource = (DeploymentResource)this.resourcesDataGrid.getSingleSelectedItem();
        if (selectedResource != null) {
            Resource deploymentResourceData = this.deploymentService.getDeploymentResourceData(selectedResource.getDeploymentId(), selectedResource.getResourceId());
            byte[] byteArrayContent = DeploymentDetailView.getByteArrayContent((Resource)deploymentResourceData);
            this.downloader.download(() -> new ByteArrayInputStream(byteArrayContent), selectedResource.getName());
        }
    }

    @Subscribe(value="resourcesDataGrid")
    public void onResourcesDataGridSelection(SelectionEvent<DataGrid<DeploymentResource>, DeploymentResource> event) {
        DeploymentResource selectedResourceName = (DeploymentResource)((DataGrid)event.getSource()).getSingleSelectedItem();
        if (selectedResourceName == null) {
            return;
        }
        String resourceName = selectedResourceName.getName();
        Resource deploymentResourceData = this.deploymentService.getDeploymentResourceData(selectedResourceName.getDeploymentId(), selectedResourceName.getResourceId());
        this.resourceTabSheet.setVisible(true);
        this.downloadResourceButton.setVisible(true);
        this.emptyResourceMessageContainer.setVisible(false);
        if (BPMN_PATTERN.matcher(resourceName).matches()) {
            this.showBpmn(deploymentResourceData);
        } else if (DMN_PATTERN.matcher(resourceName).matches()) {
            this.showDmn(deploymentResourceData);
        } else if (FORM_PATTERN.matcher(resourceName).matches()) {
            this.showForm(deploymentResourceData);
        } else if (IMAGE_PATTERN.matcher(resourceName).matches()) {
            this.showImage(deploymentResourceData);
        } else if (HTML_PATTERN.matcher(resourceName).matches()) {
            this.showHtml(deploymentResourceData);
        } else {
            this.showUnsupportedResource(deploymentResourceData);
        }
    }

    @Subscribe(id="deploymentDataDc", target=Target.DATA_CONTAINER)
    protected void onDeploymentDataDcItemChange(InstanceContainer.ItemChangeEvent<DeploymentData> event) {
        DeploymentData deploymentData = (DeploymentData)event.getItem();
        if (deploymentData != null) {
            List deploymentResourceNames = this.deploymentService.getDeploymentResources(deploymentData.getDeploymentId());
            this.resourcesDataGrid.setItems(new ArrayList(deploymentResourceNames != null ? deploymentResourceNames : List.of()));
        }
    }

    @Install(to="deploymentDataDl", target=Target.DATA_LOADER)
    private DeploymentData customerDlLoadDelegate(LoadContext<DeploymentData> loadContext) {
        DeploymentData item = (DeploymentData)this.deploymentDataDc.getItemOrNull();
        String id = item == null ? Objects.requireNonNull(loadContext.getId()).toString() : item.getId();
        return this.deploymentService.findById(id);
    }

    private void initResourcesDataGrid() {
        DataGridColumn instanceCountColumn = this.resourcesDataGrid.addColumn(DeploymentResource::getName);
        instanceCountColumn.setHeader(this.messages.getMessage(DeploymentResource.class, "DeploymentResource.name"));
        instanceCountColumn.setResizable(true);
    }

    private void showUnsupportedResource(Resource deploymentResourceData) {
        this.clearTabSheet(this.resourceTabSheet);
        String textContent = DeploymentDetailView.getTextContent((Resource)deploymentResourceData);
        this.createTab(this.resourceTabSheet, VaadinIcon.EYE.create(), this.sourceTabLabel, this.createCodeEditor(textContent, CodeEditorMode.TEXT));
    }

    private void showHtml(Resource deploymentResourceData) {
        this.clearTabSheet(this.resourceTabSheet);
        byte[] byteArrayContent = DeploymentDetailView.getByteArrayContent((Resource)deploymentResourceData);
        String textContent = DeploymentDetailView.getTextContent((Resource)deploymentResourceData);
        this.createTab(this.resourceTabSheet, VaadinIcon.EYE.create(), this.viewTabLabel, this.createHtmlViewer(byteArrayContent));
        this.createTab(this.resourceTabSheet, VaadinIcon.FILE_CODE.create(), this.sourceTabLabel, this.createCodeEditor(textContent, CodeEditorMode.HTML));
    }

    private Component createHtmlViewer(byte[] byteArrayContent) {
        String base64Html = Base64.getEncoder().encodeToString(byteArrayContent);
        String dataUrl = "data:text/html;base64," + base64Html;
        IFrame iframe = (IFrame)this.uiComponents.create(IFrame.class);
        iframe.setSrc(dataUrl);
        iframe.setWidth("100%");
        iframe.setHeight("100%");
        iframe.getStyle().set("border", "none");
        iframe.getStyle().set("padding", "0");
        return iframe;
    }

    private void showImage(Resource deploymentResourceData) {
        this.clearTabSheet(this.resourceTabSheet);
        byte[] byteArrayContent = DeploymentDetailView.getByteArrayContent((Resource)deploymentResourceData);
        this.createTab(this.resourceTabSheet, VaadinIcon.PICTURE.create(), this.viewTabLabel, this.createImageViewer(deploymentResourceData.getFilename(), byteArrayContent));
    }

    private void clearTabSheet(JmixTabSheet resourceTabSheet) {
        resourceTabSheet.getChildren().forEach(component -> resourceTabSheet.remove((Tab)component));
    }

    private Component createImageViewer(String fileName, byte[] byteArrayContent) {
        Image image = new Image();
        image.setSrc((AbstractStreamResource)new StreamResource(fileName, (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(byteArrayContent)));
        return image;
    }

    private void showForm(Resource deploymentResourceData) {
        this.clearTabSheet(this.resourceTabSheet);
        String textContent = DeploymentDetailView.getTextContent((Resource)deploymentResourceData);
        this.createTab(this.resourceTabSheet, VaadinIcon.EYE.create(), this.viewTabLabel, this.createFormViewer(textContent));
        this.createTab(this.resourceTabSheet, VaadinIcon.FILE_CODE.create(), this.sourceTabLabel, this.createCodeEditor(textContent, CodeEditorMode.XML));
    }

    private void showDmn(Resource deploymentResourceData) {
        this.clearTabSheet(this.resourceTabSheet);
        String textContent = DeploymentDetailView.getTextContent((Resource)deploymentResourceData);
        this.createTab(this.resourceTabSheet, VaadinIcon.SITEMAP.create(), this.viewTabLabel, this.createDmnViewer(textContent));
        this.createTab(this.resourceTabSheet, VaadinIcon.FILE_CODE.create(), this.sourceTabLabel, this.createCodeEditor(textContent, CodeEditorMode.XML));
    }

    private void showBpmn(Resource deploymentResourceData) {
        this.clearTabSheet(this.resourceTabSheet);
        String textContent = DeploymentDetailView.getTextContent((Resource)deploymentResourceData);
        this.createTab(this.resourceTabSheet, VaadinIcon.SITEMAP.create(), this.viewTabLabel, this.createBpmnViewer(textContent));
        this.createTab(this.resourceTabSheet, VaadinIcon.FILE_CODE.create(), this.sourceTabLabel, this.createCodeEditor(textContent, CodeEditorMode.XML));
        this.createTab(this.resourceTabSheet, VaadinIcon.HOURGLASS.create(), this.runningInstancesTabLabel, this.createProcessDefinitionViewer());
    }

    private void createTab(JmixTabSheet parent, Icon icon, String tabLabel, Component tabComponent) {
        Tab tab = (Tab)this.uiComponents.create(Tab.class);
        tab.setLabel(tabLabel);
        tab.addComponentAsFirst((Component)icon);
        parent.add(tab, tabComponent);
    }

    private Component createProcessDefinitionViewer() {
        ProcessDefinitionFilter filter = (ProcessDefinitionFilter)this.metadata.create(ProcessDefinitionFilter.class);
        filter.setDeploymentId(((DeploymentData)this.deploymentDataDc.getItem()).getDeploymentId());
        filter.setLatestVersionOnly(Boolean.valueOf(false));
        ProcessDefinitionLoadContext context = new ProcessDefinitionLoadContext().setFilter(filter);
        List deploymentProcessDefinitions = this.processDefinitionService.findAll(context);
        ArrayList deploymentProcessInstancesInfos = new ArrayList();
        deploymentProcessDefinitions.forEach(processDefinitionData -> {
            DeploymentProcessInstancesInfo deploymentProcessInstancesInfo = (DeploymentProcessInstancesInfo)this.metadata.create(DeploymentProcessInstancesInfo.class);
            deploymentProcessInstancesInfo.setProcessDefinitionId(processDefinitionData.getProcessDefinitionId());
            deploymentProcessInstancesInfo.setProcessDefinitionName(processDefinitionData.getName());
            deploymentProcessInstancesInfo.setProcessDefinitionKey(processDefinitionData.getKey());
            deploymentProcessInstancesInfo.setProcessInstanceCount(Long.valueOf(this.processInstanceService.getCountByProcessDefinitionId(processDefinitionData.getProcessDefinitionId())));
            deploymentProcessInstancesInfos.add(deploymentProcessInstancesInfo);
        });
        JmixGrid grid = (JmixGrid)this.uiComponents.create(JmixGrid.class);
        grid.setWidth("100%");
        grid.setHeight("100%");
        Grid.Column nameColumn = grid.addColumn(DeploymentProcessInstancesInfo::getProcessDefinitionName);
        nameColumn.setHeader(this.messages.getMessage(DeploymentProcessInstancesInfo.class, "DeploymentProcessInstancesInfo.processDefinitionName"));
        nameColumn.setResizable(true);
        Grid.Column keyColumn = grid.addColumn(DeploymentProcessInstancesInfo::getProcessDefinitionKey);
        keyColumn.setHeader(this.messages.getMessage(DeploymentProcessInstancesInfo.class, "DeploymentProcessInstancesInfo.processDefinitionKey"));
        keyColumn.setResizable(true);
        keyColumn.setRenderer((Renderer)new ComponentRenderer((SerializableFunction & Serializable)deploymentProcessInstancesInfo -> {
            JmixButton button = (JmixButton)this.uiComponents.create(JmixButton.class);
            button.setText(deploymentProcessInstancesInfo.getProcessDefinitionKey());
            button.addThemeName("tertiary-inline");
            button.addClickListener((ComponentEventListener & Serializable)event -> this.viewNavigators.detailView((View)this, ProcessDefinitionData.class).withViewClass(ProcessDefinitionDetailView.class).withRouteParameters(new RouteParameters("id", deploymentProcessInstancesInfo.getProcessDefinitionId())).withBackwardNavigation(true).navigate());
            return button;
        }));
        Grid.Column instanceCountColumn = grid.addColumn(DeploymentProcessInstancesInfo::getProcessInstanceCount);
        instanceCountColumn.setHeader(this.messages.getMessage(DeploymentProcessInstancesInfo.class, "DeploymentProcessInstancesInfo.processInstanceCount"));
        instanceCountColumn.setResizable(true);
        grid.setItems(deploymentProcessInstancesInfos);
        return grid;
    }

    private Component createBpmnViewer(String xmlData) {
        BpmnViewerFragment bpmnViewerFragment = (BpmnViewerFragment)this.fragments.create((FragmentOwner)this, BpmnViewerFragment.class);
        bpmnViewerFragment.initViewer(xmlData);
        return bpmnViewerFragment;
    }

    private Component createDmnViewer(String xmlData) {
        DmnViewerFragment dmnViewerFragment = (DmnViewerFragment)this.fragments.create((FragmentOwner)this, DmnViewerFragment.class);
        dmnViewerFragment.initViewer();
        dmnViewerFragment.setDmnXml(xmlData);
        return dmnViewerFragment;
    }

    private Component createFormViewer(String jsonData) {
        FormViewerFragment formViewerFragment = (FormViewerFragment)this.fragments.create((FragmentOwner)this, FormViewerFragment.class);
        formViewerFragment.initViewer(jsonData);
        return formViewerFragment;
    }

    private Component createCodeEditor(String codeEditorData, CodeEditorMode codeEditorMode) {
        JmixCodeEditor codeEditor = (JmixCodeEditor)this.uiComponents.create(JmixCodeEditor.class);
        codeEditor.setMode(codeEditorMode);
        codeEditor.getStyle().set("padding", "0");
        codeEditor.setWidth("100%");
        codeEditor.setHeight("100%");
        codeEditor.setReadOnly(true);
        codeEditor.setValue((Object)codeEditorData);
        return codeEditor;
    }

    private static String getTextContent(Resource deploymentResourceData) {
        String xmlString;
        try {
            xmlString = new String(deploymentResourceData.getContentAsByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new EngineResourceNotAvailableException(deploymentResourceData.getFilename());
        }
        return xmlString;
    }

    private static byte[] getByteArrayContent(Resource deploymentResourceData) {
        byte[] byteArray;
        try {
            byteArray = deploymentResourceData.getContentAsByteArray();
        }
        catch (IOException e) {
            throw new EngineResourceNotAvailableException(deploymentResourceData.getFilename());
        }
        return byteArray;
    }
}

