/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.decisioninstance.filter;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import io.flowset.control.entity.decisioninstance.HistoricDecisionInstanceShortData;
import io.flowset.control.entity.filter.DecisionInstanceFilter;
import io.flowset.control.uicomponent.ContainerDataGridHeaderFilter;
import io.jmix.flowui.component.datetimepicker.TypedDateTimePicker;
import io.jmix.flowui.component.grid.DataGrid;
import io.jmix.flowui.component.grid.DataGridColumn;
import io.jmix.flowui.model.InstanceContainer;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class EvaluationTimeHeaderFilter
extends ContainerDataGridHeaderFilter<DecisionInstanceFilter, HistoricDecisionInstanceShortData> {
    private TypedDateTimePicker<LocalDateTime> evaluatedAfter;
    private TypedDateTimePicker<LocalDateTime> evaluatedBefore;

    public EvaluationTimeHeaderFilter(DataGrid<HistoricDecisionInstanceShortData> dataGrid, DataGridColumn<HistoricDecisionInstanceShortData> column, InstanceContainer<DecisionInstanceFilter> filterDc) {
        super(dataGrid, column, filterDc);
    }

    public void apply() {
        LocalDateTime startTimeBefore = (LocalDateTime)this.evaluatedBefore.getValue();
        if (startTimeBefore != null) {
            ZoneId zoneId = this.evaluatedBefore.getZoneId();
            ZoneId zone = zoneId != null ? zoneId : ZoneId.systemDefault();
            ((DecisionInstanceFilter)this.filterDc.getItem()).setEvaluatedBefore(startTimeBefore.atZone(zone).toOffsetDateTime());
        } else {
            ((DecisionInstanceFilter)this.filterDc.getItem()).setEvaluatedBefore(null);
        }
        LocalDateTime startTimeAfter = (LocalDateTime)this.evaluatedAfter.getValue();
        if (startTimeAfter != null) {
            ZoneId zoneId = this.evaluatedAfter.getZoneId();
            ZoneId zone = zoneId != null ? zoneId : ZoneId.systemDefault();
            ((DecisionInstanceFilter)this.filterDc.getItem()).setEvaluatedAfter(startTimeAfter.atZone(zone).toOffsetDateTime());
        } else {
            ((DecisionInstanceFilter)this.filterDc.getItem()).setEvaluatedAfter(null);
        }
        this.filterButton.getElement().setAttribute("activated", startTimeAfter != null || startTimeBefore != null);
    }

    protected Component createFilterComponent() {
        Component startTimeAfterFilter = this.createEvaluatedAfterFilter();
        Component startTimeBeforeFilter = this.createEvaluatedBeforeFilter();
        VerticalLayout rootLayout = (VerticalLayout)this.uiComponents.create(VerticalLayout.class);
        rootLayout.setPadding(false);
        rootLayout.setSpacing(false);
        rootLayout.add(new Component[]{startTimeAfterFilter, startTimeBeforeFilter});
        return rootLayout;
    }

    protected void resetFilterValues() {
        this.evaluatedAfter.clear();
        this.evaluatedBefore.clear();
    }

    private Component createEvaluatedBeforeFilter() {
        this.evaluatedBefore = (TypedDateTimePicker)this.uiComponents.create(TypedDateTimePicker.class);
        this.evaluatedBefore.setMax(LocalDateTime.now());
        this.evaluatedBefore.setDatePlaceholder(this.messages.getMessage(this.getClass(), "selectDate"));
        this.evaluatedBefore.setTimePlaceholder(this.messages.getMessage(this.getClass(), "selectTime"));
        this.evaluatedBefore.setLabel(this.messages.getMessage(this.getClass(), "evaluatedBefore.label"));
        this.setDefaultTime(this.evaluatedBefore);
        return this.evaluatedBefore;
    }

    private Component createEvaluatedAfterFilter() {
        this.evaluatedAfter = (TypedDateTimePicker)this.uiComponents.create(TypedDateTimePicker.class);
        this.evaluatedAfter.setMax(LocalDateTime.now());
        this.evaluatedAfter.setDatePlaceholder(this.messages.getMessage(this.getClass(), "selectDate"));
        this.evaluatedAfter.setTimePlaceholder(this.messages.getMessage(this.getClass(), "selectTime"));
        this.evaluatedAfter.setLabel(this.messages.getMessage(this.getClass(), "evaluatedAfter.label"));
        this.setDefaultTime(this.evaluatedAfter);
        return this.evaluatedAfter;
    }

    private void setDefaultTime(TypedDateTimePicker<LocalDateTime> dateTimePicker) {
        dateTimePicker.getElement().executeJs("this.__datePicker.addEventListener('change', function(){this.__timePicker.value='00:00';}.bind(this));", new Serializable[0]);
    }
}

