/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.decisioninstance;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.TextRenderer;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteParameters;
import io.flowset.control.action.CopyComponentValueToClipboardAction;
import io.flowset.control.entity.activity.HistoricActivityInstanceData;
import io.flowset.control.entity.decisioninstance.HistoricDecisionInputInstanceShortData;
import io.flowset.control.entity.decisioninstance.HistoricDecisionInstanceShortData;
import io.flowset.control.entity.decisioninstance.HistoricDecisionOutputInstanceShortData;
import io.flowset.control.entity.processdefinition.ProcessDefinitionData;
import io.flowset.control.entity.processinstance.ProcessInstanceData;
import io.flowset.control.service.activity.ActivityService;
import io.flowset.control.service.decisiondefinition.DecisionDefinitionService;
import io.flowset.control.service.decisioninstance.DecisionInstanceService;
import io.flowset.control.service.processinstance.ProcessInstanceService;
import io.flowset.control.view.processdefinition.ProcessDefinitionDetailView;
import io.flowset.control.view.processinstance.ProcessInstanceDetailView;
import io.flowset.uikit.component.dmnviewer.command.ShowDecisionInstanceCmd;
import io.flowset.uikit.component.dmnviewer.model.DecisionInstanceOutputData;
import io.flowset.uikit.fragment.dmnviewer.DmnViewerFragment;
import io.jmix.core.LoadContext;
import io.jmix.flowui.ViewNavigators;
import io.jmix.flowui.component.textfield.TypedTextField;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.model.InstanceContainer;
import io.jmix.flowui.view.DefaultMainViewParent;
import io.jmix.flowui.view.DialogMode;
import io.jmix.flowui.view.EditedEntityContainer;
import io.jmix.flowui.view.Install;
import io.jmix.flowui.view.PrimaryDetailView;
import io.jmix.flowui.view.StandardDetailView;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.Supply;
import io.jmix.flowui.view.Target;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpm/decision-instances/:id", layout=DefaultMainViewParent.class)
@ViewController(id="bpm_DecisionInstance.detail")
@ViewDescriptor(value="decision-instance-detail-view.xml")
@EditedEntityContainer(value="decisionInstanceDc")
@DialogMode(width="50em", height="37.5em")
@PrimaryDetailView(value=HistoricDecisionInstanceShortData.class)
public class DecisionInstanceDetailView
extends StandardDetailView<HistoricDecisionInstanceShortData> {
    @Autowired
    private DecisionDefinitionService decisionDefinitionService;
    @Autowired
    private DecisionInstanceService decisionInstanceService;
    @Autowired
    private ViewNavigators viewNavigators;
    @Autowired
    private ProcessInstanceService processInstanceService;
    @Autowired
    private ActivityService activityService;
    @ViewComponent
    private InstanceContainer<HistoricDecisionInstanceShortData> decisionInstanceDc;
    @ViewComponent
    private DmnViewerFragment dmnViewerFragment;
    @ViewComponent
    private CopyComponentValueToClipboardAction copyToClipboardAction;
    @ViewComponent
    private TypedTextField<String> decisionInstanceIdTextField;
    @ViewComponent
    private HorizontalLayout detailActions;
    @ViewComponent
    private TypedTextField<Object> activityNameTextField;
    @ViewComponent
    private TypedTextField<Object> processBusinessKeyTextField;

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.detailActions.addClassNames(new String[]{"pt-s"});
    }

    @Subscribe
    public void onBeforeShow(View.BeforeShowEvent event) {
        this.dmnViewerFragment.initViewer();
        String dmnXml = this.decisionDefinitionService.getDmnXml(((HistoricDecisionInstanceShortData)this.decisionInstanceDc.getItem()).getDecisionDefinitionId());
        this.dmnViewerFragment.setDmnXml(dmnXml, (SerializableConsumer & Serializable)setDmnXmlJson -> this.dmnViewerFragment.showDecisionDefinition(((HistoricDecisionInstanceShortData)this.decisionInstanceDc.getItem()).getDecisionDefinitionKey(), (SerializableConsumer & Serializable)showDecisionDefinitionJson -> this.dmnViewerFragment.showDecisionInstance(this.createDecisionInstanceClientData((HistoricDecisionInstanceShortData)this.decisionInstanceDc.getItem()))));
        this.initAdditionalFields();
    }

    @Subscribe(id="copyDecisionInstanceId", subject="clickListener")
    public void onCopyDecisionInstanceIdClick(ClickEvent<JmixButton> event) {
        this.copyToClipboardAction.setTarget((HasValue)this.decisionInstanceIdTextField);
        this.copyToClipboardAction.actionPerform(event.getSource());
    }

    @Subscribe(id="viewProcessDefinition", subject="clickListener")
    public void onViewProcessDefinitionClick(ClickEvent<JmixButton> event) {
        this.viewNavigators.detailView((View)this, ProcessDefinitionData.class).withViewClass(ProcessDefinitionDetailView.class).withRouteParameters(new RouteParameters("id", ((HistoricDecisionInstanceShortData)this.getEditedEntity()).getProcessDefinitionId())).withBackwardNavigation(true).navigate();
    }

    @Subscribe(id="viewProcessInstance", subject="clickListener")
    public void onViewProcessInstanceClick(ClickEvent<JmixButton> event) {
        this.viewNavigators.detailView((View)this, ProcessInstanceData.class).withViewClass(ProcessInstanceDetailView.class).withRouteParameters(new RouteParameters("id", ((HistoricDecisionInstanceShortData)this.getEditedEntity()).getProcessInstanceId())).withBackwardNavigation(true).navigate();
    }

    @Supply(to="inputsDataGrid.value", subject="renderer")
    protected Renderer<HistoricDecisionInputInstanceShortData> inputValueRenderer() {
        return new TextRenderer((ItemLabelGenerator & Serializable)e -> e.getValue() != null ? e.getValue().toString() : null);
    }

    @Supply(to="outputsDataGrid.value", subject="renderer")
    protected Renderer<HistoricDecisionOutputInstanceShortData> outputValueRenderer() {
        return new TextRenderer((ItemLabelGenerator & Serializable)e -> e.getValue() != null ? e.getValue().toString() : null);
    }

    private ShowDecisionInstanceCmd createDecisionInstanceClientData(HistoricDecisionInstanceShortData decisionInstance) {
        ShowDecisionInstanceCmd decisionInstanceClientData = new ShowDecisionInstanceCmd();
        decisionInstanceClientData.setOutputDataList(decisionInstance.getOutputs().stream().map(output -> {
            DecisionInstanceOutputData result = new DecisionInstanceOutputData();
            result.setValue(output.getValue() != null ? output.getValue().toString() : "");
            result.setDataRowId(output.getRuleId());
            result.setDataColId(output.getClauseId());
            return result;
        }).toList());
        return decisionInstanceClientData;
    }

    @Install(to="decisionInstanceDl", target=Target.DATA_LOADER)
    private HistoricDecisionInstanceShortData decisionDefinitionDlDelegate(LoadContext<HistoricDecisionInstanceShortData> loadContext) {
        HistoricDecisionInstanceShortData item = (HistoricDecisionInstanceShortData)this.decisionInstanceDc.getItemOrNull();
        String id = item == null ? Objects.requireNonNull(loadContext.getId()).toString() : item.getId();
        return this.decisionInstanceService.getById(id);
    }

    private void initAdditionalFields() {
        ProcessInstanceData processInstanceData;
        HistoricActivityInstanceData activityInstanceData;
        HistoricDecisionInstanceShortData decisionInstanceDcItem = (HistoricDecisionInstanceShortData)this.decisionInstanceDc.getItem();
        if (decisionInstanceDcItem.getActivityInstanceId() != null && (activityInstanceData = this.activityService.findById(decisionInstanceDcItem.getActivityInstanceId())) != null) {
            this.activityNameTextField.setTypedValue((Object)activityInstanceData.getActivityName());
        }
        if (decisionInstanceDcItem.getProcessInstanceId() != null && (processInstanceData = this.processInstanceService.getProcessInstanceById(decisionInstanceDcItem.getProcessInstanceId())) != null) {
            this.processBusinessKeyTextField.setTypedValue((Object)processInstanceData.getBusinessKey());
        }
    }
}

