/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.decisiondeployment;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.H4;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.Tooltip;
import com.vaadin.flow.router.Route;
import io.flowset.control.dto.DmnDecisionDefinition;
import io.flowset.control.entity.decisiondefinition.DecisionDefinitionData;
import io.flowset.control.entity.filter.DecisionDefinitionFilter;
import io.flowset.control.exception.RemoteProcessEngineException;
import io.flowset.control.restsupport.camunda.ResourceReport;
import io.flowset.control.service.decisiondefinition.DecisionDefinitionLoadContext;
import io.flowset.control.service.decisiondefinition.DecisionDefinitionService;
import io.flowset.control.service.deployment.DeploymentContext;
import io.flowset.control.service.deployment.DeploymentService;
import io.flowset.control.util.BpmParseUtil;
import io.flowset.control.view.AbstractResourceDeploymentView;
import io.flowset.control.view.decisiondeployment.DecisionDeploymentConfirmContentFragment;
import io.flowset.control.view.main.MainView;
import io.flowset.uikit.component.dmnviewer.event.DmnXmlImportCompleteEvent;
import io.flowset.uikit.fragment.dmnviewer.DmnViewerFragment;
import io.jmix.core.Metadata;
import io.jmix.flowui.Dialogs;
import io.jmix.flowui.Fragments;
import io.jmix.flowui.Notifications;
import io.jmix.flowui.UiComponents;
import io.jmix.flowui.action.DialogAction;
import io.jmix.flowui.component.upload.FileUploadField;
import io.jmix.flowui.fragment.FragmentOwner;
import io.jmix.flowui.kit.action.Action;
import io.jmix.flowui.kit.action.ActionVariant;
import io.jmix.flowui.kit.component.ComponentUtils;
import io.jmix.flowui.kit.component.button.JmixButton;
import io.jmix.flowui.kit.component.upload.event.FileUploadSucceededEvent;
import io.jmix.flowui.view.MessageBundle;
import io.jmix.flowui.view.StandardOutcome;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.View;
import io.jmix.flowui.view.ViewComponent;
import io.jmix.flowui.view.ViewController;
import io.jmix.flowui.view.ViewDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Route(value="bpm/decision-deployment", layout=MainView.class)
@ViewController(value="bpm_DecisionDeploymentView")
@ViewDescriptor(value="decision-deployment-view.xml")
public class DecisionDeploymentView
extends AbstractResourceDeploymentView {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DecisionDeploymentView.class);
    @Autowired
    protected DeploymentService deploymentService;
    @Autowired
    protected Metadata metadata;
    @Autowired
    protected Notifications notifications;
    @Autowired
    protected UiComponents uiComponents;
    @Autowired
    protected Dialogs dialogs;
    @Autowired
    protected Fragments fragments;
    @Autowired
    protected DecisionDefinitionService decisionDefinitionService;
    @ViewComponent
    protected VerticalLayout previewVBox;
    @ViewComponent
    protected Span emptyPreviewText;
    @ViewComponent
    protected HorizontalLayout emptyPreviewHBox;
    @ViewComponent
    protected MessageBundle messageBundle;
    @ViewComponent
    protected JmixButton okBtn;
    @ViewComponent
    protected HorizontalLayout decisionInfoHBox;
    @ViewComponent
    protected Icon decisionCountInfoIcon;
    @ViewComponent
    protected H4 collaborationLabel;
    @ViewComponent
    protected Span decisionCountLabel;
    @ViewComponent
    protected H4 decisionLabel;
    @ViewComponent
    protected Span decisionIdLabel;
    @ViewComponent
    protected FileUploadField resourceUploadField;
    @ViewComponent
    protected DmnViewerFragment viewerFragment;
    protected List<DmnDecisionDefinition> decisionDefinitions = new ArrayList();

    @Subscribe
    public void onInit(View.InitEvent event) {
        this.resourceUploadField.addClassNames(new String[]{"pt-0"});
        this.initEmptyPreviewStyles();
        this.initDecisionInfoHBoxStyles();
        this.initDeploymentErrorsButton();
    }

    @Subscribe(id="okBtn", subject="clickListener")
    public void onOkBtnClick(ClickEvent<JmixButton> event) {
        byte[] uploadedXml = (byte[])this.resourceUploadField.getValue();
        if (uploadedXml == null) {
            this.notifications.create(this.messageBundle.getMessage("bpmnFileNotSelected")).withType(Notifications.Type.ERROR).show();
            return;
        }
        List existingDecisions = this.findExistingDecisionDefinitionsByKeys();
        ((Dialogs.OptionDialogBuilder)((Dialogs.OptionDialogBuilder)((Dialogs.OptionDialogBuilder)this.dialogs.createOptionDialog().withHeader(this.messageBundle.getMessage("createDeploymentConfirmDialog.header"))).withContent((Component)this.createConfirmDialogContent(existingDecisions))).withWidth("35em")).withActions(new Action[]{new DialogAction(DialogAction.Type.YES).withHandler(e -> this.deployBpmnXml(uploadedXml)).withText(this.messageBundle.getMessage("deploy")).withIcon(VaadinIcon.ROCKET).withVariant(ActionVariant.PRIMARY), new DialogAction(DialogAction.Type.CANCEL).withIcon(ComponentUtils.convertToIcon((VaadinIcon)VaadinIcon.BAN))}).open();
    }

    @Subscribe(value="resourceUploadField")
    public void onBpmnXmlUploadFieldComponentValueChange(AbstractField.ComponentValueChangeEvent<FileUploadField, ?> event) {
        boolean emptyValue = event.getValue() == null;
        this.viewerFragment.setVisible(!emptyValue);
        this.emptyPreviewHBox.setVisible(emptyValue);
        this.okBtn.setEnabled(!emptyValue);
        if (emptyValue) {
            this.decisionDefinitions = new ArrayList();
            this.decisionInfoHBox.setVisible(false);
        }
        this.errorsBtn.setVisible(false);
    }

    @Subscribe(value="resourceUploadField")
    public void onBpmnXmlUploadFieldFileUploadSucceeded(FileUploadSucceededEvent<FileUploadField> event) {
        if (this.resourceUploadField.getValue() != null) {
            String decisionDefinitionXml = new String((byte[])this.resourceUploadField.getValue(), StandardCharsets.UTF_8);
            this.viewerFragment.initViewer();
            this.viewerFragment.setDmnXml(decisionDefinitionXml);
            this.viewerFragment.addImportCompleteListener(arg_0 -> this.updateImportedDecisions(arg_0));
            this.viewerFragment.setVisible(true);
            this.emptyPreviewHBox.setVisible(false);
        }
        this.errorsBtn.setVisible(false);
    }

    @Subscribe(id="cancelBtn", subject="clickListener")
    public void onCancelBtnClick(ClickEvent<JmixButton> event) {
        this.close(StandardOutcome.CLOSE);
    }

    protected void initEmptyPreviewStyles() {
        this.previewVBox.addClassNames(new String[]{"border", "rounded-l", "border-contrast-20"});
        this.emptyPreviewText.addClassNames(new String[]{"text-secondary", "w-l", "h-l"});
    }

    protected void initDecisionInfoHBoxStyles() {
        this.decisionInfoHBox.addClassNames(new String[]{"ml-auto"});
        this.decisionCountLabel.addClassNames(new String[]{"text-l", "text-secondary", "font-medium"});
        this.decisionIdLabel.addClassNames(new String[]{"text-l", "text-secondary", "font-medium"});
        this.decisionCountInfoIcon.addClassNames(new String[]{"text-s", "text-primary"});
        this.setDecisionsCountTooltipClassName();
    }

    protected void deployBpmnXml(byte[] uploadedXml) {
        this.deploymentReportDc.setItem(null);
        String uploadedFileName = this.resourceUploadField.getUploadedFileName();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(uploadedXml);){
            DeploymentWithDefinitions result = this.deploymentService.createDeployment(new DeploymentContext().withResource(uploadedFileName, (InputStream)inputStream));
            List deployedDecisionDefinitions = result.getDeployedDecisionDefinitions();
            int size = CollectionUtils.size((Object)deployedDecisionDefinitions);
            this.notifications.create(this.messageBundle.formatMessage("decisionsDeployed", new Object[]{size})).withType(Notifications.Type.SUCCESS).withDuration(2000).show();
            this.close(StandardOutcome.SAVE);
        }
        catch (IOException ex) {
            log.error("Error on uploaded file reading ", (Throwable)ex);
            this.notifications.create(this.messageBundle.getMessage("errorOnUploadedFileReading")).withType(Notifications.Type.ERROR).withDuration(2000).show();
        }
        catch (RemoteProcessEngineException ex) {
            log.error("Error on decision deployment", (Throwable)ex);
            if (ex.isProcessEngineException()) {
                ResourceReport.ProblemDetails problemDetails = new ResourceReport.ProblemDetails();
                problemDetails.setMessage(ex.getResponseMessage());
                ResourceReport resourceReport = new ResourceReport();
                resourceReport.setErrors(List.of(problemDetails));
                this.handleResourceReport(resourceReport, uploadedFileName);
            }
            this.notifications.create(this.messageBundle.getMessage("decisionsNotDeployed"), ex.getMessage()).withType(Notifications.Type.ERROR).withDuration(2000).show();
        }
    }

    @Nullable
    protected List<DecisionDefinitionData> findExistingDecisionDefinitionsByKeys() {
        List<DecisionDefinitionData> existingDecisions = null;
        if (CollectionUtils.isNotEmpty((Collection)this.decisionDefinitions)) {
            Set decisionDefinitionKeys = this.decisionDefinitions.stream().map(DmnDecisionDefinition::getKey).collect(Collectors.toSet());
            DecisionDefinitionFilter decisionDefinitionFilter = (DecisionDefinitionFilter)this.metadata.create(DecisionDefinitionFilter.class);
            decisionDefinitionFilter.setLatestVersionOnly(Boolean.valueOf(true));
            List allDecisionDefinitions = this.decisionDefinitionService.findAll(new DecisionDefinitionLoadContext().setFilter(decisionDefinitionFilter));
            existingDecisions = allDecisionDefinitions.stream().filter(e -> decisionDefinitionKeys.contains(e.getKey())).toList();
        }
        return existingDecisions;
    }

    protected void updateImportedDecisions(DmnXmlImportCompleteEvent importCompleteEvent) {
        this.decisionDefinitions = BpmParseUtil.parseDecisionsDefinitionsJson((String)importCompleteEvent.getDecisionDefinitionsJson());
        this.updateDecisionsCountComponents();
    }

    protected void updateDecisionsCountComponents() {
        boolean multipleDecisionDefinitions;
        boolean hasDecisionDefinitions;
        boolean bl = hasDecisionDefinitions = !this.decisionDefinitions.isEmpty();
        if (!hasDecisionDefinitions) {
            this.decisionInfoHBox.setVisible(false);
            return;
        }
        boolean bl2 = multipleDecisionDefinitions = this.decisionDefinitions.size() > 1;
        if (multipleDecisionDefinitions) {
            Tooltip tooltip = this.decisionCountInfoIcon.getTooltip();
            String decisionDefinitionsString = this.getDecisionDefinitionsString();
            tooltip.setText(decisionDefinitionsString);
            this.decisionCountLabel.setText(this.messageBundle.formatMessage("collaborationDecisionsLabel", new Object[]{String.valueOf(this.decisionDefinitions.size())}));
        } else {
            this.decisionIdLabel.setText(((DmnDecisionDefinition)this.decisionDefinitions.get(0)).getKey());
        }
        this.decisionInfoHBox.setVisible(true);
        this.decisionCountInfoIcon.setVisible(multipleDecisionDefinitions);
        this.decisionCountLabel.setVisible(multipleDecisionDefinitions);
        this.collaborationLabel.setVisible(multipleDecisionDefinitions);
        this.decisionIdLabel.setVisible(!multipleDecisionDefinitions);
        this.decisionLabel.setVisible(!multipleDecisionDefinitions);
    }

    protected String getDecisionDefinitionsString() {
        return this.decisionDefinitions.stream().map(decisionDefinition -> {
            int idx = this.decisionDefinitions.indexOf(decisionDefinition) + 1;
            return this.messageBundle.formatMessage("importedDecisionsKeyAndName", new Object[]{idx, StringUtils.defaultIfEmpty((CharSequence)decisionDefinition.getKey(), (CharSequence)"-"), StringUtils.defaultIfEmpty((CharSequence)decisionDefinition.getName(), (CharSequence)"-")});
        }).collect(Collectors.joining("\n"));
    }

    protected void setDecisionsCountTooltipClassName() {
        this.decisionCountInfoIcon.getElement().executeJs("    if ($0.getElementsByTagName('vaadin-tooltip').length == 1) {\n       $0.getElementsByTagName('vaadin-tooltip')[0]._overlayElement.setAttribute(\n           'class','decision-tooltip');\n    } else {\n       const tooltips = document.getElementsByTagName('vaadin-tooltip');\n       for (let i=0; i<tooltips.length; i++ ) {\n           const tooltip = tooltips[i];\n           if (tooltip._overlayElement.id === $0.getAttribute('aria-describedBy')) {\n               tooltip._overlayElement.setAttribute('class','decision-tooltip')\n           }\n       }\n    }\n", new Serializable[]{this.decisionCountInfoIcon});
    }

    protected VerticalLayout createConfirmDialogContent(List<DecisionDefinitionData> existingDecisions) {
        DecisionDeploymentConfirmContentFragment fragment = (DecisionDeploymentConfirmContentFragment)this.fragments.create((FragmentOwner)this, DecisionDeploymentConfirmContentFragment.class);
        fragment.setExistingDecisions(existingDecisions);
        fragment.setDeployingDecisions(this.decisionDefinitions);
        return (VerticalLayout)fragment.getContent();
    }
}

