/*
 * Decompiled with CFR 0.152.
 */
package io.flowset.control.view.dashboard;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.dom.Style;
import io.flowset.control.entity.ProcessExecutionGraphEntry;
import io.flowset.control.view.dashboard.DashboardCard;
import io.jmix.chartsflowui.component.Chart;
import io.jmix.flowui.fragment.FragmentDescriptor;
import io.jmix.flowui.model.CollectionContainer;
import io.jmix.flowui.view.Subscribe;
import io.jmix.flowui.view.ViewComponent;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FragmentDescriptor(value="recent-activity-card-fragment.xml")
public class RecentActivityCardFragment
extends DashboardCard<VerticalLayout> {
    protected static final Logger log = LoggerFactory.getLogger(RecentActivityCardFragment.class);
    @ViewComponent
    protected CollectionContainer<ProcessExecutionGraphEntry> processExecutionsDc;
    @ViewComponent
    protected Chart processExecutionGraph;
    @ViewComponent
    protected VerticalLayout loadingBox;
    @ViewComponent
    protected FlexLayout chartContainer;

    @Subscribe
    protected void onAttachEvent(AttachEvent event) {
        this.initChart(List.of());
    }

    public void refresh(List<ProcessExecutionGraphEntry> weeklyStatistics) {
        this.updateComponents(false);
        this.initChart(weeklyStatistics);
    }

    protected void initChart(List<ProcessExecutionGraphEntry> weeklyStatistics) {
        this.processExecutionsDc.setItems(weeklyStatistics);
        String formatterFunction = this.generateLegendJsFormatter(weeklyStatistics);
        this.processExecutionGraph.getLegend().setFormatterFunction(formatterFunction);
    }

    protected void updateComponents(boolean loading) {
        this.loadingBox.setVisible(loading);
        this.chartContainer.getStyle().setDisplay(loading ? Style.Display.NONE : Style.Display.FLEX);
    }

    protected String generateLegendJsFormatter(List<ProcessExecutionGraphEntry> weeklyStatistics) {
        long startedTasksCount = weeklyStatistics.stream().mapToLong(ProcessExecutionGraphEntry::getStartedInstancesCount).sum();
        long completedTasksCount = weeklyStatistics.stream().mapToLong(ProcessExecutionGraphEntry::getCompletedInstancesCount).sum();
        String startTasksMsg = this.messageBundle.getMessage("startedInstancesLine.title");
        String startedTasksName = this.messageBundle.formatMessage("startedInstancesLine.countTitle", new Object[]{this.formattedCount(startedTasksCount)});
        String completedTasksMsg = this.messageBundle.getMessage("completedInstancesLine.title");
        String completedTasksName = this.messageBundle.formatMessage("completedInstancesLine.titleCount", new Object[]{this.formattedCount(completedTasksCount)});
        String formatterFunction = "function (name) {\n    if(name === '%s') return '%s';\n    if(name === '%s') return '%s';\n    return name;\n  }\n";
        return String.format(formatterFunction, startTasksMsg, startedTasksName, completedTasksMsg, completedTasksName);
    }
}

